/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.dnie;

import es.gob.jmulticard.CryptoHelper;
import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.apdu.connection.cwa14890.Cwa14890OneV2Connection;
import es.gob.jmulticard.card.CryptoCardException;
import es.gob.jmulticard.card.Location;
import es.gob.jmulticard.card.PasswordCallbackNotFoundException;
import es.gob.jmulticard.card.PinException;
import es.gob.jmulticard.card.PrivateKeyReference;
import es.gob.jmulticard.card.dnie.Dnie;
import es.gob.jmulticard.card.dnie.Dnie3Dg01Mrz;
import es.gob.jmulticard.card.dnie.Dnie3PinCwa14890Constants;
import es.gob.jmulticard.card.dnie.Dnie3UsrCwa14890Constants;
import es.gob.jmulticard.card.dnie.DniePrivateKeyReference;
import es.gob.jmulticard.card.iso7816four.Iso7816FourCardException;
import java.io.IOException;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;

public class Dnie3
extends Dnie {
    private static final Location FILE_DG01_LOCATION_MRZ = new Location("3F010101");
    private static final Location FILE_DG02_LOCATION_PHOTO = new Location("3F010102");
    private static final Location FILE_DG07_LOCATION_SIGN = new Location("3F010107");
    private static final Location FILE_DG11_LOCATION = new Location("3F01010B");
    private static final Location FILE_DG12_LOCATION = new Location("3F01010C");
    private static final Location FILE_DG13_LOCATION = new Location("3F01010D");
    private static final Location FILE_DG14_LOCATION = new Location("3F01010E");
    private static final Location FILE_SOD_LOCATION = new Location("3F01011D");
    private static final Location FILE_COM_LOCATION = new Location("3F01011E");
    private static final String JPEG2K_HEADER = "0000000C6A502020";

    public byte[] getDg1() throws IOException {
        try {
            return this.selectFileByLocationAndRead(FILE_DG01_LOCATION_MRZ);
        }
        catch (Iso7816FourCardException e) {
            throw new CryptoCardException("Error leyendo el DG1 del DNIe: " + e, e);
        }
    }

    public byte[] getDg2() throws IOException {
        try {
            return this.selectFileByLocationAndRead(FILE_DG02_LOCATION_PHOTO);
        }
        catch (Iso7816FourCardException e) {
            throw new CryptoCardException("Error leyendo el DG2 del DNIe: " + e, e);
        }
    }

    public byte[] getDg7() throws IOException {
        try {
            return this.selectFileByLocationAndRead(FILE_DG07_LOCATION_SIGN);
        }
        catch (Iso7816FourCardException e) {
            throw new CryptoCardException("Error leyendo el DG7 del DNIe: " + e, e);
        }
    }

    public byte[] getDg11() throws IOException {
        try {
            return this.selectFileByLocationAndRead(FILE_DG11_LOCATION);
        }
        catch (Iso7816FourCardException e) {
            throw new CryptoCardException("Error leyendo el DG11 del DNIe: " + e, e);
        }
    }

    public byte[] getDg12() throws IOException {
        try {
            return this.selectFileByLocationAndRead(FILE_DG12_LOCATION);
        }
        catch (Iso7816FourCardException e) {
            throw new CryptoCardException("Error leyendo el DG12 del DNIe: " + e, e);
        }
    }

    public byte[] getDg13() throws IOException {
        try {
            return this.selectFileByLocationAndRead(FILE_DG13_LOCATION);
        }
        catch (Iso7816FourCardException e) {
            throw new CryptoCardException("Error leyendo el DG13 del DNIe: " + e, e);
        }
    }

    public byte[] getDg14() throws IOException {
        try {
            return this.selectFileByLocationAndRead(FILE_DG14_LOCATION);
        }
        catch (Iso7816FourCardException e) {
            throw new CryptoCardException("Error leyendo el DG14 del DNIe: " + e, e);
        }
    }

    public byte[] getSOD() throws IOException {
        try {
            return this.selectFileByLocationAndRead(FILE_SOD_LOCATION);
        }
        catch (Iso7816FourCardException e) {
            throw new CryptoCardException("Error leyendo el DG11 del DNIe: " + e, e);
        }
    }

    public byte[] getCOM() throws IOException {
        try {
            return this.selectFileByLocationAndRead(FILE_COM_LOCATION);
        }
        catch (Iso7816FourCardException e) {
            throw new CryptoCardException("Error leyendo el DG11 del DNIe: " + e, e);
        }
    }

    public byte[] getSubjectPhotoAsJpeg2k() throws IOException {
        byte[] photo = this.getDg2();
        return Dnie3.extractImage(photo);
    }

    public Dnie3Dg01Mrz getMrz() throws IOException {
        byte[] mrz = this.getDg1();
        return new Dnie3Dg01Mrz(mrz);
    }

    public byte[] getSubjectSignatureImageAsJpeg2k() throws IOException {
        byte[] photo = this.getDg7();
        return Dnie3.extractImage(photo);
    }

    private static final byte[] extractImage(byte[] photo) {
        if (photo == null) {
            throw new IllegalArgumentException("Los datos de entrada no pueden ser nulos");
        }
        int headerSize = HexUtils.hexify(photo, false).indexOf(JPEG2K_HEADER) / 2;
        byte[] pj2kPhoto = new byte[photo.length - headerSize];
        System.arraycopy(photo, headerSize, pj2kPhoto, 0, pj2kPhoto.length);
        return pj2kPhoto;
    }

    @Override
    public String getCardName() {
        return "DNIe 3.0";
    }

    Dnie3(ApduConnection conn, PasswordCallback pwc, CryptoHelper cryptoHelper, CallbackHandler ch, boolean loadCertsAndKeys) throws ApduConnectionException {
        super(conn, pwc, cryptoHelper, ch, loadCertsAndKeys);
        this.rawConnection = conn;
    }

    Dnie3(ApduConnection conn, PasswordCallback pwc, CryptoHelper cryptoHelper, CallbackHandler ch) throws ApduConnectionException {
        this(conn, pwc, cryptoHelper, ch, true);
    }

    public ApduConnection openUserChannel() throws CryptoCardException {
        Cwa14890OneV2Connection usrSecureConnection = new Cwa14890OneV2Connection(this, this.getConnection(), this.getCryptoHelper(), new Dnie3UsrCwa14890Constants(), new Dnie3UsrCwa14890Constants());
        try {
            this.selectMasterFile();
        }
        catch (Exception e) {
            throw new CryptoCardException("Error seleccionado el MF tras el establecimiento del canal seguro de usuario: " + e, e);
        }
        try {
            this.setConnection(usrSecureConnection);
        }
        catch (ApduConnectionException e) {
            throw new CryptoCardException("Error en el establecimiento del canal seguro de usuario: " + e, e);
        }
        return this.getConnection();
    }

    @Override
    public void openSecureChannelIfNotAlreadyOpened() throws CryptoCardException, PinException {
        if (this.isSecurityChannelOpen()) {
            return;
        }
        try {
            this.setConnection(this.rawConnection);
        }
        catch (ApduConnectionException e) {
            throw new CryptoCardException("Error en el establecimiento del canal inicial previo al seguro de PIN: " + e, e);
        }
        Cwa14890OneV2Connection pinSecureConnection = new Cwa14890OneV2Connection(this, this.getConnection(), this.getCryptoHelper(), new Dnie3PinCwa14890Constants(), new Dnie3PinCwa14890Constants());
        try {
            this.selectMasterFile();
        }
        catch (Exception e) {
            throw new CryptoCardException("Error seleccionado el MF tras el establecimiento del canal seguro de PIN: " + e, e);
        }
        try {
            this.setConnection(pinSecureConnection);
        }
        catch (ApduConnectionException e) {
            throw new CryptoCardException("Error en el establecimiento del canal seguro de PIN: " + e, e);
        }
        LOGGER.info("Canal seguro de PIN para DNIe establecido");
        try {
            this.verifyPin(this.getInternalPasswordCallback());
        }
        catch (PasswordCallbackNotFoundException e) {
            LOGGER.info("No se proporcionaron medios para verificar el canal de PIN.");
        }
        catch (ApduConnectionException e) {
            throw new CryptoCardException("Error en la verificacion de PIN: " + e, e);
        }
        Cwa14890OneV2Connection usrSecureConnection = new Cwa14890OneV2Connection(this, this.getConnection(), this.getCryptoHelper(), new Dnie3UsrCwa14890Constants(), new Dnie3UsrCwa14890Constants());
        try {
            this.selectMasterFile();
        }
        catch (Exception e) {
            throw new CryptoCardException("Error seleccionado el MF tras el establecimiento del canal seguro de usuario: " + e, e);
        }
        try {
            this.setConnection(usrSecureConnection);
        }
        catch (ApduConnectionException e) {
            throw new CryptoCardException("Error en el establecimiento del canal seguro de usuario: " + e, e);
        }
        LOGGER.info("Canal seguro de Usuario para DNIe establecido");
    }

    @Override
    protected byte[] signInternal(byte[] data, String signAlgorithm, PrivateKeyReference privateKeyReference) throws CryptoCardException, PinException {
        if (!(privateKeyReference instanceof DniePrivateKeyReference)) {
            throw new IllegalArgumentException("La referencia a la clave privada tiene que ser de tipo DniePrivateKeyReference");
        }
        return this.signOperation(data, signAlgorithm, privateKeyReference);
    }

    @Override
    protected void loadCertificates() throws CryptoCardException, PinException {
        this.openSecureChannelIfNotAlreadyOpened();
        this.loadCertificatesInternal();
    }
}

