/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.dnie;

import es.gob.jmulticard.CancelledOperationException;
import es.gob.jmulticard.CryptoHelper;
import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.CommandApdu;
import es.gob.jmulticard.apdu.ResponseApdu;
import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.apdu.connection.LostChannelException;
import es.gob.jmulticard.apdu.connection.cwa14890.Cwa14890Connection;
import es.gob.jmulticard.apdu.connection.cwa14890.Cwa14890OneV1Connection;
import es.gob.jmulticard.apdu.connection.cwa14890.SecureChannelException;
import es.gob.jmulticard.apdu.dnie.ChangePINApduCommand;
import es.gob.jmulticard.apdu.dnie.GetChipInfoApduCommand;
import es.gob.jmulticard.apdu.dnie.RetriesLeftApduCommand;
import es.gob.jmulticard.apdu.dnie.VerifyApduCommand;
import es.gob.jmulticard.apdu.iso7816eight.PsoSignHashApduCommand;
import es.gob.jmulticard.apdu.iso7816four.ExternalAuthenticateApduCommand;
import es.gob.jmulticard.apdu.iso7816four.InternalAuthenticateApduCommand;
import es.gob.jmulticard.apdu.iso7816four.MseSetAuthenticationKeyApduCommand;
import es.gob.jmulticard.apdu.iso7816four.MseSetComputationApduCommand;
import es.gob.jmulticard.asn1.der.pkcs1.DigestInfo;
import es.gob.jmulticard.asn1.der.pkcs15.Cdf;
import es.gob.jmulticard.asn1.der.pkcs15.PrKdf;
import es.gob.jmulticard.callback.CustomAuthorizeCallback;
import es.gob.jmulticard.card.AuthenticationModeLockedException;
import es.gob.jmulticard.card.BadPinException;
import es.gob.jmulticard.card.CardMessages;
import es.gob.jmulticard.card.CompressionUtils;
import es.gob.jmulticard.card.CryptoCardException;
import es.gob.jmulticard.card.Location;
import es.gob.jmulticard.card.PasswordCallbackNotFoundException;
import es.gob.jmulticard.card.PinException;
import es.gob.jmulticard.card.PrivateKeyReference;
import es.gob.jmulticard.card.cwa14890.Cwa14890Card;
import es.gob.jmulticard.card.cwa14890.Cwa14890PrivateConstants;
import es.gob.jmulticard.card.cwa14890.Cwa14890PublicConstants;
import es.gob.jmulticard.card.dnie.CacheElement;
import es.gob.jmulticard.card.dnie.Dni;
import es.gob.jmulticard.card.dnie.DnieCardException;
import es.gob.jmulticard.card.dnie.DnieCwa14890Constants;
import es.gob.jmulticard.card.dnie.DniePrivateKeyReference;
import es.gob.jmulticard.card.dnie.DnieSubjectPrincipalParser;
import es.gob.jmulticard.card.iso7816eight.Iso7816EightCard;
import es.gob.jmulticard.card.iso7816four.Iso7816FourCardException;
import es.gob.jmulticard.card.pace.PaceConnection;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class Dnie
extends Iso7816EightCard
implements Dni,
Cwa14890Card {
    private static final int DEFAULT_KEY_SIZE = 2048;
    protected static final Logger LOGGER = Logger.getLogger("es.gob.jmulticard");
    private static final byte ERROR_PIN_SW1 = 99;
    private CallbackHandler callbackHandler;
    private String[] aliases = null;
    private static final boolean PIN_AUTO_RETRY = true;
    private static final byte[] CERT_ICC_FILE_ID = new byte[]{96, 31};
    private static final String MASTER_FILE_NAME = "Master.File";
    public static final String CERT_ALIAS_AUTH = "CertAutenticacion";
    public static final String CERT_ALIAS_SIGN = "CertFirmaDigital";
    private static final String CERT_ALIAS_SIGNALIAS = "CertFirmaSeudonimo";
    private static final String CERT_ALIAS_CYPHER = "CertCifrado";
    private static final String CERT_ALIAS_INTERMEDIATE_CA = "CertCAIntermediaDGP";
    private static final String AUTH_KEY_LABEL = "KprivAutenticacion";
    private static final String SIGN_KEY_LABEL = "KprivFirmaDigital";
    private static final String CYPH_KEY_LABEL = "KprivCifrado";
    protected static final Location CDF_LOCATION = new Location("50156004");
    protected static final Location PRKDF_LOCATION = new Location("50156001");
    private X509Certificate authCert;
    private X509Certificate signCert;
    private X509Certificate cyphCert;
    private X509Certificate signAliasCert;
    private X509Certificate intermediateCaCert;
    private Location authCertPath;
    private Location signCertPath;
    private Location cyphCertPath = null;
    private Location signAliasCertPath = null;
    private DniePrivateKeyReference authKeyRef;
    private DniePrivateKeyReference signKeyRef;
    private DniePrivateKeyReference cyphKeyRef = null;
    private DniePrivateKeyReference signAliasKeyRef = null;
    protected ApduConnection rawConnection;
    protected final CryptoHelper cryptoHelper;
    private PasswordCallback passwordCallback;

    protected Cwa14890PublicConstants getCwa14890PublicConstants() {
        return new DnieCwa14890Constants();
    }

    protected Cwa14890PrivateConstants getCwa14890PrivateConstants() {
        return new DnieCwa14890Constants();
    }

    protected CryptoHelper getCryptoHelper() {
        return this.cryptoHelper;
    }

    protected PasswordCallback getPasswordCallback() {
        return this.passwordCallback;
    }

    public String toString() {
        try {
            Cdf cdf = this.getCdf();
            return this.getCardName() + "\n" + new DnieSubjectPrincipalParser(cdf.getCertificateSubjectPrincipal(0)).toString();
        }
        catch (ApduConnectionException e) {
            LOGGER.warning("No se ha podido leer el CDF del DNIe: " + e);
            return this.getCardName();
        }
    }

    public static void connect(ApduConnection conn) throws ApduConnectionException {
        if (!conn.isOpen()) {
            conn.open();
        }
    }

    Dnie(ApduConnection conn, PasswordCallback pwc, CryptoHelper cryptoHelper, CallbackHandler ch) throws ApduConnectionException {
        this(conn, pwc, cryptoHelper, ch, true);
    }

    protected Dnie(ApduConnection conn, PasswordCallback pwc, CryptoHelper cryptoHelper, CallbackHandler ch, boolean loadCertsAndKeys) throws ApduConnectionException {
        super((byte)0, conn);
        conn.reset();
        Dnie.connect(conn);
        this.rawConnection = conn;
        this.callbackHandler = ch;
        try {
            this.selectMasterFile();
        }
        catch (Iso7816FourCardException e) {
            LOGGER.warning("No se ha podido seleccionar el directorio raiz antes de leer las estructuras: " + e);
        }
        this.passwordCallback = pwc;
        if (cryptoHelper == null) {
            throw new IllegalArgumentException("El CryptoHelper no puede ser nulo");
        }
        this.cryptoHelper = cryptoHelper;
        if (loadCertsAndKeys) {
            this.preloadCertificates();
            this.loadKeyReferences();
        }
    }

    protected void loadKeyReferences() {
        PrKdf prKdf = new PrKdf();
        try {
            prKdf.setDerValue(this.selectFileByLocationAndRead(PRKDF_LOCATION));
        }
        catch (Exception e) {
            throw new IllegalStateException("No se ha podido cargar el PrKDF de la tarjeta: " + e.toString());
        }
        for (int i = 0; i < prKdf.getKeyCount(); ++i) {
            if (AUTH_KEY_LABEL.equals(prKdf.getKeyName(i))) {
                this.authKeyRef = new DniePrivateKeyReference(this, prKdf.getKeyIdentifier(i), new Location(prKdf.getKeyPath(i)), AUTH_KEY_LABEL, prKdf.getKeyReference(i), 2048);
                continue;
            }
            if (SIGN_KEY_LABEL.equals(prKdf.getKeyName(i))) {
                this.signKeyRef = new DniePrivateKeyReference(this, prKdf.getKeyIdentifier(i), new Location(prKdf.getKeyPath(i)), SIGN_KEY_LABEL, prKdf.getKeyReference(i), 2048);
                continue;
            }
            if (CYPH_KEY_LABEL.equals(prKdf.getKeyName(i))) {
                this.cyphKeyRef = new DniePrivateKeyReference(this, prKdf.getKeyIdentifier(i), new Location(prKdf.getKeyPath(i)), CYPH_KEY_LABEL, prKdf.getKeyReference(i), 2048);
                continue;
            }
            this.signAliasKeyRef = new DniePrivateKeyReference(this, prKdf.getKeyIdentifier(i), new Location(prKdf.getKeyPath(i)), prKdf.getKeyName(i), prKdf.getKeyReference(i), 2048);
        }
    }

    @Override
    public byte[] getSerialNumber() throws ApduConnectionException {
        ResponseApdu response = this.getConnection().transmit(new GetChipInfoApduCommand());
        if (response.isOk()) {
            return response.getData();
        }
        throw new ApduConnectionException("Respuesta invalida en la obtencion del numero de serie con el codigo: " + response.getStatusWord());
    }

    @Override
    public String getCardName() {
        return "DNIe";
    }

    @Override
    public String[] getAliases() {
        if (this.aliases == null) {
            ArrayList<String> aliasesList = new ArrayList<String>();
            aliasesList.add(CERT_ALIAS_AUTH);
            aliasesList.add(CERT_ALIAS_SIGN);
            if (this.cyphCertPath != null) {
                aliasesList.add(CERT_ALIAS_CYPHER);
            }
            if (this.signAliasCertPath != null) {
                aliasesList.add(CERT_ALIAS_SIGNALIAS);
            }
            this.aliases = aliasesList.toArray(new String[0]);
        }
        return this.aliases;
    }

    public Cdf getCdf() throws ApduConnectionException {
        Cdf cdf = new Cdf();
        try {
            this.selectMasterFile();
            byte[] cdfBytes = this.selectFileByLocationAndRead(CDF_LOCATION);
            cdf.setDerValue(cdfBytes);
        }
        catch (Exception e) {
            throw new ApduConnectionException("No se ha podido cargar el CDF de la tarjeta: " + e.toString(), e);
        }
        return cdf;
    }

    protected void preloadCertificates() throws ApduConnectionException {
        Cdf cdf = this.getCdf();
        for (int i = 0; i < cdf.getCertificateCount(); ++i) {
            String currentAlias = cdf.getCertificateAlias(i);
            if (CERT_ALIAS_AUTH.equals(currentAlias)) {
                this.authCertPath = new Location(cdf.getCertificatePath(i));
                continue;
            }
            if (CERT_ALIAS_SIGN.equals(currentAlias)) {
                this.signCertPath = new Location(cdf.getCertificatePath(i));
                continue;
            }
            if (CERT_ALIAS_CYPHER.equals(currentAlias)) {
                this.cyphCertPath = new Location(cdf.getCertificatePath(i));
                continue;
            }
            if (CERT_ALIAS_INTERMEDIATE_CA.equals(currentAlias)) {
                try {
                    byte[] intermediateCaCertEncoded = this.selectFileByLocationAndRead(new Location(cdf.getCertificatePath(i)));
                    this.intermediateCaCert = CompressionUtils.getCertificateFromCompressedOrNotData(intermediateCaCertEncoded);
                }
                catch (Exception e) {
                    LOGGER.warning("No se ha podido cargar el certificado de la autoridad intermedia del CNP: " + e);
                    this.intermediateCaCert = null;
                }
                continue;
            }
            this.signAliasCertPath = new Location(cdf.getCertificatePath(i));
        }
    }

    @Override
    public X509Certificate getCertificate(String alias) throws CryptoCardException, PinException {
        if (this.authCert == null) {
            this.loadCertificates();
        }
        if (CERT_ALIAS_AUTH.equals(alias)) {
            return this.authCert;
        }
        if (CERT_ALIAS_SIGN.equals(alias)) {
            return this.signCert;
        }
        if (CERT_ALIAS_INTERMEDIATE_CA.equals(alias)) {
            return this.intermediateCaCert;
        }
        if (CERT_ALIAS_CYPHER.equals(alias)) {
            return this.cyphCert;
        }
        if (CERT_ALIAS_SIGNALIAS.equals(alias)) {
            return this.signAliasCert;
        }
        return null;
    }

    @Override
    public void verifyCaIntermediateIcc() {
    }

    @Override
    public void verifyIcc() {
    }

    @Override
    public byte[] getIccCertEncoded() throws IOException {
        byte[] iccCertEncoded;
        try {
            this.selectMasterFile();
            iccCertEncoded = this.selectFileByIdAndRead(CERT_ICC_FILE_ID);
        }
        catch (ApduConnectionException e) {
            throw new IOException("Error en el envio de APDU para la seleccion del certificado de componente de la tarjeta: " + e, e);
        }
        catch (Iso7816FourCardException e) {
            throw new IOException("Error en la seleccion del certificado de componente de la tarjeta: " + e, e);
        }
        return iccCertEncoded;
    }

    @Override
    public void verifyIfdCertificateChain(Cwa14890PublicConstants consts) throws ApduConnectionException {
        try {
            this.setPublicKeyToVerification(consts.getRefCCvCaPublicKey());
        }
        catch (SecureChannelException e) {
            throw new SecureChannelException("Error al seleccionar para verificacion la clave publica de la CA raiz de los certificados verificables por la tarjeta", e);
        }
        try {
            this.verifyCertificate(consts.getCCvCa());
        }
        catch (SecureChannelException e) {
            throw new SecureChannelException("Error en la verificacion del certificado de la CA intermedia de Terminal: " + e, e);
        }
        try {
            this.setPublicKeyToVerification(consts.getChrCCvCa());
        }
        catch (SecureChannelException e) {
            throw new SecureChannelException("Error al establecer la clave publica del certificado de CA intermedia de Terminal para su verificacion en tarjeta: " + e, e);
        }
        try {
            this.verifyCertificate(consts.getCCvIfd());
        }
        catch (SecureChannelException e) {
            throw new SecureChannelException("Error en la verificacion del certificado de Terminal: " + e, e);
        }
    }

    @Override
    public byte[] getRefIccPrivateKey(Cwa14890PublicConstants consts) {
        return consts.getRefIccPrivateKey();
    }

    @Override
    public byte[] getChrCCvIfd(Cwa14890PublicConstants consts) {
        return consts.getChrCCvIfd();
    }

    @Override
    public RSAPrivateKey getIfdPrivateKey(Cwa14890PrivateConstants consts) {
        return consts.getIfdPrivateKey();
    }

    @Override
    public void setKeysToAuthentication(byte[] refPublicKey, byte[] refPrivateKey) throws ApduConnectionException {
        MseSetAuthenticationKeyApduCommand apdu = new MseSetAuthenticationKeyApduCommand(0, refPublicKey, refPrivateKey);
        ResponseApdu res = this.getConnection().transmit(apdu);
        if (!res.isOk()) {
            throw new SecureChannelException("Error durante el establecimiento de las claves publica y privada para atenticacion (error: " + HexUtils.hexify(res.getBytes(), true) + ")");
        }
    }

    @Override
    public byte[] getInternalAuthenticateMessage(byte[] randomIfd, byte[] chrCCvIfd) throws ApduConnectionException {
        InternalAuthenticateApduCommand apdu = new InternalAuthenticateApduCommand(0, randomIfd, chrCCvIfd);
        ResponseApdu res = this.getConnection().transmit(apdu);
        if (res.isOk()) {
            return res.getData();
        }
        throw new ApduConnectionException("Respuesta invalida en la obtencion del mensaje de autenticacion interna con el codigo: " + res.getStatusWord());
    }

    @Override
    public boolean externalAuthentication(byte[] extAuthenticationData) throws ApduConnectionException {
        ExternalAuthenticateApduCommand apdu = new ExternalAuthenticateApduCommand(0, extAuthenticationData);
        return this.getConnection().transmit(apdu).isOk();
    }

    @Override
    public PrivateKeyReference getPrivateKey(String alias) {
        if (CERT_ALIAS_AUTH.equals(alias)) {
            return this.authKeyRef;
        }
        if (CERT_ALIAS_SIGN.equals(alias)) {
            return this.signKeyRef;
        }
        if (CERT_ALIAS_CYPHER.equals(alias)) {
            return this.cyphKeyRef;
        }
        if (CERT_ALIAS_SIGNALIAS.equals(alias)) {
            return this.signAliasKeyRef;
        }
        return null;
    }

    @Override
    public byte[] sign(byte[] data, String signAlgorithm, PrivateKeyReference privateKeyReference) throws CryptoCardException, PinException {
        byte[] ret = this.signInternal(data, signAlgorithm, privateKeyReference);
        try {
            this.rawConnection.reset();
            this.setConnection(this.rawConnection);
        }
        catch (ApduConnectionException e) {
            throw new CryptoCardException("Error en el establecimiento del canal inicial previo al seguro de PIN: " + e, e);
        }
        return ret;
    }

    protected byte[] signInternal(byte[] data, String signAlgorithm, PrivateKeyReference privateKeyReference) throws CryptoCardException, PinException {
        if (!(privateKeyReference instanceof DniePrivateKeyReference)) {
            throw new IllegalArgumentException("La referencia a la clave privada tiene que ser de tipo DniePrivateKeyReference");
        }
        if (this.needAuthorizationToSign()) {
            if (this.callbackHandler != null) {
                CustomAuthorizeCallback cc = new CustomAuthorizeCallback();
                try {
                    this.callbackHandler.handle(new Callback[]{cc});
                }
                catch (UnsupportedCallbackException e) {
                    LOGGER.warning("No se ha proporcionado un CallbackHandler valido para mostrar el dialogo de confirmacion de firma, se omitira: " + e);
                }
                catch (Exception e) {
                    throw new AccessControlException("No ha sido posible pedir la confirmacion de firma al usuario: " + e);
                }
                if (!cc.isAuthorized()) {
                    throw new CancelledOperationException("El usuario ha denegado la operacion de firma");
                }
            } else {
                LOGGER.warning("No se ha proporcionado un CallbackHandler para mostrar el dialogo de confirmacion de firma. Se omitira.");
            }
        }
        return this.signOperation(data, signAlgorithm, privateKeyReference);
    }

    protected boolean needAuthorizationToSign() {
        return true;
    }

    protected byte[] signOperation(byte[] data, String signAlgorithm, PrivateKeyReference privateKeyReference) throws CryptoCardException, PinException {
        ResponseApdu res;
        this.openSecureChannelIfNotAlreadyOpened();
        try {
            byte[] digestInfo;
            CommandApdu apdu = new MseSetComputationApduCommand(0, ((DniePrivateKeyReference)privateKeyReference).getKeyPath().getLastFilePath(), null);
            res = this.getConnection().transmit(apdu);
            if (!res.isOk()) {
                throw new DnieCardException("Error en el establecimiento de las clave de firma con respuesta: " + res.getStatusWord(), res.getStatusWord());
            }
            try {
                digestInfo = DigestInfo.encode(signAlgorithm, data, this.cryptoHelper);
            }
            catch (IOException e) {
                throw new DnieCardException("Error en el calculo de la huella para firmar: " + e, e);
            }
            apdu = new PsoSignHashApduCommand(0, digestInfo);
            res = this.getConnection().transmit(apdu);
            if (!res.isOk()) {
                throw new DnieCardException("Error durante la operacion de firma con respuesta: " + res.getStatusWord(), res.getStatusWord());
            }
        }
        catch (LostChannelException e) {
            try {
                this.getConnection().close();
                if (this.getConnection() instanceof Cwa14890Connection) {
                    this.setConnection(((Cwa14890Connection)this.getConnection()).getSubConnection());
                }
            }
            catch (Exception ex) {
                throw new DnieCardException("No se pudo recuperar el canal seguro para firmar: " + ex, ex);
            }
            return this.signOperation(data, signAlgorithm, privateKeyReference);
        }
        catch (ApduConnectionException e) {
            throw new DnieCardException("Error en la transmision de comandos a la tarjeta: " + e, e);
        }
        return res.getData();
    }

    public void openSecureChannelIfNotAlreadyOpened() throws CryptoCardException, PinException {
        if (!this.isSecurityChannelOpen()) {
            if (!(this.getConnection() instanceof Cwa14890Connection)) {
                Cwa14890OneV1Connection secureConnection = new Cwa14890OneV1Connection(this, this.getConnection(), this.cryptoHelper, this.getCwa14890PublicConstants(), this.getCwa14890PrivateConstants());
                try {
                    this.setConnection(secureConnection);
                }
                catch (ApduConnectionException e) {
                    throw new CryptoCardException("Error en el establecimiento del canal seguro: " + e, e);
                }
            }
            try {
                this.verifyPin(this.getInternalPasswordCallback());
            }
            catch (ApduConnectionException e) {
                throw new CryptoCardException("Error en la apertura del canal seguro: " + e, e);
            }
        }
    }

    private int getPinRetriesLeft() throws PinException {
        ResponseApdu verifyResponse;
        RetriesLeftApduCommand verifyCommandApdu = new RetriesLeftApduCommand();
        try {
            verifyResponse = this.getConnection().transmit(verifyCommandApdu);
        }
        catch (ApduConnectionException e) {
            throw new PinException("Error obteniendo el PIN del CallbackHandler: " + e);
        }
        return verifyResponse.getStatusWord().getLsb() - -64;
    }

    protected PasswordCallback getInternalPasswordCallback() throws PinException, PasswordCallbackNotFoundException {
        return this.getInternalPasswordCallback(false);
    }

    protected PasswordCallback getInternalPasswordCallback(boolean reset) throws PinException, PasswordCallbackNotFoundException {
        if (this.passwordCallback != null) {
            int retriesLeft = this.getPinRetriesLeft();
            if (retriesLeft == 0) {
                throw new AuthenticationModeLockedException();
            }
            return this.passwordCallback;
        }
        if (this.callbackHandler != null) {
            int retriesLeft;
            if (reset && this.callbackHandler instanceof CacheElement) {
                ((CacheElement)((Object)this.callbackHandler)).reset();
            }
            if ((retriesLeft = this.getPinRetriesLeft()) == 0) {
                throw new AuthenticationModeLockedException();
            }
            PasswordCallback pwc = new PasswordCallback(this.getPinMessage(retriesLeft), false);
            try {
                this.callbackHandler.handle(new Callback[]{pwc});
            }
            catch (IOException e) {
                throw new PinException("Error obteniendo el PIN del CallbackHandler: " + e, e);
            }
            catch (UnsupportedCallbackException e) {
                throw new PasswordCallbackNotFoundException("El CallbackHandler no soporta pedir el PIN al usuario: " + e, e);
            }
            if (pwc.getPassword() == null || pwc.getPassword().toString().isEmpty()) {
                throw new PinException("El PIN no puede ser nulo ni vacio");
            }
            return pwc;
        }
        throw new PasswordCallbackNotFoundException("No hay ningun metodo para obtener el PIN");
    }

    protected String getPinMessage(int retriesLeft) {
        return CardMessages.getString("Dnie.0", Integer.toString(retriesLeft));
    }

    private X509Certificate loadCertificate(Location location) throws IOException, Iso7816FourCardException, CertificateException {
        this.selectMasterFile();
        byte[] certEncoded = this.selectFileByLocationAndRead(location);
        return CompressionUtils.getCertificateFromCompressedOrNotData(certEncoded);
    }

    protected void loadCertificatesInternal() throws CryptoCardException {
        if (this.authCert == null || this.signCert == null || this.cyphCert == null && this.cyphCertPath != null || this.signAliasCert == null && this.signAliasCertPath != null) {
            try {
                this.signCert = this.loadCertificate(this.signCertPath);
                this.authCert = this.loadCertificate(this.authCertPath);
                if (this.cyphCertPath != null) {
                    this.cyphCert = this.loadCertificate(this.cyphCertPath);
                }
                if (this.signAliasCertPath != null) {
                    this.signAliasCert = this.loadCertificate(this.signAliasCertPath);
                }
            }
            catch (CertificateException e) {
                throw new CryptoCardException("Error al cargar los certificados del DNIe, no es posible obtener una factoria de certificados X.509: " + e, e);
            }
            catch (IOException e) {
                throw new CryptoCardException("Error al cargar los certificados del DNIe, error en la descompresion de los datos: " + e, e);
            }
            catch (Iso7816FourCardException e) {
                throw new CryptoCardException("Error al cargar los certificados del DNIe: " + e, e);
            }
        }
    }

    protected void loadCertificates() throws CryptoCardException, PinException {
        this.openSecureChannelIfNotAlreadyOpened();
        this.loadCertificatesInternal();
    }

    @Override
    protected void selectMasterFile() throws ApduConnectionException, Iso7816FourCardException {
        this.selectFileByName(MASTER_FILE_NAME);
    }

    protected boolean isSecurityChannelOpen() {
        return this.getConnection() instanceof Cwa14890Connection && this.getConnection().isOpen() && !(this.getConnection() instanceof PaceConnection);
    }

    @Override
    public void verifyPin(PasswordCallback psc) throws ApduConnectionException, PinException {
        if (psc == null) {
            throw new IllegalArgumentException("No se puede verificar el titular con un PasswordCallback nulo");
        }
        VerifyApduCommand verifyCommandApdu = new VerifyApduCommand(0, psc);
        ResponseApdu verifyResponse = this.getConnection().transmit(verifyCommandApdu);
        verifyCommandApdu = null;
        if (!verifyResponse.isOk()) {
            if (verifyResponse.getStatusWord().getMsb() == 99) {
                if (!PIN_AUTO_RETRY || psc.getClass().getName().endsWith("CachePasswordCallback")) {
                    throw new BadPinException(verifyResponse.getStatusWord().getLsb() - -64);
                }
                this.verifyPin(this.getInternalPasswordCallback(true));
            } else {
                if (verifyResponse.getStatusWord().getMsb() == 105 && verifyResponse.getStatusWord().getLsb() == -125) {
                    throw new AuthenticationModeLockedException();
                }
                if (verifyResponse.getStatusWord().getMsb() == 0 && verifyResponse.getStatusWord().getLsb() == 0) {
                    throw new ApduConnectionException("Se ha perdido el canal NFC");
                }
                throw new ApduConnectionException(new Iso7816FourCardException("Error en la verificacion de PIN (" + verifyResponse.getStatusWord() + ")", verifyResponse.getStatusWord()));
            }
        }
    }

    @Override
    public int getIfdKeyLength(Cwa14890PublicConstants consts) {
        return consts.getIfdKeyLength();
    }

    public byte[] changePIN(String oldPin, String newPin) throws CryptoCardException, PinException, AuthenticationModeLockedException {
        this.openSecureChannelIfNotAlreadyOpened();
        try {
            this.selectMasterFile();
            byte[] pinFile = new byte[]{0, 0};
            this.selectFileById(pinFile);
            ChangePINApduCommand apdu = new ChangePINApduCommand(oldPin.getBytes(), newPin.getBytes());
            ResponseApdu res = this.getConnection().transmit(apdu);
            if (!res.isOk()) {
                throw new DnieCardException("Error en el establecimiento de las variables de entorno para el cambio de PIN", res.getStatusWord());
            }
            return res.getData();
        }
        catch (LostChannelException e) {
            LOGGER.warning("Se ha perdido el canal seguro para cambiar el PIN, se procede a recuperarlo: " + e);
            try {
                this.getConnection().close();
                if (this.getConnection() instanceof Cwa14890Connection) {
                    this.setConnection(((Cwa14890Connection)this.getConnection()).getSubConnection());
                }
                return this.changePIN(oldPin, newPin);
            }
            catch (Exception ex) {
                throw new DnieCardException("No se pudo recuperar el canal seguro para firmar: " + ex, ex);
            }
        }
        catch (ApduConnectionException e) {
            throw new DnieCardException("Error en la transmision de comandos a la tarjeta: " + e, e);
        }
        catch (Iso7816FourCardException e) {
            throw new DnieCardException("No se pudo seleccionar el fichero de PIN de la tarjeta: " + e, e);
        }
    }

    public void setCallbackHandler(CallbackHandler handler) {
        this.callbackHandler = handler;
    }

    public void setPasswordCallback(PasswordCallback pwc) {
        this.passwordCallback = pwc;
    }
}

