/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.dnie;

import es.gob.jmulticard.CryptoHelper;
import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.CommandApdu;
import es.gob.jmulticard.apdu.ResponseApdu;
import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.apdu.connection.LostChannelException;
import es.gob.jmulticard.apdu.connection.cwa14890.Cwa14890Connection;
import es.gob.jmulticard.apdu.connection.cwa14890.Cwa14890OneV2Connection;
import es.gob.jmulticard.apdu.iso7816eight.PsoSignHashApduCommand;
import es.gob.jmulticard.apdu.iso7816four.MseSetComputationApduCommand;
import es.gob.jmulticard.asn1.Asn1Exception;
import es.gob.jmulticard.asn1.TlvException;
import es.gob.jmulticard.asn1.der.pkcs1.DigestInfo;
import es.gob.jmulticard.asn1.der.pkcs15.Cdf;
import es.gob.jmulticard.asn1.der.pkcs15.PrKdf;
import es.gob.jmulticard.card.Atr;
import es.gob.jmulticard.card.CardMessages;
import es.gob.jmulticard.card.CompressionUtils;
import es.gob.jmulticard.card.CryptoCardException;
import es.gob.jmulticard.card.InvalidCardException;
import es.gob.jmulticard.card.Location;
import es.gob.jmulticard.card.PinException;
import es.gob.jmulticard.card.PrivateKeyReference;
import es.gob.jmulticard.card.cwa14890.Cwa14890PrivateConstants;
import es.gob.jmulticard.card.cwa14890.Cwa14890PublicConstants;
import es.gob.jmulticard.card.dnie.CeresScCwa14890Constants;
import es.gob.jmulticard.card.dnie.Dnie;
import es.gob.jmulticard.card.dnie.DnieCardException;
import es.gob.jmulticard.card.dnie.DniePrivateKeyReference;
import es.gob.jmulticard.card.iso7816four.Iso7816FourCardException;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;

public final class CeresSc
extends Dnie {
    private static final byte[] ATR_MASK_TC = new byte[]{-1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, -1};
    private static final Atr ATR_TC = new Atr(new byte[]{59, 127, 0, 0, 0, 0, 106, 70, 78, 77, 84, 0, 0, 0, 0, 0, 0, 3, -112, 0}, ATR_MASK_TC);
    private Map<String, X509Certificate> certs;
    private Map<String, String> aliasByCertAndKeyId;
    private Map<String, DniePrivateKeyReference> keyReferences;

    public CeresSc(ApduConnection conn, PasswordCallback pwc, CryptoHelper cryptoHelper, CallbackHandler ch) throws ApduConnectionException, InvalidCardException {
        super(conn, pwc, cryptoHelper, ch);
        CeresSc.checkAtr(conn.reset());
    }

    @Override
    public X509Certificate getCertificate(String alias) {
        return this.certs.get(alias);
    }

    @Override
    protected byte[] signOperation(byte[] data, String algorithm, PrivateKeyReference privateKeyReference) throws CryptoCardException, PinException {
        ResponseApdu res;
        this.openSecureChannelIfNotAlreadyOpened();
        try {
            byte[] digestInfo;
            CommandApdu apdu = new MseSetComputationApduCommand(0, ((DniePrivateKeyReference)privateKeyReference).getKeyPath().getLastFilePath(), null);
            res = this.getConnection().transmit(apdu);
            if (!res.isOk()) {
                throw new DnieCardException("Error en el establecimiento de las clave de firma con respuesta: " + res.getStatusWord(), res.getStatusWord());
            }
            try {
                digestInfo = DigestInfo.encode(algorithm, data, this.cryptoHelper);
            }
            catch (IOException e) {
                throw new DnieCardException("Error en el calculo del hash para firmar: " + e, e);
            }
            apdu = new PsoSignHashApduCommand(0, digestInfo);
            res = this.getConnection().transmit(apdu);
            if (!res.isOk()) {
                throw new DnieCardException("Error durante la operacion de firma con respuesta: " + res.getStatusWord(), res.getStatusWord());
            }
        }
        catch (LostChannelException e) {
            try {
                this.getConnection().close();
                if (this.getConnection() instanceof Cwa14890Connection) {
                    this.setConnection(((Cwa14890Connection)this.getConnection()).getSubConnection());
                }
            }
            catch (Exception ex) {
                throw new DnieCardException("No se pudo recuperar el canal seguro para firmar: " + ex, ex);
            }
            return this.signOperation(data, algorithm, privateKeyReference);
        }
        catch (ApduConnectionException e) {
            throw new DnieCardException("Error en la transmision de comandos a la tarjeta: " + e, e);
        }
        return res.getData();
    }

    @Override
    protected Cwa14890PublicConstants getCwa14890PublicConstants() {
        return new CeresScCwa14890Constants();
    }

    @Override
    protected Cwa14890PrivateConstants getCwa14890PrivateConstants() {
        return new CeresScCwa14890Constants();
    }

    @Override
    protected void preloadCertificates() throws ApduConnectionException {
        try {
            this.preload();
        }
        catch (Exception e) {
            throw new ApduConnectionException("Error cargando las estructuras iniciales de la tarjeta: " + e, e);
        }
    }

    @Override
    protected void loadKeyReferences() {
    }

    @Override
    public String[] getAliases() {
        return this.certs.keySet().toArray(new String[0]);
    }

    @Override
    public PrivateKeyReference getPrivateKey(String alias) {
        return this.keyReferences.get(alias);
    }

    private void preload() throws ApduConnectionException, Iso7816FourCardException, IOException, CertificateException, Asn1Exception, TlvException {
        String alias;
        this.selectMasterFile();
        byte[] cdfBytes = this.selectFileByLocationAndRead(CDF_LOCATION);
        Cdf cdf = new Cdf();
        cdf.setDerValue(cdfBytes);
        this.certs = new LinkedHashMap<String, X509Certificate>(cdf.getCertificateCount());
        this.aliasByCertAndKeyId = new LinkedHashMap<String, String>(cdf.getCertificateCount());
        for (int i = 0; i < cdf.getCertificateCount(); ++i) {
            Location l = new Location(cdf.getCertificatePath(i).replace("\\", "").trim());
            X509Certificate cert = CompressionUtils.getCertificateFromCompressedOrNotData(this.selectFileByLocationAndRead(l));
            alias = i + " " + cert.getSerialNumber();
            this.aliasByCertAndKeyId.put(HexUtils.hexify(cdf.getCertificateId(i), false), alias);
            this.certs.put(alias, cert);
        }
        byte[] prkdfValue = this.selectFileByLocationAndRead(PRKDF_LOCATION);
        PrKdf prkdf = new PrKdf();
        prkdf.setDerValue(prkdfValue);
        this.keyReferences = new LinkedHashMap<String, DniePrivateKeyReference>();
        for (int i = 0; i < prkdf.getKeyCount(); ++i) {
            alias = this.aliasByCertAndKeyId.get(HexUtils.hexify(prkdf.getKeyId(i), false));
            if (alias == null) continue;
            this.keyReferences.put(alias, new DniePrivateKeyReference(this, prkdf.getKeyIdentifier(i), new Location(prkdf.getKeyPath(i)), prkdf.getKeyName(i), prkdf.getKeyReference(i), ((RSAPublicKey)this.certs.get(alias).getPublicKey()).getModulus().bitLength()));
        }
        this.hideCertsWithoutKey();
    }

    private void hideCertsWithoutKey() {
        String[] aliases;
        for (String alias : aliases = this.getAliases()) {
            if (this.keyReferences.get(alias) != null) continue;
            this.certs.remove(alias);
        }
    }

    @Override
    public void openSecureChannelIfNotAlreadyOpened() throws CryptoCardException, PinException {
        if (!this.isSecurityChannelOpen()) {
            if (!(this.getConnection() instanceof Cwa14890Connection)) {
                Cwa14890OneV2Connection secureConnection = new Cwa14890OneV2Connection(this, this.getConnection(), this.cryptoHelper, this.getCwa14890PublicConstants(), this.getCwa14890PrivateConstants());
                try {
                    this.setConnection(secureConnection);
                }
                catch (ApduConnectionException e) {
                    throw new CryptoCardException("Error en el establecimiento del canal seguro: " + e, e);
                }
            }
            try {
                this.verifyPin(this.getInternalPasswordCallback());
            }
            catch (ApduConnectionException e) {
                throw new CryptoCardException("Error en la apertura del canal seguro: " + e, e);
            }
        }
    }

    @Override
    protected boolean needAuthorizationToSign() {
        return false;
    }

    @Override
    protected String getPinMessage(int retriesLeft) {
        return CardMessages.getString("Gen.0", Integer.toString(retriesLeft));
    }

    private static void checkAtr(byte[] atrBytes) throws InvalidCardException {
        Atr tmpAtr = new Atr(atrBytes, ATR_MASK_TC);
        if (ATR_TC.equals(tmpAtr) && atrBytes[15] >= 4 && atrBytes[16] >= 48) {
            LOGGER.info("Encontrada TC CERES en version " + HexUtils.hexify(new byte[]{atrBytes[15]}, false) + "." + HexUtils.hexify(new byte[]{atrBytes[16]}, false));
            return;
        }
        throw new InvalidCardException("CERES", ATR_TC, atrBytes);
    }
}

