/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.cardos;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.CommandApdu;
import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.apdu.connection.ApduConnectionProtocol;
import es.gob.jmulticard.apdu.connection.CardNotPresentException;
import es.gob.jmulticard.apdu.connection.NoReadersFoundException;
import es.gob.jmulticard.asn1.Asn1Exception;
import es.gob.jmulticard.asn1.TlvException;
import es.gob.jmulticard.asn1.der.pkcs15.CertificateObject;
import es.gob.jmulticard.asn1.der.pkcs15.Odf;
import es.gob.jmulticard.asn1.der.pkcs15.Path;
import es.gob.jmulticard.card.Atr;
import es.gob.jmulticard.card.CryptoCard;
import es.gob.jmulticard.card.InvalidCardException;
import es.gob.jmulticard.card.PrivateKeyReference;
import es.gob.jmulticard.card.iso7816four.FileNotFoundException;
import es.gob.jmulticard.card.iso7816four.Iso7816FourCard;
import es.gob.jmulticard.card.iso7816four.Iso7816FourCardException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.security.auth.callback.PasswordCallback;

public final class CardOS
extends Iso7816FourCard
implements CryptoCard {
    private static final byte[] ATR_MASK = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final Atr ATR = new Atr(new byte[]{59, -46, 24, 0, -127, 49, -2, 88, -55, 1, 20}, ATR_MASK);
    private static final byte[] PKCS15_NAME = new byte[]{-96, 0, 0, 0, 99, 80, 75, 67, 83, 45, 49, 53};
    private static byte CLA = 0;
    private static final Logger LOGGER = Logger.getLogger("es.gob.jmulticard");
    private static final Map<String, X509Certificate> certificatesByAlias = new LinkedHashMap<String, X509Certificate>();

    public CardOS(ApduConnection conn) throws Iso7816FourCardException, IOException {
        super(CLA, conn);
        this.connect(conn);
        try {
            this.preloadCertificates();
        }
        catch (Asn1Exception e) {
            throw new IOException("Error creando las estructuras ASN.1: " + e, e);
        }
        catch (TlvException e) {
            throw new IOException("Error tratando los TLV internos de las estructuras ASN.1: " + e, e);
        }
    }

    private void connect(ApduConnection conn) throws IOException {
        if (conn == null) {
            throw new IllegalArgumentException("La conexion no puede ser nula");
        }
        conn.setProtocol(ApduConnectionProtocol.T1);
        long[] terminals = conn.getTerminals(false);
        if (terminals.length < 1) {
            throw new NoReadersFoundException();
        }
        InvalidCardException invalidCardException = null;
        CardNotPresentException cardNotPresentException = null;
        ApduConnectionException apduConnectionException = null;
        for (long terminal : terminals) {
            byte[] responseAtr;
            conn.setTerminal((int)terminal);
            try {
                responseAtr = conn.reset();
            }
            catch (CardNotPresentException e) {
                cardNotPresentException = e;
                continue;
            }
            catch (ApduConnectionException e) {
                apduConnectionException = e;
                continue;
            }
            Atr actualAtr = new Atr(responseAtr, ATR_MASK);
            if (!ATR.equals(actualAtr)) {
                invalidCardException = new InvalidCardException(this.getCardName(), ATR, responseAtr);
                continue;
            }
            return;
        }
        if (invalidCardException != null) {
            throw invalidCardException;
        }
        if (cardNotPresentException != null) {
            throw cardNotPresentException;
        }
        if (apduConnectionException != null) {
            throw apduConnectionException;
        }
        throw new ApduConnectionException("No se ha podido conectar con ningun lector de tarjetas");
    }

    private void preloadCertificates() throws FileNotFoundException, Iso7816FourCardException, IOException, Asn1Exception, TlvException {
        CertificateFactory cf;
        this.selectFileByName(PKCS15_NAME);
        this.selectFileById(new byte[]{80, 49});
        byte[] odfBytes = this.readBinaryComplete(162);
        Odf odf = new Odf();
        odf.setDerValue(odfBytes);
        Path cdfPath = odf.getCdfPath();
        this.selectFileById(cdfPath.getPathBytes());
        List<byte[]> cdfRecords = this.readAllRecords();
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e1) {
            throw new IllegalStateException("No se ha podido obtener la factoria de certificados X.509: " + e1, e1);
        }
        for (byte[] b : cdfRecords) {
            X509Certificate cert;
            CertificateObject co;
            try {
                co = new CertificateObject();
                co.setDerValue(HexUtils.subArray(b, 2, b.length - 2));
            }
            catch (Exception e) {
                LOGGER.warning("Omitido registro de certificado por no ser un CertificateObject de PKCS#15: " + e);
                continue;
            }
            byte[] certPath = co.getPathBytes();
            if (certPath == null || certPath.length != 4) {
                LOGGER.warning("Se omite una posicion de certificado porque su ruta no es de cuatro octetos: " + co.getAlias());
                continue;
            }
            byte[] MASTER_FILE = new byte[]{80, 21};
            this.sendArbitraryApdu(new CommandApdu(this.getCla(), -92, 8, 12, new byte[]{MASTER_FILE[0], MASTER_FILE[1], certPath[0], certPath[1], certPath[2], certPath[3]}, null));
            byte[] certBytes = this.readBinaryComplete(9999);
            try {
                cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certBytes));
            }
            catch (CertificateException e) {
                LOGGER.severe("No ha sido posible generar el certificado para el alias " + co.getAlias() + ": " + e);
                continue;
            }
            certificatesByAlias.put(co.getAlias(), cert);
        }
    }

    @Override
    public String getCardName() {
        return "Atos / Siemens CardOS";
    }

    @Override
    public String[] getAliases() {
        return certificatesByAlias.keySet().toArray(new String[0]);
    }

    @Override
    public X509Certificate getCertificate(String alias) {
        return certificatesByAlias.get(alias);
    }

    @Override
    protected void selectMasterFile() throws ApduConnectionException, FileNotFoundException, Iso7816FourCardException {
        this.selectFileById(new byte[0]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getCardName()).append("\n Tarjeta con ").append(certificatesByAlias.size()).append(" certificado(s):\n");
        String[] aliases = this.getAliases();
        for (int i = 0; i < aliases.length; ++i) {
            sb.append("  ");
            sb.append(i + 1);
            sb.append(" - ");
            sb.append(aliases[i]);
        }
        return sb.toString();
    }

    @Override
    public PrivateKeyReference getPrivateKey(String alias) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] sign(byte[] data, String algorithm, PrivateKeyReference keyRef) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void verifyPin(PasswordCallback pinPc) {
        throw new UnsupportedOperationException();
    }
}

