/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.bit4id.stcm;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.ResponseApdu;
import es.gob.jmulticard.apdu.bit4id.stcm.VerifyApduCommand;
import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.card.BadPinException;
import es.gob.jmulticard.card.CryptoCard;
import es.gob.jmulticard.card.Location;
import es.gob.jmulticard.card.PinException;
import es.gob.jmulticard.card.PrivateKeyReference;
import es.gob.jmulticard.card.iso7816four.Iso7816FourCard;
import es.gob.jmulticard.card.iso7816four.Iso7816FourCardException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.PasswordCallback;

public final class StCard
extends Iso7816FourCard
implements CryptoCard {
    private static byte CLA = 0;
    private static final byte ERROR_PIN_SW1 = 99;

    public StCard(ApduConnection conn) throws Iso7816FourCardException, IOException {
        super(CLA, conn);
        StCard.connect(conn);
        byte[] b1 = this.selectFileByLocationAndRead(new Location("2FFF0000"));
        try (FileOutputStream fos = new FileOutputStream(File.createTempFile("0000_", ".DER"));){
            fos.write(b1);
            fos.flush();
        }
        System.out.println(HexUtils.hexify(b1, true));
        System.out.println("LEN: " + b1.length);
    }

    private static void connect(ApduConnection conn) throws IOException {
        if (conn == null) {
            throw new IllegalArgumentException("La conexion no puede ser nula");
        }
        conn.open();
    }

    @Override
    public String[] getAliases() {
        throw new UnsupportedOperationException();
    }

    @Override
    public X509Certificate getCertificate(String alias) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrivateKeyReference getPrivateKey(String alias) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] sign(byte[] data, String algorithm, PrivateKeyReference keyRef) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void selectMasterFile() {
    }

    @Override
    public void verifyPin(PasswordCallback pinPc) throws ApduConnectionException, PinException {
        if (pinPc == null) {
            throw new BadPinException("No se ha establecido un PasswordCallback");
        }
        VerifyApduCommand chv = new VerifyApduCommand(CLA, pinPc);
        ResponseApdu verifyResponse = this.sendArbitraryApdu(chv);
        if (!verifyResponse.isOk()) {
            if (verifyResponse.getStatusWord().getMsb() == 99) {
                throw new BadPinException(verifyResponse.getStatusWord().getLsb() - -64);
            }
            throw new ApduConnectionException("Error en el envio de la verificacion de PIN con respuesta: " + verifyResponse.getStatusWord());
        }
    }

    @Override
    public String getCardName() {
        return "Bit4ID con chip ST para CamerFirma";
    }
}

