/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.bac;

import es.gob.jmulticard.CryptoHelper;
import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.CommandApdu;
import es.gob.jmulticard.apdu.ResponseApdu;
import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.apdu.iso7816four.ExternalAuthenticateApduCommand;
import es.gob.jmulticard.apdu.iso7816four.GetChallengeApduCommand;
import es.gob.jmulticard.card.iso7816four.Iso7816FourCardException;
import es.gob.jmulticard.card.pace.MrzInfo;
import es.gob.jmulticard.de.tsenger.androsmex.crypto.Crypto;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public final class Bac {
    private static final byte CLA = 0;
    private static final byte[] KENC_PADDING = new byte[]{0, 0, 0, 1};
    private static final byte[] KMAC_PADDING = new byte[]{0, 0, 0, 2};
    private static final byte[] PARITY = new byte[]{8, 1, 0, 8, 0, 8, 8, 0, 0, 8, 8, 0, 8, 0, 2, 8, 0, 8, 8, 0, 8, 0, 0, 8, 8, 0, 0, 8, 0, 8, 8, 3, 0, 8, 8, 0, 8, 0, 0, 8, 8, 0, 0, 8, 0, 8, 8, 0, 8, 0, 0, 8, 0, 8, 8, 0, 0, 8, 8, 0, 8, 0, 0, 8, 0, 8, 8, 0, 8, 0, 0, 8, 8, 0, 0, 8, 0, 8, 8, 0, 8, 0, 0, 8, 0, 8, 8, 0, 0, 8, 8, 0, 8, 0, 0, 8, 8, 0, 0, 8, 0, 8, 8, 0, 0, 8, 8, 0, 8, 0, 0, 8, 0, 8, 8, 0, 8, 0, 0, 8, 8, 0, 0, 8, 0, 8, 8, 0, 0, 8, 8, 0, 8, 0, 0, 8, 8, 0, 0, 8, 0, 8, 8, 0, 8, 0, 0, 8, 0, 8, 8, 0, 0, 8, 8, 0, 8, 0, 0, 8, 8, 0, 0, 8, 0, 8, 8, 0, 0, 8, 8, 0, 8, 0, 0, 8, 0, 8, 8, 0, 8, 0, 0, 8, 8, 0, 0, 8, 0, 8, 8, 0, 8, 0, 0, 8, 0, 8, 8, 0, 0, 8, 8, 0, 8, 0, 0, 8, 0, 8, 8, 0, 8, 0, 0, 8, 8, 0, 0, 8, 0, 8, 8, 0, 4, 8, 8, 0, 8, 0, 0, 8, 8, 0, 0, 8, 0, 8, 8, 0, 8, 5, 0, 8, 0, 8, 8, 0, 0, 8, 8, 0, 8, 0, 6, 8};

    public static void doBac(String mrz, CryptoHelper ch, ApduConnection conn) throws IOException, Iso7816FourCardException {
        byte[] mIfd;
        CommandApdu command;
        ResponseApdu response;
        MrzInfo mi = new MrzInfo(mrz);
        byte[] kSeed = Bac.truncateMrzPwd(mi.getMrzPswd());
        System.out.println("keySeed: " + HexUtils.hexify(kSeed, false));
        byte[] dEnc = HexUtils.concatenateByteArrays(kSeed, KENC_PADDING);
        byte[] hSha1DEnc = ch.digest(CryptoHelper.DigestAlgorithm.SHA1, dEnc);
        byte[] kEncA = new byte[8];
        System.arraycopy(hSha1DEnc, 0, kEncA, 0, 8);
        byte[] kEncB = new byte[8];
        System.arraycopy(hSha1DEnc, 8, kEncB, 0, 8);
        byte[] dMac = HexUtils.concatenateByteArrays(kSeed, KMAC_PADDING);
        byte[] hSha1DMac = ch.digest(CryptoHelper.DigestAlgorithm.SHA1, dMac);
        byte[] kMacA = new byte[8];
        System.arraycopy(hSha1DMac, 0, kMacA, 0, 8);
        byte[] kMacB = new byte[8];
        System.arraycopy(hSha1DMac, 8, kMacB, 0, 8);
        byte[] kEnc = HexUtils.concatenateByteArrays(kEncA, kEncB);
        byte[] kMac = HexUtils.concatenateByteArrays(kMacA, kMacB);
        System.out.println();
        System.out.println("kEnc = " + HexUtils.hexify(kEnc, false));
        System.out.println("kMac = " + HexUtils.hexify(kMac, false));
        if (!conn.isOpen()) {
            conn.open();
        }
        if (!(response = conn.transmit(command = new GetChallengeApduCommand(0))).isOk()) {
            throw new Iso7816FourCardException(response.getStatusWord(), command, "Error obteniendo un desafio aleatorio (8 octetos) del MRTD");
        }
        byte[] rndIc = response.getData();
        System.out.println();
        System.out.println("RND.IC: " + HexUtils.hexify(rndIc, false));
        byte[] rndIfd = ch.generateRandomBytes(8);
        byte[] kIfd = ch.generateRandomBytes(16);
        System.out.println();
        System.out.println("RND.IFD: " + HexUtils.hexify(rndIfd, false));
        System.out.println("kIFD: " + HexUtils.hexify(kIfd, false));
        byte[] s = HexUtils.concatenateByteArrays(rndIfd, rndIc, kIfd);
        System.out.println();
        System.out.println("S: " + HexUtils.hexify(s, true));
        byte[] eIfd = ch.desedeEncrypt(s, kEnc);
        System.out.println();
        System.out.println("eIFD: " + HexUtils.hexify(eIfd, true));
        try {
            mIfd = Crypto.computeMAC(kMac, eIfd);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IOException(e);
        }
        byte[] extAuthCmdData = HexUtils.concatenateByteArrays(eIfd, mIfd);
        System.out.println("cmd_data: " + HexUtils.hexify(extAuthCmdData, false));
        command = new ExternalAuthenticateApduCommand(0, extAuthCmdData);
        response = conn.transmit(command);
        if (!response.isOk()) {
            throw new Iso7816FourCardException(response.getStatusWord(), command, "Error en el inicio de la autenticacion externa");
        }
        System.out.println("APDU de autenticacion externa: " + command);
        System.out.println();
        System.out.println("resp_data: " + HexUtils.hexify(response.getData(), false));
    }

    private static byte[] truncateMrzPwd(byte[] mrzInfoPwd) {
        if (mrzInfoPwd == null || mrzInfoPwd.length < 16) {
            throw new IllegalArgumentException("La huella del 'MRZ Information' no puede ser nula ni tener menos de 16 octetos");
        }
        byte[] keySeed = new byte[16];
        System.arraycopy(mrzInfoPwd, 0, keySeed, 0, 16);
        return keySeed;
    }

    private static void adjustParity(byte[] key) {
        for (int i = 0; i < 8; ++i) {
            int n = i;
            key[n] = (byte)(key[n] ^ (PARITY[key[i] & 0xFF] == 8 ? (byte)1 : 0));
        }
    }
}

