/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card;

import es.gob.jmulticard.HexUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public final class Location {
    private static final int MASTER_FILE_ID = 16128;
    private Vector<Integer> path = new Vector();
    private static final Map<String, Integer> HEXBYTES;

    public Location(String absolutePath) {
        this.init(absolutePath);
    }

    private Location(Vector<Integer> path) {
        if (path != null) {
            int numElements = path.size();
            this.path = new Vector(numElements);
            for (int i = 0; i < numElements; ++i) {
                this.path.insertElementAt(path.elementAt(i), i);
            }
        }
    }

    public Location getChild() {
        Location aux = new Location(this.path);
        if (aux.path != null && aux.path.size() > 1) {
            aux.path.removeElementAt(0);
            return aux;
        }
        return null;
    }

    public byte[] getFile() {
        int address = this.path.elementAt(0);
        return new byte[]{(byte)(address >> 8 & 0xFF), (byte)(address & 0xFF)};
    }

    public byte[] getLastFilePath() {
        if (this.path.size() < 1) {
            return null;
        }
        int address = this.path.elementAt(this.path.size() - 1);
        return new byte[]{(byte)(address >> 8 & 0xFF), (byte)(address & 0xFF)};
    }

    private static void checkValidPath(String absolutePath) throws IllegalArgumentException {
        if (absolutePath == null) {
            throw new IllegalArgumentException("Ruta nula");
        }
        if (absolutePath.length() == 0) {
            throw new IllegalArgumentException("Ruta vacia");
        }
        if (absolutePath.trim().length() % 4 != 0) {
            throw new IllegalArgumentException("Un location valido debe estar compuesto por grupos pares de octetos: " + absolutePath);
        }
        String aux = absolutePath.toLowerCase();
        for (int i = 0; i < absolutePath.length(); ++i) {
            char currentChar = aux.charAt(i);
            if (currentChar >= '0' && currentChar <= '9' || currentChar >= 'a' && currentChar <= 'f') continue;
            throw new IllegalArgumentException("Encontrado el caracter invalido '" + currentChar + "'en la ruta '" + absolutePath + "'");
        }
    }

    private void init(String absolutePath) {
        Location.checkValidPath(absolutePath);
        for (int i = 0; i < absolutePath.length(); i += 4) {
            int ll;
            int mm = HEXBYTES.get(absolutePath.substring(i, i + 1));
            int ml = HEXBYTES.get(absolutePath.substring(i + 1, i + 2));
            int lm = HEXBYTES.get(absolutePath.substring(i + 2, i + 3));
            int id = ll = HEXBYTES.get(absolutePath.substring(i + 3, i + 4)).intValue();
            id += lm << 4;
            id += ml << 8;
            if ((id += mm << 4 << 8) == 16128) continue;
            this.path.addElement(Integer.valueOf(String.valueOf(id)));
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.path != null && !this.path.isEmpty()) {
            buffer.append("3F00");
            for (int i = 0; i < this.path.size(); ++i) {
                Integer integer = this.path.elementAt(i);
                buffer.append('/').append(HexUtils.hexify(new byte[]{(byte)(integer.shortValue() >> 8), integer.byteValue()}, false));
            }
        }
        return buffer.toString();
    }

    static {
        int i;
        HEXBYTES = new HashMap<String, Integer>();
        String[] hex = new String[]{"a", "b", "c", "d", "e", "f"};
        for (i = 0; i <= 9; ++i) {
            HEXBYTES.put(String.valueOf(i), Integer.valueOf(String.valueOf(i)));
        }
        for (i = 10; i < 16; ++i) {
            HEXBYTES.put(hex[i - 10], Integer.valueOf(String.valueOf(i)));
            HEXBYTES.put(hex[i - 10].toUpperCase(), Integer.valueOf(String.valueOf(i)));
        }
    }
}

