/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public final class CompressionUtils {
    protected static final Logger LOGGER = Logger.getLogger("es.gob.jmulticard");
    protected static final CertificateFactory CERT_FACTORY;

    private CompressionUtils() {
    }

    public static X509Certificate getCertificateFromCompressedOrNotData(byte[] data) throws IOException, CertificateException {
        byte[] rawData;
        if (data == null || data.length < 1) {
            throw new IOException("Los datos del certificado eran nulos o vacios");
        }
        try {
            rawData = CompressionUtils.deflate(data);
        }
        catch (Exception e) {
            LOGGER.warning("Ha fallado la descompresion del certificado, se probara sin descomprimir: " + e);
            rawData = data;
        }
        return (X509Certificate)CERT_FACTORY.generateCertificate(new ByteArrayInputStream(rawData));
    }

    private static byte[] deflate(byte[] compressedCertificate) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        Inflater decompressor = new Inflater();
        decompressor.setInput(compressedCertificate, 8, compressedCertificate.length - 8);
        byte[] buf = new byte[1024];
        try {
            while (!decompressor.finished()) {
                int count = decompressor.inflate(buf);
                if (count == 0) {
                    throw new DataFormatException();
                }
                buffer.write(buf, 0, count);
            }
            return buffer.toByteArray();
        }
        catch (DataFormatException ex) {
            throw new IOException("Error al descomprimir el certificado: " + ex, ex);
        }
    }

    static {
        try {
            CERT_FACTORY = CertificateFactory.getInstance("X.509");
        }
        catch (Exception e) {
            throw new IllegalStateException("No se ha podido obtener la factoria de certificados X.509: " + e, e);
        }
    }
}

