/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card;

import es.gob.jmulticard.HexUtils;
import java.io.Serializable;

public final class Atr
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final byte[] atrBytes;
    private final byte[] mask;

    public Atr(byte[] a, byte[] m) {
        if (a == null || m == null) {
            throw new IllegalArgumentException("El ATR y su mascara no pueden ser nulos");
        }
        this.atrBytes = new byte[a.length];
        System.arraycopy(a, 0, this.atrBytes, 0, a.length);
        this.mask = new byte[m.length];
        System.arraycopy(m, 0, this.mask, 0, m.length);
    }

    public String toString() {
        return HexUtils.hexify(this.getBytes(), true);
    }

    public byte[] getBytes() {
        byte[] tmp = new byte[this.atrBytes.length];
        System.arraycopy(this.atrBytes, 0, tmp, 0, this.atrBytes.length);
        return tmp;
    }

    public boolean equals(Object o) {
        byte[] tmpAtrBytes;
        if (o instanceof Atr) {
            tmpAtrBytes = ((Atr)o).getBytes();
        } else if (o instanceof byte[]) {
            tmpAtrBytes = (byte[])o;
        } else {
            return false;
        }
        if (this.atrBytes.length < tmpAtrBytes.length) {
            return false;
        }
        int off = this.atrBytes.length - tmpAtrBytes.length;
        for (int i = tmpAtrBytes.length - 1; i >= 0; --i) {
            if ((this.atrBytes[i + off] & this.mask[i + off]) == (tmpAtrBytes[i] & this.mask[i + off])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Atr.hashCode(this.atrBytes) + Atr.hashCode(this.mask);
    }

    private static int hashCode(byte[] a) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (byte element : a) {
            result = 31 * result + element;
        }
        return result;
    }
}

