/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1.der.pkcs15;

import es.gob.jmulticard.asn1.DecoderObject;
import es.gob.jmulticard.asn1.OptionalDecoderObjectElement;
import es.gob.jmulticard.asn1.der.DerInteger;
import es.gob.jmulticard.asn1.der.Sequence;
import es.gob.jmulticard.asn1.der.pkcs15.CertificateIssuerContextSpecific;
import es.gob.jmulticard.asn1.der.pkcs15.Path;
import es.gob.jmulticard.asn1.der.x509.RdnSequence;
import java.math.BigInteger;

public final class X509CertificateAttributes
extends Sequence {
    public X509CertificateAttributes() {
        super(new OptionalDecoderObjectElement[]{new OptionalDecoderObjectElement(Path.class, false), new OptionalDecoderObjectElement(RdnSequence.class, true), new OptionalDecoderObjectElement(CertificateIssuerContextSpecific.class, true), new OptionalDecoderObjectElement(DerInteger.class, true)});
    }

    String getIssuer() {
        DecoderObject d = this.getObject(CertificateIssuerContextSpecific.class);
        if (d == null) {
            return null;
        }
        return d.toString();
    }

    String getSubject() {
        DecoderObject d = this.getObject(RdnSequence.class);
        if (d == null) {
            return null;
        }
        return d.toString();
    }

    String getPath() {
        DecoderObject d = this.getObject(Path.class);
        if (d == null) {
            return null;
        }
        return ((Path)d).getPathString();
    }

    byte[] getPathBytes() {
        DecoderObject d = this.getObject(Path.class);
        if (d == null) {
            return null;
        }
        return ((Path)d).getPathBytes();
    }

    BigInteger getSerialNumber() {
        DecoderObject d = this.getObject(DerInteger.class);
        if (d == null) {
            return null;
        }
        return ((DerInteger)d).getIntegerValue();
    }

    private DecoderObject getObject(Class<?> objectType) {
        if (objectType == null) {
            return null;
        }
        for (int i = 0; i < this.getElementCount(); ++i) {
            if (!this.getElementAt(i).getClass().equals(objectType)) continue;
            return this.getElementAt(i);
        }
        return null;
    }

    public String toString() {
        return "Atributos del certificado\n Ruta: " + this.getPath() + (this.getSubject() != null ? "\n Titular: " + this.getSubject() : "") + (this.getIssuer() != null ? "\n Emisor: " + this.getIssuer() : "") + (this.getSerialNumber() != null ? "\n Numero de serie: " + this.getSerialNumber().toString() : "");
    }
}

