/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1.der.pkcs15;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.asn1.Asn1Exception;
import es.gob.jmulticard.asn1.der.ContextSpecific;
import es.gob.jmulticard.asn1.der.pkcs15.Path;

public final class PublicKeysContextSpecific
extends ContextSpecific {
    private static final byte TAG = -95;

    public PublicKeysContextSpecific() {
        super(Path.class);
    }

    @Override
    public void checkTag(byte tag) throws Asn1Exception {
        if (-95 != tag) {
            throw new Asn1Exception("PublicKeysContextSpecific esperaba una etiqueta especifica de contexto " + HexUtils.hexify(new byte[]{-95}, false) + " pero ha encontrado " + HexUtils.hexify(new byte[]{tag}, false));
        }
    }

    public Path getPublicKeysPath() {
        if (this.getObject() instanceof Path) {
            return (Path)this.getObject();
        }
        throw new IllegalStateException("El objeto interno no es de tipo Path PKCS#15");
    }
}

