/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1.der.pkcs15;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.asn1.Asn1Exception;
import es.gob.jmulticard.asn1.der.ContextSpecific;
import es.gob.jmulticard.asn1.der.pkcs15.Path;

public final class PrivateKeysContextSpecific
extends ContextSpecific {
    private static final byte TAG = -96;

    public PrivateKeysContextSpecific() {
        super(Path.class);
    }

    @Override
    public void checkTag(byte tag) throws Asn1Exception {
        if (-96 != tag) {
            throw new Asn1Exception("PrivateKeysContextSpecific esperaba una etiqueta especifica de contexto " + HexUtils.hexify(new byte[]{-96}, false) + " pero ha encontrado " + HexUtils.hexify(new byte[]{tag}, false));
        }
    }

    public Path getPrivateKeysPath() {
        if (this.getObject() instanceof Path) {
            return (Path)this.getObject();
        }
        throw new IllegalStateException("El objeto interno no es de tipo Path PKCS#15");
    }
}

