/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1.der.pkcs15;

import es.gob.jmulticard.asn1.DecoderObject;
import es.gob.jmulticard.asn1.der.ContextSpecific;
import es.gob.jmulticard.asn1.der.pkcs15.CommonKeyAttributes;
import es.gob.jmulticard.asn1.der.pkcs15.CommonPrivateKeyAttributesContextSpecific;
import es.gob.jmulticard.asn1.der.pkcs15.Pkcs15Object;
import es.gob.jmulticard.asn1.der.pkcs15.PrivateRsaKeyAttributesContextSpecific;
import javax.security.auth.x500.X500Principal;

public class PrivateKeyObject
extends Pkcs15Object {
    protected PrivateKeyObject(Class<? extends DecoderObject> classAttributes, Class<? extends ContextSpecific> subclassAttributes, Class<? extends ContextSpecific> typeAttributes) {
        super(classAttributes, subclassAttributes, typeAttributes);
    }

    public PrivateKeyObject() {
        super(CommonKeyAttributes.class, CommonPrivateKeyAttributesContextSpecific.class, PrivateRsaKeyAttributesContextSpecific.class);
    }

    public byte[] getKeyIdentifier() {
        return ((CommonKeyAttributes)this.getClassAttributes()).getIdentifier();
    }

    String getKeyName() {
        return this.getCommonObjectAttributes().getLabel();
    }

    public String getKeyPath() {
        return ((PrivateRsaKeyAttributesContextSpecific)this.getTypeAttributes()).getPath();
    }

    int getKeyLength() {
        return ((PrivateRsaKeyAttributesContextSpecific)this.getTypeAttributes()).getKeyLength();
    }

    X500Principal getKeyPrincipal() {
        DecoderObject o = this.getSubclassAttributes();
        if (o instanceof CommonPrivateKeyAttributesContextSpecific) {
            return ((CommonPrivateKeyAttributesContextSpecific)o).getKeyRdn();
        }
        return null;
    }

    public String toString() {
        return "Nombre de la clave privada: " + this.getCommonObjectAttributes().getLabel() + (this.getSubclassAttributes() != null ? "\n" + ((CommonPrivateKeyAttributesContextSpecific)this.getSubclassAttributes()).getKeyRdn() : "");
    }

    public byte getKeyReference() {
        return ((CommonKeyAttributes)this.getClassAttributes()).getReference().getIntegerValue().byteValue();
    }
}

