/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1.der.pkcs15;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.asn1.Asn1Exception;
import es.gob.jmulticard.asn1.der.ContextSpecific;
import es.gob.jmulticard.asn1.der.pkcs15.CommonPrivateKeyAttributes;
import javax.security.auth.x500.X500Principal;

public final class CommonPrivateKeyAttributesContextSpecific
extends ContextSpecific {
    private static final byte TAG = -96;

    public CommonPrivateKeyAttributesContextSpecific() {
        super(CommonPrivateKeyAttributes.class);
    }

    @Override
    public void checkTag(byte tag) throws Asn1Exception {
        if (-96 != tag) {
            throw new Asn1Exception("CommonPrivateKeyAttributesContextSpecific esperaba una etiqueta especifica de contexto " + HexUtils.hexify(new byte[]{-96}, false) + " pero ha encontrado " + HexUtils.hexify(new byte[]{tag}, false));
        }
    }

    public String toString() {
        return this.getObject().toString();
    }

    X500Principal getKeyRdn() {
        return ((CommonPrivateKeyAttributes)this.getObject()).getKeyPrincipal();
    }
}

