/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1.der.pkcs15;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.asn1.OptionalDecoderObjectElement;
import es.gob.jmulticard.asn1.der.Record;
import es.gob.jmulticard.asn1.der.pkcs15.CertificateObject;
import es.gob.jmulticard.asn1.der.pkcs15.Pkcs15Cdf;
import java.math.BigInteger;

public final class Cdf
extends Record
implements Pkcs15Cdf {
    private static final int BUFFER_SIZE = 150;

    public Cdf() {
        super(new OptionalDecoderObjectElement[]{new OptionalDecoderObjectElement(CertificateObject.class, false), new OptionalDecoderObjectElement(CertificateObject.class, true), new OptionalDecoderObjectElement(CertificateObject.class, true), new OptionalDecoderObjectElement(CertificateObject.class, true), new OptionalDecoderObjectElement(CertificateObject.class, true), new OptionalDecoderObjectElement(CertificateObject.class, true), new OptionalDecoderObjectElement(CertificateObject.class, true), new OptionalDecoderObjectElement(CertificateObject.class, true), new OptionalDecoderObjectElement(CertificateObject.class, true), new OptionalDecoderObjectElement(CertificateObject.class, true)});
    }

    @Override
    public int getCertificateCount() {
        return this.getElementCount();
    }

    public String getCertificateIssuerPrincipal(int index) {
        CertificateObject tmpCo = (CertificateObject)this.getElementAt(index);
        if (tmpCo != null) {
            return tmpCo.getIssuer();
        }
        return null;
    }

    public String getCertificateSubjectPrincipal(int index) {
        CertificateObject tmpCo = (CertificateObject)this.getElementAt(index);
        if (tmpCo != null) {
            return tmpCo.getSubject();
        }
        return null;
    }

    public BigInteger getCertificateSerialNumber(int index) {
        CertificateObject tmpCo = (CertificateObject)this.getElementAt(index);
        if (tmpCo != null) {
            return tmpCo.getSerialNumber();
        }
        return null;
    }

    public byte[] getCertificateIdentifier(int index) {
        CertificateObject tmpCo = (CertificateObject)this.getElementAt(index);
        if (tmpCo != null) {
            return tmpCo.getIdentifier();
        }
        return null;
    }

    @Override
    public String getCertificatePath(int index) {
        CertificateObject tmpCo = (CertificateObject)this.getElementAt(index);
        if (tmpCo != null) {
            return tmpCo.getPath();
        }
        return null;
    }

    public String getCertificateAlias(int index) {
        CertificateObject tmpCo = (CertificateObject)this.getElementAt(index);
        if (tmpCo != null) {
            return tmpCo.getAlias();
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(150);
        sb.append("Fichero de Descripcion de Certificados:\n");
        for (int index = 0; index < this.getCertificateCount(); ++index) {
            sb.append(" Certificado ");
            sb.append(Integer.toString(index));
            sb.append("\n  Alias: ");
            sb.append(this.getCertificateAlias(index));
            sb.append("\n  Titular: ");
            sb.append(this.getCertificateSubjectPrincipal(index));
            sb.append("\n  Emisor: ");
            sb.append(this.getCertificateIssuerPrincipal(index));
            sb.append("\n  Numero de serie: ");
            sb.append(this.getCertificateSerialNumber(index));
            sb.append("\n  Identificador: ");
            sb.append(HexUtils.hexify(this.getCertificateIdentifier(index), false));
            sb.append("\n  Ruta PKCS#15: ");
            sb.append(this.getCertificatePath(index));
            if (index == this.getCertificateCount() - 1) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public byte[] getCertificateId(int index) {
        CertificateObject tmpCo = (CertificateObject)this.getElementAt(index);
        if (tmpCo != null) {
            return tmpCo.getIdentifier();
        }
        return null;
    }
}

