/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1.der;

import es.gob.jmulticard.asn1.Asn1Exception;
import es.gob.jmulticard.asn1.DecoderObject;
import es.gob.jmulticard.asn1.OptionalDecoderObjectElement;
import es.gob.jmulticard.asn1.Tlv;
import es.gob.jmulticard.asn1.TlvException;
import java.util.ArrayList;
import java.util.List;

public abstract class Record
extends DecoderObject {
    private final OptionalDecoderObjectElement[] elementsTypes;
    private final List<DecoderObject> elements = new ArrayList<DecoderObject>();

    protected Record(OptionalDecoderObjectElement[] types) {
        if (types == null || types.length == 0) {
            throw new IllegalArgumentException("Los tipos de los elementos del registro no pueden ser nulos ni vacios");
        }
        this.elementsTypes = new OptionalDecoderObjectElement[types.length];
        System.arraycopy(types, 0, this.elementsTypes, 0, types.length);
    }

    protected int getElementCount() {
        return this.elements.size();
    }

    protected DecoderObject getElementAt(int pos) {
        if (pos < 0 || pos >= this.elements.size()) {
            throw new IndexOutOfBoundsException("No existe un elemento en este registro en el indice " + Integer.toString(pos));
        }
        return this.elements.get(pos);
    }

    @Override
    protected void decodeValue() throws Asn1Exception, TlvException {
        if (this.getRawDerValue().length == 0) {
            throw new Asn1Exception("El valor del objeto ASN.1 esta vacio");
        }
        int offset = 0;
        for (int i = 0; i < this.elementsTypes.length; ++i) {
            DecoderObject tmpDo;
            Tlv tlv;
            try {
                byte[] remainingBytes = new byte[this.getRawDerValue().length - offset];
                System.arraycopy(this.getRawDerValue(), offset, remainingBytes, 0, remainingBytes.length);
                tlv = new Tlv(remainingBytes);
                try {
                    tmpDo = this.elementsTypes[i].getElementType().getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new Asn1Exception("No se ha podido instanciar un " + this.elementsTypes[i].getElementType().getName() + " en la posicion " + Integer.toString(i) + " del registro: " + e, e);
                }
                tmpDo.checkTag(tlv.getTag());
            }
            catch (Exception e) {
                if (this.elementsTypes[i].isOptional()) continue;
                throw new Asn1Exception("Error en el elemento " + i + " del registro ASN.1: " + e, e);
            }
            offset += tlv.getBytes().length;
            tmpDo.setDerValue(tlv.getBytes());
            this.elements.add(tmpDo);
        }
    }

    @Override
    protected byte getDefaultTag() {
        throw new UnsupportedOperationException("No hay tipo por defecto");
    }
}

