/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1.der;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.asn1.Asn1Exception;
import es.gob.jmulticard.asn1.DecoderObject;
import es.gob.jmulticard.asn1.Tlv;
import es.gob.jmulticard.asn1.TlvException;

public abstract class ContextSpecific
extends DecoderObject {
    private DecoderObject object = null;
    private final Class<? extends DecoderObject> elementType;

    protected DecoderObject getObject() {
        if (this.object == null) {
            throw new IllegalStateException();
        }
        return this.object;
    }

    @Override
    protected void decodeValue() throws Asn1Exception, TlvException {
        DecoderObject tmpDo;
        Tlv tlv = new Tlv(this.getRawDerValue());
        try {
            tmpDo = this.elementType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new Asn1Exception("No se ha podido instanciar un " + this.elementType.getName() + " en el contexto especifico: " + e, e);
        }
        tmpDo.setDerValue(tlv.getValue());
        this.object = tmpDo;
    }

    public ContextSpecific(Class<? extends DecoderObject> type) {
        if (type == null) {
            throw new IllegalArgumentException("El tipo contenido dentro de ContextSpecific no puede ser nulo");
        }
        this.elementType = type;
    }

    @Override
    protected byte getDefaultTag() {
        throw new UnsupportedOperationException("No hay tipo por defecto");
    }

    @Override
    public void checkTag(byte tag) throws Asn1Exception {
        if ((tag & 0xC0) != 128) {
            throw new Asn1Exception("La etiqueta " + HexUtils.hexify(new byte[]{tag}, false) + " no es valida para un objeto especifico del contexto");
        }
    }
}

