/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1.der;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.asn1.Asn1Exception;
import es.gob.jmulticard.asn1.DecoderObject;
import es.gob.jmulticard.asn1.Tlv;
import es.gob.jmulticard.asn1.TlvException;

public abstract class BitString
extends DecoderObject {
    private static final byte TAG_BITSTRING = 3;
    private Tlv tlv = null;

    @Override
    protected void decodeValue() throws Asn1Exception, TlvException {
        this.tlv = new Tlv(this.getRawDerValue());
        if (3 != this.tlv.getTag()) {
            throw new Asn1Exception("Se esperaba un TLV de tipo BitString pero se ha encontrado uno de tipo " + HexUtils.hexify(new byte[]{this.tlv.getTag()}, false));
        }
    }

    @Override
    protected byte getDefaultTag() {
        return 3;
    }

    public byte[] getValue() {
        return this.tlv != null ? this.tlv.getValue() : null;
    }
}

