/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1.bertlv;

import es.gob.jmulticard.asn1.bertlv.BerTlvIdentifier;
import java.io.ByteArrayInputStream;

public final class BerTlv {
    private BerTlvIdentifier tag;
    private int length;
    private byte[] value;

    public BerTlvIdentifier getTag() {
        return this.tag;
    }

    public byte[] getValue() {
        if (this.value == null) {
            return null;
        }
        byte[] out = new byte[this.value.length];
        System.arraycopy(this.value, 0, out, 0, this.value.length);
        return out;
    }

    public static BerTlv getInstance(ByteArrayInputStream stream) {
        BerTlv tlv = new BerTlv();
        tlv.decode(stream);
        return tlv;
    }

    private void decode(ByteArrayInputStream stream) throws IndexOutOfBoundsException {
        this.tag = new BerTlvIdentifier();
        this.tag.decode(stream);
        int tmpLength = stream.read();
        if (tmpLength <= 127) {
            this.length = tmpLength;
        } else if (tmpLength == 128) {
            this.length = tmpLength;
        } else {
            int numberOfLengthOctets = tmpLength & 0x7F;
            tmpLength = 0;
            for (int i = 0; i < numberOfLengthOctets; ++i) {
                int nextLengthOctet = stream.read();
                tmpLength <<= 8;
                tmpLength |= nextLengthOctet;
            }
            this.length = tmpLength;
        }
        if (this.length == 128) {
            stream.mark(0);
            int prevOctet = 1;
            int curOctet = 0;
            int len = 0;
            while (true) {
                ++len;
                curOctet = stream.read();
                if (prevOctet == 0 && curOctet == 0) break;
                prevOctet = curOctet;
            }
            this.value = new byte[len -= 2];
            stream.reset();
            if (len != stream.read(this.value, 0, len)) {
                throw new IndexOutOfBoundsException("La longitud de los datos leidos no coincide con el parametro indicado");
            }
            this.length = len;
        } else {
            this.value = new byte[this.length];
            if (this.length != stream.read(this.value, 0, this.length)) {
                throw new IndexOutOfBoundsException("La longitud de los datos leidos no coincide con el parametro indicado");
            }
        }
    }

    public String toString() {
        return "[TLV: T=" + this.tag + ";L=" + this.length + ";V=" + (this.value == null ? "null" : this.value.length + " bytes") + "]";
    }
}

