/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.asn1.Asn1Exception;
import es.gob.jmulticard.asn1.TlvException;

public abstract class DecoderObject {
    private byte[] rawDerValue = null;

    protected byte[] getRawDerValue() {
        byte[] out = new byte[this.rawDerValue.length];
        System.arraycopy(this.rawDerValue, 0, out, 0, this.rawDerValue.length);
        return out;
    }

    public void setDerValue(byte[] value) throws Asn1Exception, TlvException {
        if (value == null) {
            throw new IllegalArgumentException("El valor del objeto ASN.1 no puede ser nulo");
        }
        this.rawDerValue = new byte[value.length];
        System.arraycopy(value, 0, this.rawDerValue, 0, value.length);
        this.decodeValue();
    }

    public byte[] getBytes() {
        byte[] out = new byte[this.rawDerValue.length];
        System.arraycopy(this.rawDerValue, 0, out, 0, this.rawDerValue.length);
        return out;
    }

    protected abstract void decodeValue() throws Asn1Exception, TlvException;

    protected abstract byte getDefaultTag();

    public void checkTag(byte tag) throws Asn1Exception {
        if (this.getDefaultTag() != tag) {
            throw new Asn1Exception("Se esperaba un tipo " + HexUtils.hexify(new byte[]{this.getDefaultTag()}, false) + " (" + this.getClass().getName() + ") pero se encontro un tipo " + HexUtils.hexify(new byte[]{tag}, false));
        }
    }
}

