/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.apdu.iso7816four.pace;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.iso7816four.MseSetAuthenticationTemplateApduCommand;

public class MseSetPaceAlgorithmApduCommand
extends MseSetAuthenticationTemplateApduCommand {
    public MseSetPaceAlgorithmApduCommand(byte cla, PaceAlgorithmOid algorithm, PacePasswordType pwdType, PaceAlgorithmParam algorithmParam) {
        super(cla, HexUtils.concatenateByteArrays({-128}, algorithm.getBytes(), pwdType.getBytes(), algorithmParam.getBytes()));
    }

    public static enum PaceAlgorithmOid {
        PACE_ECDH_GM_AES_CBC_CMAC_128(new byte[]{10, 4, 0, 127, 0, 7, 2, 2, 4, 2, 2}),
        PACE_DH_GM_AES_CBC_CMAC_128(new byte[]{10, 4, 0, 127, 0, 7, 2, 2, 4, 1, 2});

        private final byte[] oidBytes;

        private PaceAlgorithmOid(byte[] oid) {
            this.oidBytes = (byte[])oid.clone();
        }

        public byte[] getBytes() {
            return (byte[])this.oidBytes.clone();
        }
    }

    public static enum PacePasswordType {
        MRZ(new byte[]{-125, 1, 1}),
        CAN(new byte[]{-125, 1, 2});

        private final byte[] pwdTypeBytes;

        private PacePasswordType(byte[] tpy) {
            this.pwdTypeBytes = (byte[])tpy.clone();
        }

        public byte[] getBytes() {
            return (byte[])this.pwdTypeBytes.clone();
        }
    }

    public static enum PaceAlgorithmParam {
        BRAINPOOL_256_R1(new byte[]{-124, 1, 13});

        private final byte[] paramBytes;

        private PaceAlgorithmParam(byte[] paramId) {
            this.paramBytes = (byte[])paramId.clone();
        }

        public byte[] getBytes() {
            return (byte[])this.paramBytes.clone();
        }
    }
}

