/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.apdu.gide;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.CommandApdu;
import javax.security.auth.callback.PasswordCallback;

public final class VerifyApduCommand
extends CommandApdu {
    private static final byte INS_VERIFY = 32;
    private static final byte CLA = 1;

    public VerifyApduCommand(PasswordCallback pinPc) {
        super((byte)1, (byte)32, (byte)0, (byte)2, VerifyApduCommand.getPin(pinPc), null);
        if (pinPc == null) {
            throw new IllegalArgumentException("No se puede verificar el titular con un PasswordCallback nulo");
        }
    }

    private static byte[] getPin(PasswordCallback pinPc) {
        if (pinPc == null) {
            throw new IllegalArgumentException("El PasswordCallback del PIN no puede ser nulo");
        }
        char[] in = pinPc.getPassword();
        return HexUtils.charArrayToByteArray(in);
    }
}

