/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.apdu.gemalto;

import es.gob.jmulticard.apdu.CommandApdu;
import javax.security.auth.callback.PasswordCallback;

public final class VerifyApduCommand
extends CommandApdu {
    private static final byte INS_VERIFY = 32;
    private final PasswordCallback pwc;

    public VerifyApduCommand(byte cla, PasswordCallback pinPc) {
        super(cla, (byte)32, (byte)0, (byte)-127, new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, null);
        if (pinPc == null) {
            throw new IllegalArgumentException("No se puede verificar el titular con un PasswordCallback nulo");
        }
        this.pwc = pinPc;
    }

    @Override
    public byte[] getBytes() {
        int i;
        byte[] currentApdu = super.getBytes();
        char[] p = this.pwc.getPassword();
        for (i = 0; i < p.length; ++i) {
            currentApdu[i + 5] = (byte)p[i];
        }
        for (i = 0; i < p.length; ++i) {
            p[i] = '\u0000';
        }
        return currentApdu;
    }
}

