/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.apdu.connection.cwa14890;

import es.gob.jmulticard.CryptoHelper;
import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.CommandApdu;
import es.gob.jmulticard.apdu.ResponseApdu;
import es.gob.jmulticard.apdu.StatusWord;
import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.apdu.connection.ApduConnectionProtocol;
import es.gob.jmulticard.apdu.connection.ApduEncrypter;
import es.gob.jmulticard.apdu.connection.ApduEncrypterDes;
import es.gob.jmulticard.apdu.connection.CardConnectionListener;
import es.gob.jmulticard.apdu.connection.CipheredApdu;
import es.gob.jmulticard.apdu.connection.cwa14890.Cwa14890Connection;
import es.gob.jmulticard.apdu.connection.cwa14890.InvalidCryptographicChecksumException;
import es.gob.jmulticard.apdu.connection.cwa14890.SecureChannelException;
import es.gob.jmulticard.card.cwa14890.Cwa14890Card;
import es.gob.jmulticard.card.cwa14890.Cwa14890PrivateConstants;
import es.gob.jmulticard.card.cwa14890.Cwa14890PublicConstants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class Cwa14890OneV1Connection
implements Cwa14890Connection {
    private static final int SHA1_LENGTH = 20;
    private static final int KICC_LENGTH = 32;
    private static final int KIFD_LENGTH = 32;
    private static final byte ISO_9796_2_PADDING_START = 106;
    private static final byte ISO_9796_2_PADDING_END = -68;
    private static final StatusWord INVALID_CRYPTO_CHECKSUM = new StatusWord(102, -120);
    private static final byte MSB_INCORRECT_LE = 108;
    private static final byte MSB_INCORRECT_LE_PACE = 98;
    private static final byte[] SECURE_CHANNEL_KENC_AUX = new byte[]{0, 0, 0, 1};
    private static final byte[] SECURE_CHANNEL_KMAC_AUX = new byte[]{0, 0, 0, 2};
    protected final CryptoHelper cryptoHelper;
    private Cwa14890Card card;
    protected ApduConnection subConnection;
    private byte[] kenc = null;
    private byte[] kmac = null;
    private byte[] ssc = null;
    protected boolean openState = false;
    protected final ApduEncrypter apduEncrypter;
    private Cwa14890PublicConstants pubConsts;
    private Cwa14890PrivateConstants privConsts;

    protected ApduEncrypter instantiateApduEncrypter() {
        return new ApduEncrypterDes();
    }

    public Cwa14890OneV1Connection(ApduConnection connection, CryptoHelper cryptoHelper) {
        if (cryptoHelper == null) {
            throw new IllegalArgumentException("CryptoHelper no puede ser nulo");
        }
        this.subConnection = connection instanceof Cwa14890Connection ? ((Cwa14890Connection)connection).getSubConnection() : connection;
        this.cryptoHelper = cryptoHelper;
        this.apduEncrypter = this.instantiateApduEncrypter();
    }

    public Cwa14890OneV1Connection(Cwa14890Card card, ApduConnection connection, CryptoHelper cryptoHelper, Cwa14890PublicConstants cwaConsts, Cwa14890PrivateConstants cwaPrivConsts) {
        if (card == null) {
            throw new IllegalArgumentException("No se ha proporcionado la tarjeta CWA-14890 con la que abrir el canal seguro");
        }
        if (cryptoHelper == null) {
            throw new IllegalArgumentException("CryptoHelper no puede ser nulo");
        }
        if (cwaConsts == null) {
            throw new IllegalArgumentException("las claves CWA-14890 no pueden ser nulas");
        }
        this.card = card;
        this.subConnection = connection instanceof Cwa14890Connection ? ((Cwa14890Connection)connection).getSubConnection() : connection;
        this.cryptoHelper = cryptoHelper;
        this.apduEncrypter = this.instantiateApduEncrypter();
        this.pubConsts = cwaConsts;
        this.privConsts = cwaPrivConsts;
    }

    @Override
    public void open() throws ApduConnectionException {
        byte[] kifd;
        byte[] kicc;
        byte[] randomIfd;
        RSAPublicKey iccPublicKey;
        ApduConnection conn = this.subConnection;
        conn.open();
        byte[] serial = this.getPaddedSerial();
        try {
            this.card.verifyCaIntermediateIcc();
            this.card.verifyIcc();
        }
        catch (SecurityException e) {
            conn.close();
            throw new IllegalStateException("Condicion de seguridad no satisfecha en la validacion de los certificados CWA-14890: " + e);
        }
        catch (CertificateException e) {
            conn.close();
            throw new IllegalStateException("No se han podido tratar los certificados CWA-14890: " + e);
        }
        catch (IOException e) {
            conn.close();
            throw new IllegalStateException("No se han podido validar los certificados CWA-14890: " + e);
        }
        try {
            iccPublicKey = (RSAPublicKey)this.cryptoHelper.generateCertificate(this.card.getIccCertEncoded()).getPublicKey();
        }
        catch (CertificateException e) {
            conn.close();
            throw new ApduConnectionException("No se pudo obtener la clave publica del certificado de componente: " + e, e);
        }
        catch (IOException e) {
            conn.close();
            throw new ApduConnectionException("No se pudo leer certificado de componente: " + e, e);
        }
        try {
            this.card.verifyIfdCertificateChain(this.pubConsts);
        }
        catch (Exception e) {
            conn.close();
            throw new ApduConnectionException("Error al verificar la cadena de certificados del controlador: " + e, e);
        }
        try {
            randomIfd = this.cryptoHelper.generateRandomBytes(8);
        }
        catch (IOException e1) {
            conn.close();
            throw new SecureChannelException("No se pudo generar el array de aleatorios: " + e1, e1);
        }
        try {
            kicc = this.internalAuthentication(randomIfd, iccPublicKey);
        }
        catch (Exception e) {
            conn.close();
            throw new ApduConnectionException("Error durante el proceso de autenticacion interna de la tarjeta: " + e, e);
        }
        byte[] randomIcc = this.card.getChallenge();
        try {
            kifd = this.externalAuthentication(serial, randomIcc, iccPublicKey);
        }
        catch (Exception e) {
            conn.close();
            throw new ApduConnectionException("Error durante el proceso de autenticacion externa de la tarjeta", e);
        }
        byte[] kidficc = HexUtils.xor(kicc, kifd);
        try {
            this.kenc = this.generateKenc(kidficc);
        }
        catch (IOException e) {
            conn.close();
            throw new ApduConnectionException("Error al generar la clave Kenc para el tratamiento del canal seguro", e);
        }
        try {
            this.kmac = this.generateKmac(kidficc);
        }
        catch (IOException e) {
            conn.close();
            throw new ApduConnectionException("Error al generar la clave Kmac para el tratamiento del canal seguro", e);
        }
        this.ssc = Cwa14890OneV1Connection.generateSsc(randomIfd, randomIcc);
        this.openState = true;
    }

    private byte[] generateKenc(byte[] kidficc) throws IOException {
        byte[] kidficcConcat = HexUtils.concatenateByteArrays(kidficc, SECURE_CHANNEL_KENC_AUX);
        byte[] keyEnc = new byte[16];
        System.arraycopy(this.cryptoHelper.digest(CryptoHelper.DigestAlgorithm.SHA1, kidficcConcat), 0, keyEnc, 0, keyEnc.length);
        return keyEnc;
    }

    private byte[] generateKmac(byte[] kidficc) throws IOException {
        byte[] kidficcConcat = HexUtils.concatenateByteArrays(kidficc, SECURE_CHANNEL_KMAC_AUX);
        byte[] keyMac = new byte[16];
        System.arraycopy(this.cryptoHelper.digest(CryptoHelper.DigestAlgorithm.SHA1, kidficcConcat), 0, keyMac, 0, keyMac.length);
        return keyMac;
    }

    private static byte[] generateSsc(byte[] randomIfd, byte[] randomIcc) {
        byte[] ssc = new byte[8];
        System.arraycopy(randomIcc, 4, ssc, 0, 4);
        System.arraycopy(randomIfd, 4, ssc, 4, 4);
        return ssc;
    }

    private byte[] internalAuthentication(byte[] randomIfd, RSAPublicKey iccPublicKey) throws SecureChannelException, ApduConnectionException, IOException {
        byte[] sigMin;
        try {
            this.card.setKeysToAuthentication(this.card.getChrCCvIfd(this.pubConsts), this.card.getRefIccPrivateKey(this.pubConsts));
        }
        catch (Exception e) {
            throw new SecureChannelException("Error durante el establecimiento de la clave publica de Terminal y la privada de componente para su atenticacion", e);
        }
        byte[] sigMinCiphered = this.card.getInternalAuthenticateMessage(randomIfd, this.card.getChrCCvIfd(this.pubConsts));
        byte[] sig = sigMin = this.cryptoHelper.rsaDecrypt(sigMinCiphered, this.card.getIfdPrivateKey(this.privConsts));
        byte[] desMsg = this.cryptoHelper.rsaEncrypt(sig, iccPublicKey);
        if (desMsg[0] != 106 || desMsg[desMsg.length - 1] != -68) {
            byte[] sub = iccPublicKey.getModulus().subtract(new BigInteger(sigMin)).toByteArray();
            byte[] niccMinusSig = new byte[this.card.getIfdKeyLength(this.pubConsts)];
            if (sub.length > this.card.getIfdKeyLength(this.pubConsts) && sub[0] == 0) {
                System.arraycopy(sub, 1, niccMinusSig, 0, sub.length - 1);
            } else {
                System.arraycopy(sub, 0, niccMinusSig, 0, sub.length);
            }
            desMsg = this.cryptoHelper.rsaDecrypt(niccMinusSig, iccPublicKey);
            if (desMsg[0] != 106 || desMsg[desMsg.length - 1] != -68) {
                throw new SecureChannelException("Error en la autenticacion interna para el establecimiento del canal seguro. El mensaje descifrado es:\n" + HexUtils.hexify(desMsg, true));
            }
        }
        byte[] prnd1 = new byte[this.card.getIfdKeyLength(this.pubConsts) - 32 - 20 - 2];
        System.arraycopy(desMsg, 1, prnd1, 0, prnd1.length);
        byte[] kicc = new byte[32];
        System.arraycopy(desMsg, prnd1.length + 1, kicc, 0, kicc.length);
        byte[] hash = new byte[20];
        System.arraycopy(desMsg, prnd1.length + kicc.length + 1, hash, 0, hash.length);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(prnd1);
        baos.write(kicc);
        baos.write(randomIfd);
        baos.write(this.card.getChrCCvIfd(this.pubConsts));
        byte[] calculatedHash = this.cryptoHelper.digest(CryptoHelper.DigestAlgorithm.SHA1, baos.toByteArray());
        if (!HexUtils.arrayEquals(hash, calculatedHash)) {
            throw new SecureChannelException("Error en la comprobacion de la clave de autenticacion interna. Se obtuvo el hash '" + HexUtils.hexify(calculatedHash, false) + "' cuando se esperaba: '" + HexUtils.hexify(hash, false) + "'");
        }
        return kicc;
    }

    private byte[] externalAuthentication(byte[] serial, byte[] randomIcc, RSAPublicKey iccPublicKey) throws IOException {
        byte[] prnd2 = this.cryptoHelper.generateRandomBytes(this.card.getIfdKeyLength(this.pubConsts) - 2 - 32 - 20);
        byte[] kifd = this.cryptoHelper.generateRandomBytes(32);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(prnd2);
        baos.write(kifd);
        baos.write(randomIcc);
        baos.write(serial);
        byte[] hash = this.cryptoHelper.digest(CryptoHelper.DigestAlgorithm.SHA1, baos.toByteArray());
        baos.reset();
        baos.write(106);
        baos.write(prnd2);
        baos.write(kifd);
        baos.write(hash);
        baos.write(-68);
        byte[] msg = baos.toByteArray();
        RSAPrivateKey ifdPrivateKey = this.card.getIfdPrivateKey(this.privConsts);
        byte[] sig = this.cryptoHelper.rsaDecrypt(msg, ifdPrivateKey);
        BigInteger biSig = new BigInteger(1, sig);
        byte[] sigMin = ifdPrivateKey.getModulus().subtract(biSig).min(biSig).toByteArray();
        byte[] extAuthenticationData = this.cryptoHelper.rsaEncrypt(sigMin, iccPublicKey);
        boolean valid = this.card.externalAuthentication(extAuthenticationData);
        if (!valid) {
            throw new SecureChannelException("Error durante la autenticacion externa del canal seguro");
        }
        return kifd;
    }

    private byte[] getPaddedSerial() throws ApduConnectionException {
        byte[] serial = this.card.getSerialNumber();
        byte[] paddedSerial = serial;
        if (paddedSerial.length < 8) {
            int i;
            paddedSerial = new byte[8];
            for (i = 0; i < 8 - serial.length; ++i) {
                paddedSerial[i] = 0;
            }
            System.arraycopy(serial, 0, paddedSerial, i, serial.length);
        }
        return paddedSerial;
    }

    @Override
    public void close() throws ApduConnectionException {
        if (this.openState) {
            this.subConnection.close();
            this.openState = false;
        }
    }

    @Override
    public ResponseApdu transmit(CommandApdu command) throws ApduConnectionException {
        CipheredApdu protectedApdu;
        try {
            this.ssc = Cwa14890OneV1Connection.increment(this.ssc);
            protectedApdu = this.apduEncrypter.protectAPDU(command, this.kenc, this.kmac, this.ssc, this.cryptoHelper);
        }
        catch (IOException e) {
            throw new SecureChannelException("Error en la encriptacion de la APDU para su envio por el canal seguro: " + e, e);
        }
        ResponseApdu responseApdu = this.subConnection.transmit(protectedApdu);
        if (INVALID_CRYPTO_CHECKSUM.equals(responseApdu.getStatusWord())) {
            throw new InvalidCryptographicChecksumException();
        }
        try {
            this.ssc = Cwa14890OneV1Connection.increment(this.ssc);
            ResponseApdu decipherApdu = this.apduEncrypter.decryptResponseApdu(responseApdu, this.kenc, this.ssc, this.kmac, this.cryptoHelper);
            if (decipherApdu.getStatusWord().getMsb() == 108) {
                command.setLe(decipherApdu.getStatusWord().getLsb());
                return this.transmit(command);
            }
            if (decipherApdu.getStatusWord().getMsb() == 98) {
                command.setLe(command.getLe() - 1);
                return this.transmit(command);
            }
            return decipherApdu;
        }
        catch (Exception e) {
            throw new ApduConnectionException("Error en la desencriptacion de la APDU de respuesta recibida por el canal seguro: " + e, e);
        }
    }

    @Override
    public byte[] reset() throws ApduConnectionException {
        this.openState = false;
        byte[] atr = this.subConnection.reset();
        this.open();
        return atr;
    }

    @Override
    public void addCardConnectionListener(CardConnectionListener ccl) {
        this.subConnection.addCardConnectionListener(ccl);
    }

    @Override
    public void removeCardConnectionListener(CardConnectionListener ccl) {
        this.subConnection.removeCardConnectionListener(ccl);
    }

    @Override
    public long[] getTerminals(boolean onlyWithCardPresent) throws ApduConnectionException {
        return this.subConnection.getTerminals(onlyWithCardPresent);
    }

    @Override
    public String getTerminalInfo(int terminal) throws ApduConnectionException {
        return this.subConnection.getTerminalInfo(terminal);
    }

    @Override
    public void setTerminal(int t) {
        this.subConnection.setTerminal(t);
    }

    @Override
    public boolean isOpen() {
        return this.openState && this.subConnection.isOpen();
    }

    private static byte[] increment(byte[] data) {
        BigInteger bi = new BigInteger(1, data);
        byte[] biArray = (bi = bi.add(BigInteger.ONE)).toByteArray();
        if (biArray.length > 8) {
            byte[] incrementedValue = new byte[8];
            System.arraycopy(biArray, biArray.length - incrementedValue.length, incrementedValue, 0, incrementedValue.length);
            return incrementedValue;
        }
        if (biArray.length < 8) {
            byte[] incrementedValue = new byte[8];
            System.arraycopy(biArray, 0, incrementedValue, incrementedValue.length - biArray.length, biArray.length);
            return incrementedValue;
        }
        return biArray;
    }

    @Override
    public ApduConnection getSubConnection() {
        return this.subConnection;
    }

    @Override
    public void setProtocol(ApduConnectionProtocol p) {
        if (this.subConnection != null) {
            this.subConnection.setProtocol(p);
        }
    }
}

