/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.apdu.connection.cwa14890;

import es.gob.jmulticard.apdu.CommandApdu;
import java.io.ByteArrayOutputStream;

public final class CipheredApdu
extends CommandApdu {
    private static final byte TAG_CRYPTOGRAPHIC_CHECKSUM = -114;
    private final byte[] mac;
    private final byte[] data;

    byte[] getMac() {
        byte[] out = new byte[this.mac.length];
        System.arraycopy(this.mac, 0, out, 0, this.mac.length);
        return out;
    }

    byte[] getCryptogramData() {
        byte[] out = new byte[this.data.length];
        System.arraycopy(this.data, 0, out, 0, this.data.length);
        return out;
    }

    CipheredApdu(byte cla, byte ins, byte p1, byte p2, byte[] data, byte[] mac) {
        super(cla, ins, p1, p2, CipheredApdu.buildData(data, mac), null);
        this.mac = new byte[mac.length];
        System.arraycopy(mac, 0, this.mac, 0, mac.length);
        this.data = new byte[data.length];
        System.arraycopy(data, 0, this.data, 0, data.length);
    }

    private static byte[] buildData(byte[] data, byte[] mac) {
        if (data == null || mac == null) {
            throw new IllegalArgumentException("Ni los datos (TLV) ni el MAC pueden ser nulos");
        }
        if (mac.length == 4 && mac.length == 8) {
            throw new IllegalArgumentException("El MAC debe medir cuatro u ocho octetos, y el recibido mide " + mac.length + " octetos");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(data);
            baos.write(-114);
            baos.write((byte)mac.length);
            baos.write(mac);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error creando la APDU cifrada: " + e);
        }
        return baos.toByteArray();
    }

    @Override
    public void setLe(int le) {
        throw new UnsupportedOperationException("No se puede establecer el Le en una APDU cifrada");
    }
}

