/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.apdu.connection;

import es.gob.jmulticard.CryptoHelper;
import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.ResponseApdu;
import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.apdu.connection.ApduEncrypter;
import es.gob.jmulticard.apdu.connection.cwa14890.InvalidCryptographicChecksumException;
import es.gob.jmulticard.apdu.connection.cwa14890.SecureChannelException;
import es.gob.jmulticard.asn1.bertlv.BerTlv;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class ApduEncrypterDes
extends ApduEncrypter {
    private static final byte TAG_SW_TLV = -103;
    private static final byte TAG_MAC_TLV = -114;
    private static final byte MAC_LENGTH_4 = 4;

    public ApduEncrypterDes() {
        this.paddingLength = 8;
    }

    protected int getMacLength() {
        return 4;
    }

    @Override
    protected byte[] encryptData(byte[] data, byte[] key, byte[] ssc, CryptoHelper cryptoHelper) throws IOException {
        return cryptoHelper.desedeEncrypt(data, key);
    }

    @Override
    protected byte[] generateMac(byte[] dataPadded, byte[] ssc, byte[] kMac, CryptoHelper cryptoHelper) throws IOException {
        int i;
        byte[] keyDesBytes = new byte[8];
        System.arraycopy(kMac, 0, keyDesBytes, 0, 8);
        byte[] tmpData = cryptoHelper.desEncrypt(ssc, keyDesBytes);
        for (i = 0; i < dataPadded.length - 8; i += 8) {
            tmpData = cryptoHelper.desEncrypt(HexUtils.xor(tmpData, HexUtils.subArray(dataPadded, i, 8)), keyDesBytes);
        }
        byte[] keyTdesBytes = new byte[24];
        System.arraycopy(kMac, 0, keyTdesBytes, 0, 16);
        System.arraycopy(kMac, 0, keyTdesBytes, 16, 8);
        return HexUtils.subArray(cryptoHelper.desedeEncrypt(HexUtils.xor(tmpData, HexUtils.subArray(dataPadded, i, 8)), keyTdesBytes), 0, this.getMacLength());
    }

    @Override
    public ResponseApdu decryptResponseApdu(ResponseApdu responseApdu, byte[] keyCipher, byte[] ssc, byte[] kMac, CryptoHelper cryptoHelper) throws IOException {
        if (!responseApdu.isOk()) {
            return new ResponseApdu(responseApdu.getStatusWord().getBytes());
        }
        ByteArrayInputStream recordOfTlvs = new ByteArrayInputStream(responseApdu.getData());
        BerTlv dataTlv = null;
        BerTlv swTlv = null;
        BerTlv macTlv = null;
        try {
            BerTlv tlv = BerTlv.getInstance(recordOfTlvs);
            if (tlv.getTag().getTagValue() == -121) {
                dataTlv = tlv;
                tlv = BerTlv.getInstance(recordOfTlvs);
            }
            if (tlv.getTag().getTagValue() == -103) {
                swTlv = tlv;
                tlv = BerTlv.getInstance(recordOfTlvs);
            }
            if (tlv.getTag().getTagValue() == -114) {
                macTlv = tlv;
            }
        }
        catch (NegativeArraySizeException e) {
            throw new ApduConnectionException("Error en el formato de la respuesta remitida por el canal seguro", e);
        }
        if (macTlv == null) {
            throw new SecureChannelException("No se ha encontrado el TLV del MAC en la APDU");
        }
        if (swTlv == null) {
            throw new SecureChannelException("No se ha encontrado el TLV del StatusWord en la APDU cifrada");
        }
        int tlvsLenght = (dataTlv != null ? 2 + dataTlv.getValue().length / 128 + dataTlv.getValue().length : 0) + 1 + 1 + swTlv.getValue().length;
        this.verifyMac(HexUtils.subArray(responseApdu.getData(), 0, tlvsLenght), macTlv.getValue(), ssc, kMac, cryptoHelper);
        if (dataTlv == null) {
            return new ResponseApdu(swTlv.getValue());
        }
        byte[] decryptedData = ApduEncrypterDes.removePadding7816(cryptoHelper.desedeDecrypt(HexUtils.subArray(dataTlv.getValue(), 1, dataTlv.getValue().length - 1), keyCipher));
        byte[] responseApduBytes = new byte[decryptedData.length + swTlv.getValue().length];
        System.arraycopy(decryptedData, 0, responseApduBytes, 0, decryptedData.length);
        System.arraycopy(swTlv.getValue(), 0, responseApduBytes, decryptedData.length, swTlv.getValue().length);
        return new ResponseApdu(responseApduBytes);
    }

    private void verifyMac(byte[] verificableData, byte[] macTlvBytes, byte[] ssc, byte[] kMac, CryptoHelper cryptoHelper) {
        byte[] calculatedMac;
        try {
            calculatedMac = this.generateMac(ApduEncrypterDes.addPadding7816(verificableData, this.paddingLength), ssc, kMac, cryptoHelper);
        }
        catch (IOException e) {
            throw new SecurityException("No se pudo calcular el MAC teorico de la respuesta del DNIe para su verificacion: " + e);
        }
        if (!HexUtils.arrayEquals(macTlvBytes, calculatedMac)) {
            throw new InvalidCryptographicChecksumException();
        }
    }
}

