/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.apdu.connection;

import es.gob.jmulticard.CryptoHelper;
import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.ResponseApdu;
import es.gob.jmulticard.apdu.connection.ApduEncrypter;
import java.io.IOException;
import java.util.logging.Logger;

public final class ApduEncrypterAes
extends ApduEncrypter {
    private static final Logger LOGGER = Logger.getLogger("es.gob.jmulticard");

    public ApduEncrypterAes() {
        LOGGER.info("Se usara AES y CMAC para el cifrado de mensajes en el canal seguro");
        this.paddingLength = 16;
    }

    @Override
    protected byte[] encryptData(byte[] data, byte[] key, byte[] ssc, CryptoHelper cryptoHelper) throws IOException {
        if (ssc == null) {
            throw new IllegalArgumentException("El contador de secuencia no puede ser nulo en esta version de CWA-14890");
        }
        byte[] iv = cryptoHelper.aesEncrypt(ssc, new byte[0], key);
        return cryptoHelper.aesEncrypt(data, iv, key);
    }

    @Override
    protected byte[] generateMac(byte[] dataPadded, byte[] ssc, byte[] kMac, CryptoHelper cryptoHelper) throws IOException {
        byte[] mac;
        try {
            mac = cryptoHelper.doAesCmac(HexUtils.concatenateByteArrays(ssc, dataPadded), kMac);
        }
        catch (Exception e) {
            throw new IOException("Error creando la CMAC de la APDU cifrada: " + e);
        }
        byte[] ret = new byte[8];
        System.arraycopy(mac, 0, ret, 0, 8);
        return ret;
    }

    @Override
    public ResponseApdu decryptResponseApdu(ResponseApdu responseApdu, byte[] keyCipher, byte[] ssc, byte[] kMac, CryptoHelper cryptoHelper) {
        return null;
    }
}

