/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.apdu.connection;

import es.gob.jmulticard.CryptoHelper;
import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.CommandApdu;
import es.gob.jmulticard.apdu.ResponseApdu;
import es.gob.jmulticard.apdu.connection.CipheredApdu;
import es.gob.jmulticard.asn1.Tlv;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public abstract class ApduEncrypter {
    protected static final byte TAG_DATA_TLV = -121;
    private static final byte TAG_LE_TLV = -105;
    private static final byte TLV_VALUE_PREFIX_TO_MAC = 1;
    private static final byte CLA_OF_PROTECTED_APDU = 12;
    private static final byte ISO7816_PADDING_PREFIX = -128;
    protected int paddingLength = 8;

    public CipheredApdu protectAPDU(CommandApdu unprotectedApdu, byte[] keyCipher, byte[] keyMac, byte[] sendSequenceCounter, CryptoHelper cryptoHelper) throws IOException {
        byte cla = unprotectedApdu.getCla();
        byte ins = unprotectedApdu.getIns();
        byte p1 = unprotectedApdu.getP1();
        byte p2 = unprotectedApdu.getP2();
        byte[] data = unprotectedApdu.getData();
        Integer le = unprotectedApdu.getLe();
        byte[] tlvDataBytes = this.getDataTlv(data, keyCipher, sendSequenceCounter, cryptoHelper, this.paddingLength);
        byte[] completeDataBytes = ApduEncrypter.getCompleteDataBytes(le, tlvDataBytes);
        cla = (byte)(cla | 0xC);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(ApduEncrypter.addPadding7816(new byte[]{cla, ins, p1, p2}, this.paddingLength));
        baos.write(completeDataBytes);
        byte[] encryptedDataPadded = ApduEncrypter.addPadding7816(baos.toByteArray(), this.paddingLength);
        byte[] mac = this.generateMac(encryptedDataPadded, sendSequenceCounter, keyMac, cryptoHelper);
        return new CipheredApdu(cla, ins, p1, p2, completeDataBytes, mac);
    }

    protected abstract byte[] encryptData(byte[] var1, byte[] var2, byte[] var3, CryptoHelper var4) throws IOException;

    protected static byte[] addPadding7816(byte[] data, int size) {
        byte[] paddedData = new byte[(data.length / size + 1) * size];
        System.arraycopy(data, 0, paddedData, 0, data.length);
        paddedData[data.length] = -128;
        for (int i = data.length + 1; i < paddedData.length; ++i) {
            paddedData[i] = 0;
        }
        return paddedData;
    }

    protected static byte[] removePadding7816(byte[] paddedData) {
        for (int i = paddedData.length - 1; i >= 0; --i) {
            if (paddedData[i] == -128) {
                if (i == 0) {
                    return new byte[0];
                }
                return HexUtils.subArray(paddedData, 0, i);
            }
            if (paddedData[i] == 0) continue;
            return paddedData;
        }
        return paddedData;
    }

    protected abstract byte[] generateMac(byte[] var1, byte[] var2, byte[] var3, CryptoHelper var4) throws IOException;

    public abstract ResponseApdu decryptResponseApdu(ResponseApdu var1, byte[] var2, byte[] var3, byte[] var4, CryptoHelper var5) throws IOException;

    private static void wipeByteArray(byte[] in) {
        if (in != null) {
            for (int i = 0; i < in.length; ++i) {
                in[i] = 0;
            }
        }
    }

    private static byte[] getCompleteDataBytes(Integer le, byte[] tlvDataBytes) {
        byte[] tlvLeBytes = new byte[]{};
        if (le != null) {
            tlvLeBytes = new Tlv(-105, new byte[]{le.byteValue()}).getBytes();
        }
        byte[] completeDataBytes = new byte[tlvDataBytes.length + tlvLeBytes.length];
        System.arraycopy(tlvDataBytes, 0, completeDataBytes, 0, tlvDataBytes.length);
        System.arraycopy(tlvLeBytes, 0, completeDataBytes, tlvDataBytes.length, tlvLeBytes.length);
        return completeDataBytes;
    }

    private byte[] getDataTlv(byte[] data, byte[] keyCipher, byte[] sendSequenceCounter, CryptoHelper cryptoHelper, int paddingSize) throws IOException {
        if (data != null && data.length > 0) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(1);
            byte[] paddedData = ApduEncrypter.addPadding7816(data, paddingSize);
            baos.write(this.encryptData(paddedData, keyCipher, sendSequenceCounter, cryptoHelper));
            ApduEncrypter.wipeByteArray(paddedData);
            ApduEncrypter.wipeByteArray(data);
            return new Tlv(-121, baos.toByteArray()).getBytes();
        }
        return new byte[0];
    }
}

