/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.apdu;

import es.gob.jmulticard.apdu.Apdu;
import java.io.ByteArrayOutputStream;

public class CommandApdu
extends Apdu {
    private final byte cla;
    private final byte ins;
    private final byte p1;
    private final byte p2;
    private Integer le;
    private final byte[] body;

    private static byte[] getBody(byte[] bytes) {
        if (bytes == null || bytes.length < 5) {
            throw new IllegalArgumentException("La longitud del array de octetos debe ser igual o mayor que 5.");
        }
        int i = bytes[4] & 0xFF;
        if (bytes.length > 5) {
            byte[] data = new byte[i];
            System.arraycopy(bytes, 5, data, 0, i);
            return data;
        }
        return null;
    }

    private static Integer getLength(byte[] bytes) {
        if (bytes == null || bytes.length < 5) {
            throw new IllegalArgumentException("La longitud del array de octetos debe ser igual o mayor que 5.");
        }
        int i = bytes[4] & 0xFF;
        if (bytes.length > 5 && bytes.length > i + 5) {
            return bytes[i + 5];
        }
        if (bytes.length == 5) {
            return i;
        }
        return null;
    }

    public CommandApdu(byte[] bytes) {
        this(bytes[0], bytes[1], bytes[2], bytes[3], CommandApdu.getBody(bytes), CommandApdu.getLength(bytes));
    }

    public CommandApdu(byte cla, byte ins, byte param1, byte param2, byte[] data, Integer ne) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.cla = cla;
        baos.write(cla);
        this.ins = ins;
        baos.write(ins);
        this.p1 = param1;
        baos.write(param1);
        this.p2 = param2;
        baos.write(param2);
        if (data == null) {
            this.body = null;
        } else {
            this.body = new byte[data.length];
            System.arraycopy(data, 0, this.body, 0, data.length);
            if (data.length <= 255) {
                baos.write(Integer.valueOf(String.valueOf(this.body.length)).byteValue());
            } else {
                baos.write(0);
                int dataLength = this.body.length;
                byte lc1 = (byte)(dataLength >> 8 & 0xFF);
                byte lc2 = (byte)(dataLength & 0xFF);
                baos.write(lc1);
                baos.write(lc2);
            }
            if (this.body.length > 0) {
                try {
                    baos.write(this.body);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("No se pueden tratar los datos de la APDU: " + e);
                }
            }
        }
        this.le = ne;
        if (ne != null) {
            baos.write(ne.byteValue());
        }
        this.setBytes(baos.toByteArray());
    }

    public byte getCla() {
        return this.cla;
    }

    public byte[] getData() {
        if (this.body == null) {
            return null;
        }
        byte[] out = new byte[this.body.length];
        System.arraycopy(this.body, 0, out, 0, this.body.length);
        return out;
    }

    public byte getIns() {
        return this.ins;
    }

    public Integer getLe() {
        return this.le;
    }

    public byte getP1() {
        return this.p1;
    }

    public byte getP2() {
        return this.p2;
    }

    public void setLe(int le) {
        this.le = Integer.valueOf(String.valueOf(le));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.cla);
        baos.write(this.ins);
        baos.write(this.p1);
        baos.write(this.p2);
        if (this.body != null && this.body.length > 0) {
            try {
                baos.write(this.body);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("No se pueden tratar los datos de la APDU: " + e);
            }
        }
        baos.write(le);
        this.setBytes(baos.toByteArray());
    }
}

