/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard;

import es.gob.jmulticard.CryptoHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.spongycastle.crypto.engines.AESEngine;
import org.spongycastle.crypto.macs.CMac;
import org.spongycastle.crypto.params.KeyParameter;
import org.spongycastle.jce.ECNamedCurveTable;
import org.spongycastle.jce.ECPointUtil;
import org.spongycastle.jce.provider.BouncyCastleProvider;
import org.spongycastle.jce.spec.ECNamedCurveParameterSpec;
import org.spongycastle.jce.spec.ECNamedCurveSpec;
import org.spongycastle.math.ec.ECCurve;
import org.spongycastle.math.ec.ECFieldElement;

public final class JseCryptoHelper
extends CryptoHelper {
    private static final Logger LOGGER = Logger.getLogger("es.gob.jmulticard");
    private static final String ECDH = "ECDH";

    @Override
    public byte[] digest(CryptoHelper.DigestAlgorithm algorithm, byte[] data) throws IOException {
        if (algorithm == null) {
            throw new IllegalArgumentException("El algoritmo de huella digital no puede ser nulo");
        }
        if (data == null) {
            throw new IllegalArgumentException("Los datos para realizar la huella digital no pueden ser nulos");
        }
        try {
            return MessageDigest.getInstance(algorithm.toString()).digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("El sistema no soporta el algoritmo de huella digital indicado ('" + (Object)((Object)algorithm) + "'): " + e, e);
        }
    }

    private static byte[] doDesede(byte[] data, byte[] key, int direction) throws IOException {
        byte[] ivBytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            ivBytes[i] = 0;
        }
        SecretKeySpec k = new SecretKeySpec(JseCryptoHelper.prepareDesedeKey(key), "DESede");
        try {
            Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
            cipher.init(direction, (Key)k, new IvParameterSpec(ivBytes));
            byte[] cipheredData = cipher.doFinal(data);
            for (int i = 0; i < data.length; ++i) {
                data[i] = 0;
            }
            return cipheredData;
        }
        catch (Exception e) {
            for (int i = 0; i < data.length; ++i) {
                data[i] = 0;
            }
            throw new IOException("Error encriptando datos: " + e, e);
        }
    }

    @Override
    public byte[] desedeEncrypt(byte[] data, byte[] key) throws IOException {
        return JseCryptoHelper.doDesede(data, key, 1);
    }

    @Override
    public byte[] desedeDecrypt(byte[] data, byte[] key) throws IOException {
        return JseCryptoHelper.doDesede(data, key, 2);
    }

    private static byte[] prepareDesedeKey(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException("La clave 3DES no puede ser nula");
        }
        if (key.length == 24) {
            return key;
        }
        if (key.length == 16) {
            byte[] newKey = new byte[24];
            System.arraycopy(key, 0, newKey, 0, 16);
            System.arraycopy(key, 0, newKey, 16, 8);
            return newKey;
        }
        throw new IllegalArgumentException("Longitud de clave invalida, se esperaba 16 o 24, pero se indico " + Integer.toString(key.length));
    }

    private static byte[] doDes(byte[] data, byte[] key, int direction) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("La clave DES no puede ser nula");
        }
        if (key.length != 8) {
            throw new IllegalArgumentException("La clave DES debe ser de 8 octetos, pero la proporcionada es de " + key.length);
        }
        try {
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            cipher.init(direction, new SecretKeySpec(key, "DES"));
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new IOException("Error cifrando los datos con DES: " + e, e);
        }
    }

    @Override
    public byte[] desEncrypt(byte[] data, byte[] key) throws IOException {
        return JseCryptoHelper.doDes(data, key, 1);
    }

    @Override
    public byte[] desDecrypt(byte[] data, byte[] key) throws IOException {
        return JseCryptoHelper.doDes(data, key, 2);
    }

    private static byte[] doRsa(byte[] cipheredData, Key key, int direction) throws IOException {
        try {
            Cipher dec = Cipher.getInstance("RSA/ECB/NOPADDING");
            dec.init(direction, key);
            return dec.doFinal(cipheredData);
        }
        catch (Exception e) {
            throw new IOException("Error cifrando/descifrando los datos mediante la clave RSA: " + e, e);
        }
    }

    @Override
    public byte[] rsaDecrypt(byte[] cipheredData, Key key) throws IOException {
        return JseCryptoHelper.doRsa(cipheredData, key, 2);
    }

    @Override
    public byte[] rsaEncrypt(byte[] data, Key key) throws IOException {
        return JseCryptoHelper.doRsa(data, key, 1);
    }

    @Override
    public Certificate generateCertificate(byte[] encode) throws CertificateException {
        return CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(encode));
    }

    @Override
    public byte[] generateRandomBytes(int numBytes) throws IOException {
        SecureRandom sr;
        try {
            sr = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Algoritmo de generacion de aleatorios no valido: " + e, e);
        }
        byte[] randomBytes = new byte[numBytes];
        sr.nextBytes(randomBytes);
        return randomBytes;
    }

    private static byte[] aesCrypt(byte[] data, byte[] iv, byte[] key, int mode) throws IOException {
        byte[] ivector;
        Cipher aesCipher;
        if (data == null) {
            throw new IllegalArgumentException("Los datos a cifrar no pueden ser nulos");
        }
        if (key == null) {
            throw new IllegalArgumentException("La clave de cifrado no puede ser nula");
        }
        try {
            aesCipher = Cipher.getInstance("AES/CBC/NoPadding");
        }
        catch (Exception e) {
            throw new IOException("No se ha podido obtener una instancia del cifrador 'AES/CBC/NoPadding': " + e, e);
        }
        if (iv == null) {
            LOGGER.info("Se usara un vector de inicializacion AES aleatorio");
            ivector = new byte[aesCipher.getBlockSize()];
            new SecureRandom().nextBytes(ivector);
        } else if (iv.length == 0) {
            LOGGER.warning("Se usara un vector de inicializacion AES vacio");
            ivector = new byte[aesCipher.getBlockSize()];
        } else {
            ivector = iv;
        }
        try {
            aesCipher.init(mode, (Key)new SecretKeySpec(key, "AES"), new IvParameterSpec(ivector));
        }
        catch (Exception e) {
            throw new IOException("La clave proporcionada no es valida: " + e, e);
        }
        try {
            return aesCipher.doFinal(data);
        }
        catch (Exception e) {
            throw new IOException("Error en el descifrado, posiblemente los datos proporcionados no sean validos: " + e, e);
        }
    }

    @Override
    public byte[] aesDecrypt(byte[] data, byte[] iv, byte[] key) throws IOException {
        return JseCryptoHelper.aesCrypt(data, iv, key, 2);
    }

    @Override
    public byte[] aesEncrypt(byte[] data, byte[] iv, byte[] key) throws IOException {
        return JseCryptoHelper.aesCrypt(data, iv, key, 1);
    }

    @Override
    public KeyPair generateEcKeyPair(CryptoHelper.EcCurve curveName) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyPairGenerator kpg;
        if (Security.getProvider("SC") == null) {
            Security.insertProviderAt(new BouncyCastleProvider(), 1);
        }
        try {
            kpg = KeyPairGenerator.getInstance(ECDH, "SC");
        }
        catch (Exception e) {
            Logger.getLogger("es.gob.jmulticard").warning("No se ha podido obtener un generador de pares de claves de curva eliptica con SpongyCastle, se usara el generador por defecto: " + e);
            kpg = KeyPairGenerator.getInstance(ECDH);
        }
        Logger.getLogger("es.gob.jmulticard").info("Seleccionado el siguiente generador de claves de curva eliptica: " + kpg.getClass().getName());
        ECGenParameterSpec parameterSpec = new ECGenParameterSpec(curveName.toString());
        kpg.initialize(parameterSpec);
        return kpg.generateKeyPair();
    }

    @Override
    public byte[] doAesCmac(byte[] data, byte[] key) {
        AESEngine cipher = new AESEngine();
        CMac mac = new CMac(cipher, 64);
        KeyParameter keyP = new KeyParameter(key);
        mac.init(keyP);
        mac.update(data, 0, data.length);
        byte[] out = new byte[8];
        mac.doFinal(out, 0);
        return out;
    }

    @Override
    public byte[] doEcDh(Key privateKey, byte[] publicKey, CryptoHelper.EcCurve curveName) throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        KeyAgreement ka;
        if (Security.getProvider("SC") == null) {
            Security.insertProviderAt(new BouncyCastleProvider(), 1);
        }
        try {
            ka = KeyAgreement.getInstance(ECDH, "SC");
        }
        catch (NoSuchProviderException e) {
            LOGGER.warning("No se ha podido obtener el KeyAgreement ECDH de BouncyCastle, se intentara el por defecto: " + e);
            ka = KeyAgreement.getInstance(ECDH);
        }
        ka.init(privateKey);
        ka.doPhase(JseCryptoHelper.loadEcPublicKey(publicKey, curveName), true);
        return ka.generateSecret();
    }

    private static Key loadEcPublicKey(byte[] pubKey, CryptoHelper.EcCurve curveName) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory kf;
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec(curveName.toString());
        try {
            kf = KeyFactory.getInstance(ECDH, "SC");
        }
        catch (NoSuchProviderException e) {
            LOGGER.warning("No se ha podido obtener el KeyFactory ECDH de BouncyCastle, se intentara el por defecto: " + e);
            kf = KeyFactory.getInstance(ECDH);
        }
        ECNamedCurveSpec params = new ECNamedCurveSpec(curveName.toString(), spec.getCurve(), spec.getG(), spec.getN());
        ECPoint point = ECPointUtil.decodePoint(params.getCurve(), pubKey);
        ECPublicKeySpec pubKeySpec = new ECPublicKeySpec(point, params);
        return kf.generatePublic(pubKeySpec);
    }

    @Override
    public AlgorithmParameterSpec getEcPoint(byte[] nonceS, byte[] sharedSecretH, CryptoHelper.EcCurve curveName) {
        ECNamedCurveParameterSpec ecParams = ECNamedCurveTable.getParameterSpec(curveName.toString());
        BigInteger affineX = JseCryptoHelper.os2i(sharedSecretH);
        BigInteger affineY = JseCryptoHelper.computeAffineY(affineX, (ECParameterSpec)((Object)ecParams));
        ECPoint sharedSecretPointH = new ECPoint(affineX, affineY);
        return JseCryptoHelper.mapNonceGMWithECDH(JseCryptoHelper.os2i(nonceS), sharedSecretPointH, (ECParameterSpec)((Object)ecParams));
    }

    private static BigInteger os2i(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException();
        }
        return JseCryptoHelper.os2i(bytes, 0, bytes.length);
    }

    private static BigInteger os2i(byte[] bytes, int offset, int length) {
        if (bytes == null) {
            throw new IllegalArgumentException("El Octet String no puede ser nulo");
        }
        BigInteger result = BigInteger.ZERO;
        BigInteger base = BigInteger.valueOf(256L);
        for (int i = offset; i < offset + length; ++i) {
            result = result.multiply(base);
            result = result.add(BigInteger.valueOf(bytes[i] & 0xFF));
        }
        return result;
    }

    private static BigInteger computeAffineY(BigInteger affineX, ECParameterSpec params) {
        ECCurve bcCurve = JseCryptoHelper.toSpongyCastleECCurve(params);
        ECFieldElement a = bcCurve.getA();
        ECFieldElement b = bcCurve.getB();
        ECFieldElement x = bcCurve.fromBigInteger(affineX);
        ECFieldElement y = x.multiply(x).add(a).multiply(x).add(b).sqrt();
        return y.toBigInteger();
    }

    private static ECCurve toSpongyCastleECCurve(ECParameterSpec params) {
        EllipticCurve curve = params.getCurve();
        ECField field = curve.getField();
        if (!(field instanceof ECFieldFp)) {
            throw new IllegalArgumentException("Solo se soporta 'ECFieldFp' y se proporciono  " + field.getClass().getCanonicalName());
        }
        int coFactor = params.getCofactor();
        BigInteger order = params.getOrder();
        BigInteger a = curve.getA();
        BigInteger b = curve.getB();
        BigInteger p = JseCryptoHelper.getPrime(params);
        return new ECCurve.Fp(p, a, b, order, BigInteger.valueOf(coFactor));
    }

    private static BigInteger getPrime(ECParameterSpec params) {
        if (params == null) {
            throw new IllegalArgumentException("Los parametros no pueden ser nulos");
        }
        EllipticCurve curve = params.getCurve();
        ECField field = curve.getField();
        if (!(field instanceof ECFieldFp)) {
            throw new IllegalStateException("Solo se soporta 'ECFieldFp' y se proporciono  " + field.getClass().getCanonicalName());
        }
        return ((ECFieldFp)field).getP();
    }

    private static ECParameterSpec mapNonceGMWithECDH(BigInteger nonceS, ECPoint sharedSecretPointH, ECParameterSpec params) {
        ECPoint generator = params.getGenerator();
        EllipticCurve curve = params.getCurve();
        BigInteger a = curve.getA();
        BigInteger b = curve.getB();
        ECFieldFp field = (ECFieldFp)curve.getField();
        BigInteger p = field.getP();
        BigInteger order = params.getOrder();
        int cofactor = params.getCofactor();
        ECPoint ephemeralGenerator = JseCryptoHelper.add(JseCryptoHelper.multiply(nonceS, generator, params), sharedSecretPointH, params);
        if (!JseCryptoHelper.toSpongyCastleECPoint(ephemeralGenerator, params).isValid()) {
            LOGGER.warning("Se ha generado un punto invalido");
        }
        return new ECParameterSpec(new EllipticCurve(new ECFieldFp(p), a, b), ephemeralGenerator, order, cofactor);
    }

    private static ECPoint multiply(BigInteger s, ECPoint point, ECParameterSpec params) {
        org.spongycastle.math.ec.ECPoint bcPoint = JseCryptoHelper.toSpongyCastleECPoint(point, params);
        org.spongycastle.math.ec.ECPoint bcProd = bcPoint.multiply(s);
        return JseCryptoHelper.fromSpongyCastleECPoint(bcProd);
    }

    private static ECPoint fromSpongyCastleECPoint(org.spongycastle.math.ec.ECPoint point) {
        org.spongycastle.math.ec.ECPoint newPoint = point.normalize();
        if (!newPoint.isValid()) {
            LOGGER.warning("Se ha proporcionaod un punto invalido");
        }
        return new ECPoint(newPoint.getAffineXCoord().toBigInteger(), newPoint.getAffineYCoord().toBigInteger());
    }

    private static ECPoint add(ECPoint x, ECPoint y, ECParameterSpec params) {
        org.spongycastle.math.ec.ECPoint bcX = JseCryptoHelper.toSpongyCastleECPoint(x, params);
        org.spongycastle.math.ec.ECPoint bcY = JseCryptoHelper.toSpongyCastleECPoint(y, params);
        org.spongycastle.math.ec.ECPoint bcSum = bcX.add(bcY);
        return JseCryptoHelper.fromSpongyCastleECPoint(bcSum);
    }

    private static org.spongycastle.math.ec.ECPoint toSpongyCastleECPoint(ECPoint point, ECParameterSpec params) {
        ECCurve bcCurve = JseCryptoHelper.toSpongyCastleECCurve(params);
        return bcCurve.createPoint(point.getAffineX(), point.getAffineY());
    }
}

