/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.logging.Logger;

public final class HexUtils {
    private static final Logger LOGGER = Logger.getLogger("es.gob.jmulticard");
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private HexUtils() {
    }

    public static boolean arrayEquals(byte[] v, byte[] w) {
        return HexUtils.arrayEquals(v, 0, v.length, w, 0, w.length);
    }

    public static boolean arrayEquals(byte[] v, int vOffset, int vLen, byte[] w, int wOffset, int wLen) {
        if (vLen != wLen || v.length < vOffset + vLen || w.length < wOffset + wLen) {
            return false;
        }
        for (int i = 0; i < vLen; ++i) {
            if (v[i + vOffset] == w[i + wOffset]) continue;
            return false;
        }
        return true;
    }

    public static short getShort(byte[] data, int offset) {
        return (short)HexUtils.getUnsignedInt(data, offset);
    }

    public static int getUnsignedInt(byte[] data, int offset) {
        return (data[offset] & 0xFF) << 8 | data[offset + 1] & 0xFF;
    }

    public static String hexify(byte[] abyte, boolean separator) {
        if (abyte == null) {
            return "null";
        }
        StringBuffer stringbuffer = new StringBuffer(256);
        int i = 0;
        for (byte element : abyte) {
            if (separator && i > 0) {
                stringbuffer.append('-');
            }
            stringbuffer.append(HEX_CHARS[element >> 4 & 0xF]);
            stringbuffer.append(HEX_CHARS[element & 0xF]);
            if (++i != 16) continue;
            if (separator) {
                stringbuffer.append('\n');
            }
            i = 0;
        }
        return stringbuffer.toString();
    }

    public static byte[] subArray(byte[] src, int srcPos, int length) {
        if (length == 0) {
            return null;
        }
        if (src.length < srcPos + length) {
            return null;
        }
        byte[] temp = new byte[length];
        System.arraycopy(src, srcPos, temp, 0, length);
        return temp;
    }

    public static byte[] xor(byte[] v, byte[] w) {
        byte[] xored = null;
        byte[] trimmedXor = null;
        xored = new BigInteger(1, v).xor(new BigInteger(1, w)).toByteArray();
        if (xored.length >= (trimmedXor = new byte[v.length]).length) {
            System.arraycopy(xored, xored.length - trimmedXor.length, trimmedXor, 0, trimmedXor.length);
        } else {
            System.arraycopy(xored, 0, trimmedXor, trimmedXor.length - xored.length, xored.length);
        }
        return trimmedXor;
    }

    public static byte[] intToByteArray(int value) {
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int offset = (b.length - 1 - i) * 8;
            b[3 - i] = (byte)(value >>> offset & 0xFF);
        }
        return b;
    }

    public static byte[] concatenateByteArrays(byte[] ... arrays) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (byte[] array : arrays) {
            try {
                baos.write(array);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error construyendo el campo de datos: " + e, e);
            }
        }
        return baos.toByteArray();
    }

    public static byte[] charArrayToByteArray(char[] in) {
        if (in == null) {
            LOGGER.warning("Se ha pedido convertir un array de caracteres nulo, se devolvera otro vacio de octetos");
            return new byte[0];
        }
        if (in.length < 1) {
            LOGGER.warning("El array de caracteres proporcionado esta vacio, se devolvera otro vacio de octetos");
            return new byte[0];
        }
        byte[] ret = new byte[in.length];
        for (int i = 0; i < in.length; ++i) {
            ret[i] = (byte)in[i];
        }
        return ret;
    }
}

