/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;

public abstract class CryptoHelper {
    private static final int PKCS1_LEN_1024 = 128;
    private static final int PKCS1_LEN_2048 = 256;
    private static final byte PKCS1_BLOCK_TYPE = 1;
    private static final byte PKCS1_FILL = -1;
    private static final byte PKCS1_DELIMIT = 0;

    public static final byte[] addPkcs1PaddingForPrivateKeyOperation(byte[] in, int keySize) throws IOException {
        int len;
        if (in == null) {
            throw new IllegalArgumentException("Los datos de entrada no pueden ser nulos");
        }
        if (keySize != 1024 && keySize != 2048) {
            throw new IllegalArgumentException("Solo se soportan claves de 1024 o 2048 bits, y se ha indicado " + keySize);
        }
        int n = len = keySize == 1024 ? 128 : 256;
        if (in.length > len - 3) {
            throw new IllegalArgumentException("Los datos son demasiado grandes para el valor de clave indicado: " + in.length + " > " + len + "-3");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(len);
        baos.write(0);
        baos.write(1);
        while (baos.size() < len - (1 + in.length)) {
            baos.write(-1);
        }
        baos.write(0);
        baos.write(in);
        return baos.toByteArray();
    }

    public abstract byte[] digest(DigestAlgorithm var1, byte[] var2) throws IOException;

    public abstract byte[] desedeEncrypt(byte[] var1, byte[] var2) throws IOException;

    public abstract byte[] desedeDecrypt(byte[] var1, byte[] var2) throws IOException;

    public abstract byte[] desEncrypt(byte[] var1, byte[] var2) throws IOException;

    public abstract byte[] desDecrypt(byte[] var1, byte[] var2) throws IOException;

    public abstract byte[] aesDecrypt(byte[] var1, byte[] var2, byte[] var3) throws IOException;

    public abstract byte[] aesEncrypt(byte[] var1, byte[] var2, byte[] var3) throws IOException;

    public abstract byte[] rsaDecrypt(byte[] var1, Key var2) throws IOException;

    public abstract byte[] rsaEncrypt(byte[] var1, Key var2) throws IOException;

    public abstract Certificate generateCertificate(byte[] var1) throws CertificateException;

    public abstract byte[] generateRandomBytes(int var1) throws IOException;

    public abstract KeyPair generateEcKeyPair(EcCurve var1) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException;

    public abstract byte[] doAesCmac(byte[] var1, byte[] var2) throws NoSuchAlgorithmException, InvalidKeyException;

    public abstract byte[] doEcDh(Key var1, byte[] var2, EcCurve var3) throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException;

    public abstract AlgorithmParameterSpec getEcPoint(byte[] var1, byte[] var2, EcCurve var3);

    public static enum DigestAlgorithm {
        SHA1("SHA1"),
        SHA256("SHA-256"),
        SHA384("SHA-384"),
        SHA512("SHA-512");

        private final String name;

        private DigestAlgorithm(String n2) {
            this.name = n2;
        }

        public String toString() {
            return this.name;
        }
    }

    protected static enum EcCurve {
        BRAINPOOL_P256_R1("brainpoolp256r1");

        private final String name;

        private EcCurve(String n2) {
            this.name = n2;
        }

        public String toString() {
            return this.name;
        }
    }
}

