/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.ui.core.jse.certificateselection;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.core.ui.AOUIFactory;
import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreManagerFactory;
import es.gob.afirma.keystores.AggregatedKeyStoreManager;
import es.gob.afirma.ui.core.jse.certificateselection.CertificateSelectionDialog;
import es.gob.afirma.ui.core.jse.certificateselection.CertificateSelectionDialogMessages;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.util.Properties;
import java.util.logging.Logger;

final class UtilActions {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String HELP_URI;
    private static final String[] EXTS;
    private static final String EXTS_DESC;

    private UtilActions() {
    }

    static void doHelp() {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(new URI(HELP_URI));
            }
            catch (Exception exception) {
                LOGGER.severe("No se ha podido abrir la pagina Web de ayuda: " + exception);
            }
        } else {
            LOGGER.warning("No se soporta la apertura de paginas Web, por lo que no se puede abrir la ayuda");
        }
    }

    static void doRefresh(CertificateSelectionDialog certificateSelectionDialog, Component component) {
        if (component != null) {
            component.setCursor(new Cursor(3));
        }
        certificateSelectionDialog.refresh();
        if (component != null) {
            component.setCursor(new Cursor(0));
        }
    }

    static void doOpen(CertificateSelectionDialog certificateSelectionDialog, Object object) {
        File[] fileArray;
        try {
            fileArray = AOUIFactory.getLoadFiles(CertificateSelectionDialogMessages.getString("CertificateSelectionDispatcherListener.0"), null, null, EXTS, CertificateSelectionDialogMessages.getString("CertificateSelectionDispatcherListener.1") + EXTS_DESC, false, false, null, object);
        }
        catch (AOCancelledOperationException aOCancelledOperationException) {
            return;
        }
        if (fileArray != null && fileArray.length > 0) {
            AggregatedKeyStoreManager aggregatedKeyStoreManager;
            try {
                aggregatedKeyStoreManager = AOKeyStoreManagerFactory.getAOKeyStoreManager(AOKeyStore.PKCS12, fileArray[0].getAbsolutePath(), null, AOKeyStore.PKCS12.getStorePasswordCallback(object), object);
            }
            catch (Exception exception) {
                LOGGER.warning("No se ha podido cargar el almacen de certificados seleccionado: " + exception);
                AOUIFactory.showErrorMessage(object, CertificateSelectionDialogMessages.getString("CertificateSelectionDispatcherListener.4"), CertificateSelectionDialogMessages.getString("CertificateSelectionDispatcherListener.3"), AOUIFactory.ERROR_MESSAGE);
                return;
            }
            certificateSelectionDialog.changeKeyStore(aggregatedKeyStoreManager);
        }
    }

    static {
        Properties properties = new Properties();
        try {
            properties.load(UtilActions.class.getResourceAsStream("/resources/selectiondialogutil.properties"));
        }
        catch (Exception exception) {
            LOGGER.severe("No se han podido cargar las propiedades del dialogo de seleccion de certificados, se utilizaran los valores por defecto: " + exception);
        }
        HELP_URI = properties.getProperty("helpUrl", "http://incidencias-ctt.administracionelectronica.gob.es/wiki/doku.php?id=forja-ctt_wiki:clienteafirma:adenda_-_uso_del_dialogo_grafico_de_seleccion_de_certificados");
        if (Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
            EXTS = new String[]{"pfx", "p12", "jks", "dylib", "so"};
            EXTS_DESC = " (*.p12, *.pfx, *.jks, *.dylib, *.so)";
        } else if (Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
            EXTS = new String[]{"pfx", "p12", "jks", "dll"};
            EXTS_DESC = " (*.p12, *.pfx, *.jks, *.dll)";
        } else {
            EXTS = new String[]{"pfx", "p12", "jks", "so"};
            EXTS_DESC = " (*.p12, *.pfx, *.jks, *.so)";
        }
    }
}

