/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.ui.core.jse.certificateselection;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.core.ui.AOUIFactory;
import es.gob.afirma.core.ui.GenericFileFilter;
import es.gob.afirma.ui.core.jse.JSEUIManager;
import es.gob.afirma.ui.core.jse.certificateselection.CertificateSelectionDialogMessages;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.logging.Logger;

final class CertificateUtils {
    private static final String CERTIFICATE_DEFAULT_EXTENSION = ".cer";

    private CertificateUtils() {
    }

    static void openCert(Component component, X509Certificate x509Certificate) {
        Class<?> clazz;
        try {
            clazz = Class.forName("java.awt.Desktop");
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        if (clazz != null) {
            try {
                File file = CertificateUtils.saveTemp(x509Certificate.getEncoded(), CERTIFICATE_DEFAULT_EXTENSION);
                Method method = clazz.getDeclaredMethod("getDesktop", null);
                Object object = method.invoke(null, (Object[])null);
                Method method2 = clazz.getDeclaredMethod("open", File.class);
                method2.invoke(object, file);
                return;
            }
            catch (Exception exception) {
                Logger.getLogger("es.gob.afirma").warning("No ha sido posible abrir el certificado: " + exception);
            }
        }
        if (Platform.getOS() == Platform.OS.WINDOWS) {
            try {
                File file = CertificateUtils.saveTemp(x509Certificate.getEncoded(), CERTIFICATE_DEFAULT_EXTENSION);
                new ProcessBuilder("cmd", "/C", "start", "\"" + CertificateSelectionDialogMessages.getString("CertificateUtils.0") + "\"", "\"" + file.getAbsolutePath() + "\"").start();
                return;
            }
            catch (Exception exception) {
                Logger.getLogger("es.gob.afirma").warning("No ha sido posible abrir el certificado: " + exception);
            }
        }
        try {
            AOUIFactory.getSaveDataToFile(x509Certificate.getEncoded(), CertificateSelectionDialogMessages.getString("CertificateUtils.1"), null, CertificateSelectionDialogMessages.getString("CertificateUtils.5") + CERTIFICATE_DEFAULT_EXTENSION, Collections.singletonList(new GenericFileFilter(new String[]{CERTIFICATE_DEFAULT_EXTENSION}, CertificateSelectionDialogMessages.getString("CertificateUtils.3"))), component);
        }
        catch (IOException iOException) {
            new JSEUIManager().showConfirmDialog(component, CertificateSelectionDialogMessages.getString("CertificateUtils.2"), CertificateSelectionDialogMessages.getString("CertificateUtils.3"), -1, 0);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            new JSEUIManager().showConfirmDialog(component, CertificateSelectionDialogMessages.getString("CertificateUtils.4"), CertificateSelectionDialogMessages.getString("CertificateUtils.3"), -1, 0);
        }
        catch (AOCancelledOperationException aOCancelledOperationException) {
            // empty catch block
        }
    }

    private static boolean saveFile(File file, byte[] byArray) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            ((OutputStream)fileOutputStream).write(byArray);
        }
        return true;
    }

    private static File saveTemp(byte[] byArray, String string) throws IOException {
        File file = File.createTempFile("afirma", string);
        file.deleteOnExit();
        if (CertificateUtils.saveFile(file, byArray)) {
            return file;
        }
        return null;
    }
}

