/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.ui.core.jse.certificateselection;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.keystores.KeyUsage;
import es.gob.afirma.core.keystores.NameCertificateBean;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.ui.core.jse.certificateselection.CertificateIconManager;
import es.gob.afirma.ui.core.jse.certificateselection.CertificateSelectionDialog;
import es.gob.afirma.ui.core.jse.certificateselection.CertificateSelectionDialogMessages;
import es.gob.afirma.ui.core.jse.certificateselection.CertificateUtils;
import es.gob.afirma.ui.core.jse.certificateselection.UtilActions;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

final class CertificateSelectionPanel
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 6288294705582545804L;
    private static final String VERDANA_FONT_NAME = "Verdana";
    private static final int TITLE_FONT_SIZE = 14;
    private static final int TEXT_FONT_SIZE = 12;
    private static final Font TITLE_FONT = new Font("Verdana", 1, 14);
    private static final Font TEXT_FONT = new Font("Verdana", 0, 12);
    private static final int CERT_LIST_ELEMENT_HEIGHT = 86;
    private JList<CertificateLine> certList;
    JScrollPane sPane;
    private JPanel certListPanel;
    private JPanel textMessagePanel;
    private int selectedIndex = -1;
    private NameCertificateBean[] certificateBeans;
    private final String dialogSubHeadline;

    CertificateSelectionPanel(NameCertificateBean[] nameCertificateBeanArray, CertificateSelectionDialog certificateSelectionDialog, String string, String string2, boolean bl, boolean bl2) {
        this.certificateBeans = nameCertificateBeanArray == null ? new NameCertificateBean[]{} : (NameCertificateBean[])nameCertificateBeanArray.clone();
        this.dialogSubHeadline = string2;
        this.createUI(certificateSelectionDialog, string, bl, bl2);
    }

    private void createUI(final CertificateSelectionDialog certificateSelectionDialog, String string, boolean bl, boolean bl2) {
        Object object;
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(13, 15, 8, 15);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        JLabel jLabel = new JLabel(string != null ? string : CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.0"));
        jLabel.setFont(TITLE_FONT);
        jLabel.setForeground(Color.decode("0x0033BC"));
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(13, 0, 8, 5);
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridx;
        if (bl) {
            JButton jButton;
            object = new JButton(new ImageIcon(CertificateSelectionPanel.class.getResource("/resources/toolbar/ic_autorenew_black_18dp.png"), CertificateSelectionDialogMessages.getString("UtilToolBar.1")));
            ((JComponent)object).setBorder(BorderFactory.createEmptyBorder());
            ((Component)object).setCursor(Cursor.getPredefinedCursor(12));
            ((JButton)object).getAccessibleContext().setAccessibleDescription(CertificateSelectionDialogMessages.getString("UtilToolBar.1"));
            ((JComponent)object).setToolTipText(CertificateSelectionDialogMessages.getString("UtilToolBar.1"));
            ((AbstractButton)object).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UtilActions.doRefresh(certificateSelectionDialog, CertificateSelectionPanel.this);
                }
            });
            ((JComponent)object).setBackground(Color.WHITE);
            this.add((Component)object, gridBagConstraints);
            ++gridBagConstraints.gridx;
            if (bl2) {
                jButton = new JButton(new ImageIcon(CertificateSelectionPanel.class.getResource("/resources/toolbar/ic_open_in_browser_black_18dp.png"), CertificateSelectionDialogMessages.getString("UtilToolBar.2")));
                jButton.setBorder(BorderFactory.createEmptyBorder());
                jButton.setCursor(Cursor.getPredefinedCursor(12));
                jButton.getAccessibleContext().setAccessibleDescription(CertificateSelectionDialogMessages.getString("UtilToolBar.2"));
                jButton.setToolTipText(CertificateSelectionDialogMessages.getString("UtilToolBar.2"));
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        UtilActions.doOpen(certificateSelectionDialog, CertificateSelectionPanel.this);
                    }
                });
                jButton.setBackground(Color.WHITE);
                this.add((Component)jButton, gridBagConstraints);
            }
            gridBagConstraints.insets = new Insets(13, 0, 8, 15);
            ++gridBagConstraints.gridx;
            jButton = new JButton(new ImageIcon(CertificateSelectionPanel.class.getResource("/resources/toolbar/ic_help_black_18dp.png"), CertificateSelectionDialogMessages.getString("UtilToolBar.3")));
            jButton.setBorder(BorderFactory.createEmptyBorder());
            jButton.setCursor(Cursor.getPredefinedCursor(12));
            jButton.getAccessibleContext().setAccessibleDescription(CertificateSelectionDialogMessages.getString("UtilToolBar.3"));
            jButton.setToolTipText(CertificateSelectionDialogMessages.getString("UtilToolBar.3"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UtilActions.doHelp();
                }
            });
            jButton.setBackground(Color.WHITE);
            this.add((Component)jButton, gridBagConstraints);
        }
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = new Insets(0, 15, 4, 15);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.textMessagePanel = new JPanel();
        this.textMessagePanel.setLayout(new GridBagLayout());
        this.textMessagePanel.setOpaque(false);
        this.textMessagePanel.setBorder(null);
        this.add((Component)this.textMessagePanel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(4, 15, 8, 15);
        ++gridBagConstraints.gridy;
        this.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.insets = new Insets(8, 18, 13, 18);
        gridBagConstraints.weighty = 1.0;
        ++gridBagConstraints.gridy;
        this.certListPanel = new JPanel();
        this.certListPanel.setLayout(new GridBagLayout());
        this.certListPanel.setBorder(null);
        this.certList = new JList();
        this.certList.setCellRenderer(new CertListCellRendered());
        this.updateCertListInfo(this.certificateBeans);
        this.certList.addListSelectionListener(this);
        object = new CertLinkMouseListener();
        this.certList.addMouseMotionListener((MouseMotionListener)object);
        this.certList.addMouseListener((MouseListener)object);
        this.add((Component)this.certListPanel, gridBagConstraints);
    }

    void refresh(NameCertificateBean[] nameCertificateBeanArray) {
        this.certificateBeans = (NameCertificateBean[])nameCertificateBeanArray.clone();
        this.updateCertListInfo(nameCertificateBeanArray);
        if (nameCertificateBeanArray.length > 0) {
            this.certList.setSelectedIndex(0);
            this.sPane.getVerticalScrollBar().setValue(0);
        }
    }

    private static List<CertificateLine> createCertLines(NameCertificateBean[] nameCertificateBeanArray) {
        ArrayList<CertificateLine> arrayList = new ArrayList<CertificateLine>();
        for (NameCertificateBean nameCertificateBean : nameCertificateBeanArray) {
            CertificateLine certificateLine;
            try {
                certificateLine = CertificateSelectionPanel.createCertLine(nameCertificateBean.getName(), nameCertificateBean.getCertificate());
            }
            catch (Exception exception) {
                continue;
            }
            certificateLine.setPreferredSize(new Dimension(0, 86));
            arrayList.add(certificateLine);
        }
        return arrayList;
    }

    private void updateCertListInfo(NameCertificateBean[] nameCertificateBeanArray) {
        GridBagConstraints gridBagConstraints;
        Object object;
        List<CertificateLine> list = CertificateSelectionPanel.createCertLines(nameCertificateBeanArray);
        this.textMessagePanel.removeAll();
        if (list.size() <= 1) {
            object = list.size() == 1 ? (this.dialogSubHeadline != null ? this.dialogSubHeadline : CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.1")) : CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.8");
            JTextPane jTextPane = new JTextPane();
            jTextPane.setOpaque(false);
            jTextPane.setText((String)object);
            jTextPane.setFont(TEXT_FONT);
            jTextPane.setBorder(null);
            jTextPane.setPreferredSize(new Dimension(370, 40));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.textMessagePanel.add((Component)jTextPane, gridBagConstraints);
        }
        this.certList.setListData((CertificateLine[])list.toArray(new CertificateLine[list.size()]));
        this.certList.setVisibleRowCount(Math.max(Math.min(4, list.size()), 1));
        if (list.size() > 0) {
            this.certList.setSelectedIndex(0);
            this.selectedIndex = 0;
        } else {
            this.selectedIndex = -1;
        }
        object = new JScrollPane(this.certList, 20, 31);
        ((JComponent)object).setBorder(null);
        int n = 86 * this.certList.getVisibleRowCount() + 3;
        ((JComponent)object).setPreferredSize(new Dimension(500, n));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        if (this.sPane != null) {
            this.certListPanel.remove(this.sPane);
        }
        this.sPane = object;
        this.certListPanel.add((Component)this.sPane, gridBagConstraints);
    }

    void selectCertificateList() {
        this.certList.requestFocusInWindow();
    }

    String getSelectedCertificateAlias() {
        return this.selectedIndex == -1 ? null : this.certificateBeans[this.selectedIndex].getAlias();
    }

    int getShowedCertsCount() {
        return this.certificateBeans == null ? 0 : this.certificateBeans.length;
    }

    void addCertificateListMouseListener(MouseListener mouseListener) {
        this.certList.addMouseListener(mouseListener);
    }

    private static CertificateLine createCertLine(String string, X509Certificate x509Certificate) {
        CertificateLine certificateLine = new CertificateLine(string, x509Certificate);
        certificateLine.setFocusable(true);
        return certificateLine;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.selectedIndex = this.certList.getSelectedIndex();
    }

    private final class CertLinkMouseListener
    extends MouseAdapter {
        private boolean entered = false;

        CertLinkMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JList jList = (JList)mouseEvent.getSource();
            CertificateLine certificateLine = (CertificateLine)jList.getSelectedValue();
            if (certificateLine != null && mouseEvent.getClickCount() == 1 && mouseEvent.getY() < 86 * jList.getModel().getSize() && certificateLine.getCertificateLinkBounds().contains(mouseEvent.getX(), mouseEvent.getY() % 86)) {
                try {
                    CertificateUtils.openCert(CertificateSelectionPanel.this, certificateLine.getCertificate());
                }
                catch (AOCancelledOperationException aOCancelledOperationException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JList jList = (JList)mouseEvent.getSource();
            CertificateLine certificateLine = (CertificateLine)jList.getSelectedValue();
            if (certificateLine != null) {
                if (mouseEvent.getY() < 86 * jList.getModel().getSize() && certificateLine.getCertificateLinkBounds().contains(mouseEvent.getX(), mouseEvent.getY() % 86)) {
                    if (!this.entered) {
                        jList.setCursor(Cursor.getPredefinedCursor(12));
                        this.entered = true;
                    }
                } else if (this.entered) {
                    jList.setCursor(Cursor.getPredefinedCursor(0));
                    this.entered = false;
                }
            }
        }
    }

    private static final class CertListCellRendered
    implements ListCellRenderer<CertificateLine> {
        CertListCellRendered() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends CertificateLine> jList, CertificateLine certificateLine, int n, boolean bl, boolean bl2) {
            CertificateLine certificateLine2 = certificateLine;
            if (bl) {
                certificateLine2.setBackground(Color.decode("0xD9EAFF"));
                certificateLine2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.WHITE, 1), BorderFactory.createLineBorder(Color.decode("0x84ACDD"), 1)));
            } else {
                certificateLine2.setBackground(Color.WHITE);
                certificateLine2.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 4));
            }
            return certificateLine2;
        }
    }

    private static final class CertificateLine
    extends JPanel {
        private static final long serialVersionUID = 5012625058876812352L;
        private static final Font SUBJECT_FONT = new Font("Verdana", 1, 14);
        private static final Font DETAILS_FONT = new Font("Verdana", 0, 11);
        private static final long EXPIRITY_WARNING_LEVEL = 630000000L;
        private JLabel propertiesLink = null;
        private final String friendlyName;
        private final X509Certificate cert;

        private static ImageIcon getIcon(X509Certificate x509Certificate) {
            long l = x509Certificate.getNotAfter().getTime();
            long l2 = new Date().getTime();
            if (l2 >= l || l2 <= x509Certificate.getNotBefore().getTime()) {
                return CertificateIconManager.getExpiredIcon(x509Certificate);
            }
            if (l - l2 < 630000000L) {
                return CertificateIconManager.getWarningIcon(x509Certificate);
            }
            return CertificateIconManager.getNormalIcon(x509Certificate);
        }

        CertificateLine(String string, X509Certificate x509Certificate) {
            this.friendlyName = string;
            this.cert = x509Certificate;
            this.createUI();
        }

        X509Certificate getCertificate() {
            return this.cert;
        }

        @Override
        public String toString() {
            return this.friendlyName;
        }

        private void createUI() {
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.WHITE);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridheight = 4;
            ImageIcon imageIcon = CertificateLine.getIcon(this.cert);
            JLabel jLabel = new JLabel(imageIcon);
            this.setToolTipText(imageIcon.getDescription());
            gridBagConstraints.insets = new Insets(2, 2, 2, 5);
            this.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            ++gridBagConstraints.gridx;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            JLabel jLabel2 = new JLabel(this.friendlyName);
            jLabel2.setFont(SUBJECT_FONT);
            this.add((Component)jLabel2, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            JLabel jLabel3 = new JLabel(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.2") + " " + AOUtil.getCN(this.cert.getIssuerDN().toString()) + ". " + CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.6") + " " + new KeyUsage(this.cert).toString());
            jLabel3.setFont(DETAILS_FONT);
            this.add((Component)jLabel3, gridBagConstraints);
            ++gridBagConstraints.gridy;
            JLabel jLabel4 = new JLabel(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.3", new String[]{CertificateLine.formatDate(this.cert.getNotBefore()), CertificateLine.formatDate(this.cert.getNotAfter())}));
            jLabel4.setFont(DETAILS_FONT);
            this.add((Component)jLabel4, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.propertiesLink = new JLabel("<html><u>" + CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.5") + "</u></html>");
            if (!Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
                this.propertiesLink.setFont(DETAILS_FONT);
                this.add((Component)this.propertiesLink, gridBagConstraints);
            }
        }

        private static String formatDate(Date date) {
            return new SimpleDateFormat("dd/MM/yyyy").format(date);
        }

        Rectangle getCertificateLinkBounds() {
            return this.propertiesLink.getBounds();
        }
    }
}

