/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.ui.core.jse.certificateselection;

import es.gob.afirma.core.keystores.KeyStoreManager;
import es.gob.afirma.core.keystores.NameCertificateBean;
import es.gob.afirma.core.ui.KeyStoreDialogManager;
import es.gob.afirma.keystores.AOCertificatesNotFoundException;
import es.gob.afirma.ui.core.jse.certificateselection.CertificateSelectionDialogMessages;
import es.gob.afirma.ui.core.jse.certificateselection.CertificateSelectionDispatcherListener;
import es.gob.afirma.ui.core.jse.certificateselection.CertificateSelectionPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public final class CertificateSelectionDialog
extends MouseAdapter {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private final CertificateSelectionPanel csd;
    private final JOptionPane optionPane;
    private final Component parent;
    private final KeyStoreDialogManager ksdm;
    private final boolean disableSelection;
    JDialog certDialog = null;
    private static final Comparator<NameCertificateBean> CERT_NAME_COMPARATOR = new Comparator<NameCertificateBean>(){

        @Override
        public int compare(NameCertificateBean nameCertificateBean, NameCertificateBean nameCertificateBean2) {
            if (nameCertificateBean == null && nameCertificateBean2 == null) {
                return 0;
            }
            if (nameCertificateBean == null) {
                return 1;
            }
            if (nameCertificateBean2 == null) {
                return -1;
            }
            return nameCertificateBean.getName().compareToIgnoreCase(nameCertificateBean2.getName());
        }
    };

    public CertificateSelectionDialog(Component component, KeyStoreDialogManager keyStoreDialogManager) {
        this(component, keyStoreDialogManager, null, null, true, false);
    }

    public CertificateSelectionDialog(Component component, KeyStoreDialogManager keyStoreDialogManager, String string, String string2, boolean bl, boolean bl2) {
        this.parent = component;
        this.ksdm = keyStoreDialogManager;
        NameCertificateBean[] nameCertificateBeanArray = this.ksdm.getNameCertificates();
        Arrays.sort(nameCertificateBeanArray, CERT_NAME_COMPARATOR);
        this.csd = new CertificateSelectionPanel(nameCertificateBeanArray, this, string, string2, bl, keyStoreDialogManager.isExternalStoresOpeningAllowed());
        this.optionPane = nameCertificateBeanArray.length > 1 ? new CertOptionPane(this.csd) : new JOptionPane();
        this.csd.addCertificateListMouseListener(this);
        this.optionPane.setMessage(this.csd);
        this.optionPane.setMessageType(-1);
        this.optionPane.setOptionType(bl2 ? -1 : 2);
        this.disableSelection = bl2;
    }

    public String showDialog() throws AOCertificatesNotFoundException {
        this.certDialog = this.optionPane.createDialog(this.parent, CertificateSelectionDialogMessages.getString("CertificateSelectionDialog.0"));
        this.certDialog.setBackground(Color.WHITE);
        this.certDialog.setModal(true);
        this.certDialog.setAlwaysOnTop(true);
        CertificateSelectionDispatcherListener certificateSelectionDispatcherListener = new CertificateSelectionDispatcherListener(this.optionPane, this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(certificateSelectionDispatcherListener);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit != null) {
            int n = (int)toolkit.getScreenSize().getHeight();
            if (this.certDialog.getSize().getHeight() > (double)n) {
                this.certDialog.setSize(new Dimension((int)this.certDialog.getSize().getWidth(), n));
            }
        }
        this.certDialog.setVisible(true);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(certificateSelectionDispatcherListener);
        if (this.csd.getShowedCertsCount() == 0) {
            throw new AOCertificatesNotFoundException("No habia certificados validos en el almacen del usuario");
        }
        if (this.optionPane.getValue() == null || (Integer)this.optionPane.getValue() != 0) {
            this.certDialog.dispose();
            return null;
        }
        String string = this.csd.getSelectedCertificateAlias();
        this.certDialog.dispose();
        this.certDialog = null;
        return string;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && this.optionPane != null && !this.disableSelection) {
            this.optionPane.setValue(0);
        }
    }

    public void refresh() {
        this.certDialog.setAlwaysOnTop(false);
        try {
            this.ksdm.refresh();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Error en la orden de actualizacion del almacen: " + exception, exception);
            return;
        }
        this.refreshDialog();
    }

    private void refreshDialog() {
        NameCertificateBean[] nameCertificateBeanArray = this.ksdm.getNameCertificates();
        Arrays.sort(nameCertificateBeanArray, CERT_NAME_COMPARATOR);
        try {
            this.csd.refresh(nameCertificateBeanArray);
        }
        catch (Exception exception) {
            LOGGER.warning("No se pudo actualizar el dialogo de seleccion: " + exception);
        }
        this.certDialog.pack();
    }

    public void changeKeyStore(KeyStoreManager keyStoreManager) {
        this.ksdm.setKeyStoreManager(keyStoreManager);
        this.refreshDialog();
    }

    private static final class CertOptionPane
    extends JOptionPane {
        private static final long serialVersionUID = 1L;
        private final CertificateSelectionPanel selectionPanel;

        CertOptionPane(CertificateSelectionPanel certificateSelectionPanel) {
            this.selectionPanel = certificateSelectionPanel;
        }

        @Override
        public void selectInitialValue() {
            this.selectionPanel.selectCertificateList();
        }
    }
}

