/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.ui.core.jse.certificateselection;

import es.gob.afirma.ui.core.jse.certificateselection.CertificateSelectionDialogMessages;
import es.gob.afirma.ui.core.jse.certificateselection.CertificateSelectionPanel;
import java.security.cert.X509Certificate;
import javax.swing.ImageIcon;

final class CertificateIconManager {
    private static final ImageIcon ICON_ACCV_NORMAL = new ImageIcon(CertificateSelectionPanel.class.getClassLoader().getResource("resources/accvicon.png"));
    private static final ImageIcon ICON_ACCV_WARNING = new ImageIcon(CertificateSelectionPanel.class.getClassLoader().getResource("resources/accvicon_w.png"));
    private static final ImageIcon ICON_ACCV_ERROR = new ImageIcon(CertificateSelectionPanel.class.getClassLoader().getResource("resources/accvicon_e.png"));
    private static final ImageIcon ICON_CNP_NORMAL = new ImageIcon(CertificateSelectionPanel.class.getClassLoader().getResource("resources/cnpicon.png"));
    private static final ImageIcon ICON_CNP_WARNING = new ImageIcon(CertificateSelectionPanel.class.getClassLoader().getResource("resources/cnpicon_w.png"));
    private static final ImageIcon ICON_CNP_ERROR = new ImageIcon(CertificateSelectionPanel.class.getClassLoader().getResource("resources/cnpicon_e.png"));
    private static final ImageIcon ICON_DNIE_NORMAL = new ImageIcon(CertificateSelectionPanel.class.getClassLoader().getResource("resources/dnieicon.png"));
    private static final ImageIcon ICON_DNIE_WARNING = new ImageIcon(CertificateSelectionPanel.class.getClassLoader().getResource("resources/dnieicon_w.png"));
    private static final ImageIcon ICON_DNIE_ERROR = new ImageIcon(CertificateSelectionPanel.class.getClassLoader().getResource("resources/dnieicon_e.png"));
    private static final ImageIcon ICON_OTHER_NORMAL = new ImageIcon(CertificateSelectionPanel.class.getClassLoader().getResource("resources/certicon.png"));
    private static final ImageIcon ICON_OTHER_WARNING = new ImageIcon(CertificateSelectionPanel.class.getClassLoader().getResource("resources/certicon_w.png"));
    private static final ImageIcon ICON_OTHER_ERROR = new ImageIcon(CertificateSelectionPanel.class.getClassLoader().getResource("resources/certicon_e.png"));
    private static final ImageIcon ICON_FNMT_NORMAL = new ImageIcon(CertificateSelectionPanel.class.getClassLoader().getResource("resources/fnmticon.png"));
    private static final ImageIcon ICON_FNMT_WARNING = new ImageIcon(CertificateSelectionPanel.class.getClassLoader().getResource("resources/fnmticon_w.png"));
    private static final ImageIcon ICON_FNMT_ERROR = new ImageIcon(CertificateSelectionPanel.class.getClassLoader().getResource("resources/fnmticon_e.png"));

    CertificateIconManager() {
    }

    private static boolean isAccvCert(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return false;
        }
        String string = x509Certificate.getIssuerX500Principal().toString().toUpperCase();
        return string.contains("O=Generalitat Valenciana") && string.contains("OU=PKIGVA");
    }

    private static boolean isDNIeCert(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return false;
        }
        String string = x509Certificate.getIssuerX500Principal().toString().toUpperCase();
        return string.contains("O=DIRECCION GENERAL DE LA POLICIA") && string.contains("OU=DNIE");
    }

    private static boolean isCnpCert(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return false;
        }
        String string = x509Certificate.getIssuerX500Principal().toString().toUpperCase();
        return string.contains("O=DIRECCION GENERAL DE LA POLICIA") && string.contains("OU=CNP");
    }

    private static boolean isFnmtCert(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return false;
        }
        String string = x509Certificate.getIssuerX500Principal().toString().toUpperCase();
        return string.contains("O=FNMT");
    }

    static ImageIcon getNormalIcon(X509Certificate x509Certificate) {
        if (CertificateIconManager.isAccvCert(x509Certificate)) {
            return ICON_ACCV_NORMAL;
        }
        if (CertificateIconManager.isDNIeCert(x509Certificate)) {
            return ICON_DNIE_NORMAL;
        }
        if (CertificateIconManager.isCnpCert(x509Certificate)) {
            return ICON_CNP_NORMAL;
        }
        if (CertificateIconManager.isFnmtCert(x509Certificate)) {
            return ICON_FNMT_NORMAL;
        }
        return ICON_OTHER_NORMAL;
    }

    static ImageIcon getWarningIcon(X509Certificate x509Certificate) {
        if (CertificateIconManager.isAccvCert(x509Certificate)) {
            return ICON_ACCV_WARNING;
        }
        if (CertificateIconManager.isDNIeCert(x509Certificate)) {
            return ICON_DNIE_WARNING;
        }
        if (CertificateIconManager.isCnpCert(x509Certificate)) {
            return ICON_CNP_WARNING;
        }
        if (CertificateIconManager.isFnmtCert(x509Certificate)) {
            return ICON_FNMT_WARNING;
        }
        return ICON_OTHER_WARNING;
    }

    static ImageIcon getExpiredIcon(X509Certificate x509Certificate) {
        if (CertificateIconManager.isAccvCert(x509Certificate)) {
            return ICON_ACCV_ERROR;
        }
        if (CertificateIconManager.isDNIeCert(x509Certificate)) {
            return ICON_DNIE_ERROR;
        }
        if (CertificateIconManager.isCnpCert(x509Certificate)) {
            return ICON_CNP_ERROR;
        }
        if (CertificateIconManager.isFnmtCert(x509Certificate)) {
            return ICON_FNMT_ERROR;
        }
        return ICON_OTHER_ERROR;
    }

    static {
        ICON_ACCV_NORMAL.setDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.22"));
        ICON_ACCV_NORMAL.getAccessibleContext().setAccessibleDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.22"));
        ICON_ACCV_WARNING.setDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.23"));
        ICON_ACCV_WARNING.getAccessibleContext().setAccessibleDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.23"));
        ICON_ACCV_ERROR.setDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.24"));
        ICON_ACCV_ERROR.getAccessibleContext().setAccessibleDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.24"));
        ICON_DNIE_NORMAL.setDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.4"));
        ICON_DNIE_NORMAL.getAccessibleContext().setAccessibleDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.4"));
        ICON_DNIE_WARNING.setDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.7"));
        ICON_DNIE_WARNING.getAccessibleContext().setAccessibleDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.7"));
        ICON_DNIE_ERROR.setDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.9"));
        ICON_DNIE_ERROR.getAccessibleContext().setAccessibleDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.9"));
        ICON_CNP_NORMAL.setDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.16"));
        ICON_CNP_NORMAL.getAccessibleContext().setAccessibleDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.16"));
        ICON_CNP_WARNING.setDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.17"));
        ICON_CNP_WARNING.getAccessibleContext().setAccessibleDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.17"));
        ICON_CNP_ERROR.setDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.18"));
        ICON_CNP_ERROR.getAccessibleContext().setAccessibleDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.18"));
        ICON_OTHER_NORMAL.setDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.11"));
        ICON_OTHER_NORMAL.getAccessibleContext().setAccessibleDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.11"));
        ICON_OTHER_WARNING.setDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.13"));
        ICON_OTHER_WARNING.getAccessibleContext().setAccessibleDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.13"));
        ICON_OTHER_ERROR.setDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.15"));
        ICON_OTHER_ERROR.getAccessibleContext().setAccessibleDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.15"));
        ICON_FNMT_NORMAL.setDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.19"));
        ICON_FNMT_NORMAL.getAccessibleContext().setAccessibleDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.19"));
        ICON_FNMT_WARNING.setDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.20"));
        ICON_FNMT_WARNING.getAccessibleContext().setAccessibleDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.20"));
        ICON_FNMT_ERROR.setDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.21"));
        ICON_FNMT_ERROR.getAccessibleContext().setAccessibleDescription(CertificateSelectionDialogMessages.getString("CertificateSelectionPanel.21"));
    }
}

