/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.ui.core.jse;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.core.ui.GenericFileFilter;
import es.gob.afirma.ui.core.jse.JSEUIManager;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class AWTUIManager
extends JSEUIManager {
    @Override
    public File saveDataToFile(byte[] byArray, String string, String string2, String string3, List<GenericFileFilter> list, Object object) throws IOException {
        Object object2;
        Object object3;
        String[] stringArray;
        FileDialog fileDialog = object instanceof Frame ? new FileDialog((Frame)object, string, 1) : (object instanceof Dialog ? new FileDialog((Dialog)object, string, 1) : new FileDialog((Frame)null, string, 1));
        if (string3 != null && string2 != null && Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
            fileDialog.setFile(new File(string2, string3).getAbsolutePath());
        } else {
            if (string3 != null) {
                fileDialog.setFile(string3);
            }
            if (string2 == null) {
                fileDialog.setDirectory(AWTUIManager.get("currentDir", string2));
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            stringArray = list.iterator();
            while (stringArray.hasNext()) {
                object3 = (GenericFileFilter)stringArray.next();
                object2 = ((GenericFileFilter)object3).getExtensions();
                if (object2 == null) continue;
                arrayList.addAll(Arrays.asList(object2));
            }
        }
        if ((stringArray = arrayList.toArray(new String[arrayList.size()])) != null) {
            fileDialog.setFilenameFilter(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    for (String string2 : stringArray) {
                        if (!string.endsWith(string2)) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
        fileDialog.setVisible(true);
        if (fileDialog.getFile() == null) {
            throw new AOCancelledOperationException();
        }
        object3 = new File(fileDialog.getDirectory() + fileDialog.getFile());
        if (byArray != null) {
            object2 = new FileOutputStream((File)object3);
            Throwable throwable = null;
            try {
                ((OutputStream)object2).write(byArray);
                ((OutputStream)object2).flush();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object2 != null) {
                    if (throwable != null) {
                        try {
                            ((OutputStream)object2).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((OutputStream)object2).close();
                    }
                }
            }
        }
        return object3;
    }

    @Override
    public File[] getLoadFiles(String string, String string2, String string3, final String[] stringArray, String string4, boolean bl, boolean bl2, Object object, Object object2) {
        Object object3;
        FileDialog fileDialog = new FileDialog(object2 instanceof Frame ? (Frame)object2 : null, string);
        fileDialog.setMode(0);
        if (string2 == null) {
            fileDialog.setDirectory(AWTUIManager.get("currentDir", string2));
        }
        if (bl2) {
            try {
                object3 = FileDialog.class.getMethod("setMultipleMode", Boolean.TYPE);
                object3.invoke((Object)fileDialog, bl2);
            }
            catch (Exception exception) {
                LOGGER.warning("No es posible utilizar la seleccion multiple de ficheros con los dialogos del sistema con versiones anteriores de Java 7, se utilizara Swing: " + exception);
                return super.getLoadFiles(string, string2, string3, stringArray, string4, bl, bl2, object, object2);
            }
        }
        if (string3 != null) {
            fileDialog.setFile(string3);
        }
        if (stringArray != null && stringArray.length > 0) {
            if (Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
                object3 = stringArray[0];
                if (!object3.startsWith("*.")) {
                    object3 = object3.startsWith(".") ? "*" + (String)object3 : "*." + (String)object3;
                }
                fileDialog.setFile((String)object3);
            } else {
                fileDialog.setFilenameFilter(new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        for (String string2 : stringArray) {
                            if (!string.endsWith(string2)) continue;
                            return true;
                        }
                        return false;
                    }
                });
            }
        }
        if (bl) {
            fileDialog.setFile("*.");
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
        }
        fileDialog.setVisible(true);
        if (fileDialog.getFile() == null) {
            throw new AOCancelledOperationException();
        }
        if (bl2 && AWTUIManager.isJava7()) {
            try {
                Method method = FileDialog.class.getMethod("getFiles", new Class[0]);
                object3 = (File[])method.invoke((Object)fileDialog, new Object[0]);
            }
            catch (Exception exception) {
                LOGGER.warning("Error de reflexion al recuperar la seleccion multiple del dialogo de carga, se devolvera un unico fichero: " + exception);
                object3 = new File[]{new File(fileDialog.getFile())};
            }
            if (object3 == null) {
                object3 = new File[]{};
            }
            return object3;
        }
        object3 = new File(fileDialog.getDirectory(), fileDialog.getFile());
        System.setProperty("apple.awt.fileDialogForDirectories", "false");
        AWTUIManager.put("currentDir", fileDialog.getDirectory());
        return new File[]{object3};
    }

    private static boolean isJava7() {
        return System.getProperty("java.version").startsWith("1.7");
    }
}

