/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xmldsig;

import es.gob.afirma.signers.xml.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import org.w3c.dom.Element;

final class XmlDSigUtil {
    private XmlDSigUtil() {
    }

    static List<Reference> cleanReferencesList(List<Reference> list) {
        ArrayList<Reference> arrayList = new ArrayList<Reference>();
        if (list == null) {
            return arrayList;
        }
        for (Reference reference : list) {
            if (reference.getId() == null) {
                ArrayList<Transform> arrayList2 = null;
                boolean bl = false;
                for (Transform transform : reference.getTransforms()) {
                    if (!(transform instanceof Transform)) continue;
                    if (!"http://www.w3.org/2000/09/xmldsig#base64".equals(transform.getAlgorithm())) {
                        if (arrayList2 == null) {
                            arrayList2 = new ArrayList<Transform>();
                        }
                        arrayList2.add(transform);
                        continue;
                    }
                    bl = true;
                }
                if (bl) {
                    arrayList.add(Utils.getDOMFactory().newReference(reference.getURI(), reference.getDigestMethod(), arrayList2, reference.getType(), reference.getId()));
                    continue;
                }
                arrayList.add(reference);
                continue;
            }
            arrayList.add(reference);
        }
        return arrayList;
    }

    static String guessXmlDSigNamespacePrefix(Element element) {
        String string = new String(Utils.writeXML(element, null, null, null));
        int n = Utils.countSubstring(string, "<Signature");
        int n2 = Utils.countSubstring(string, "<ds:Signature");
        int n3 = Utils.countSubstring(string, "<dsig:Signature");
        int n4 = Utils.countSubstring(string, "<dsig11:Signature");
        if (n2 >= n && n2 >= n3 && n2 >= n4) {
            return "ds";
        }
        if (n >= n2 && n >= n3 && n >= n4) {
            return "";
        }
        if (n3 >= n && n3 >= n2 && n3 >= n4) {
            return "dsig";
        }
        if (n4 >= n && n4 >= n3 && n4 >= n2) {
            return "dsig11";
        }
        return "ds";
    }
}

