/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xmldsig;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOInvalidFormatException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.misc.MimeHelper;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AOSignInfo;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.core.util.tree.AOTreeModel;
import es.gob.afirma.core.util.tree.AOTreeNode;
import es.gob.afirma.signers.xml.InvalidXMLException;
import es.gob.afirma.signers.xml.Utils;
import es.gob.afirma.signers.xml.XMLConstants;
import es.gob.afirma.signers.xml.style.CannotDereferenceException;
import es.gob.afirma.signers.xml.style.IsInnerlException;
import es.gob.afirma.signers.xml.style.ReferenceIsNotXmlException;
import es.gob.afirma.signers.xml.style.XmlStyle;
import es.gob.afirma.signers.xmldsig.CustomUriDereferencer;
import es.gob.afirma.signers.xmldsig.XmlDSigUtil;
import es.uji.crypto.xades.jxades.util.DOMOutputImpl;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Logger;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public final class AOXMLDSigSigner
implements AOSigner {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String XADESNS = "http://uri.etsi.org/01903#";
    private static final String SIGNATURE_STR = "Signature";
    private static final String MIMETYPE_STR = "MimeType";
    private static final String ENCODING_STR = "Encoding";
    private static final String REFERENCE_STR = "Reference";
    private static final String ID_IDENTIFIER = "Id";
    private static final String HTTP_PROTOCOL_PREFIX = "http://";
    private static final String HTTPS_PROTOCOL_PREFIX = "https://";
    private static final String STYLE_REFERENCE_PREFIX = "StyleReference-";
    private static final String CSURI = "http://uri.etsi.org/01903#CountersignedSignature";
    private static final String AFIRMA = "AFIRMA";
    private static final String XML_SIGNATURE_PREFIX = "ds";
    private static final String DETACHED_CONTENT_ELEMENT_NAME = "CONTENT";
    private static final String DETACHED_STYLE_ELEMENT_NAME = "STYLE";
    private static final String DIGEST_METHOD = "http://www.w3.org/2000/09/xmldsig#sha1";
    private static final String SIGNATURE_VALUE = "SignatureValue";
    private static final String URI_STR = "URI";
    private String algo;
    private Document doc;

    /*
     * Unable to fully structure code
     */
    @Override
    public byte[] sign(byte[] var1_1, String var2_2, PrivateKey var3_3, Certificate[] var4_4, Properties var5_5) throws AOException {
        var6_6 = XMLConstants.SIGN_ALGOS_URI.get(var2_2);
        if (var6_6 == null) {
            throw new UnsupportedOperationException("La URI de definicion del algoritmo de firma no puede ser nula");
        }
        var7_7 = var5_5 != null ? var5_5 : new Properties();
        var8_8 = var7_7.getProperty("format", "XMLDSig Enveloping");
        var9_9 = var7_7.getProperty("mode", "implicit");
        var10_10 = var7_7.getProperty("referencesDigestMethod", "http://www.w3.org/2000/09/xmldsig#sha1");
        var11_11 = var7_7.getProperty("canonicalizationAlgorithm", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        var12_12 = Boolean.parseBoolean(var7_7.getProperty("ignoreStyleSheets", Boolean.FALSE.toString()));
        var13_13 = Boolean.parseBoolean(var7_7.getProperty("avoidBase64Transforms", Boolean.FALSE.toString()));
        var14_14 = Boolean.parseBoolean(var7_7.getProperty("headless", Boolean.TRUE.toString()));
        var15_15 = Boolean.parseBoolean(var7_7.getProperty("avoidXpathExtraTransformsOnEnveloped", Boolean.FALSE.toString()));
        var16_16 = var7_7.getProperty("xmlSignaturePrefix", "ds");
        var17_17 = var7_7.getProperty("mimeType");
        var18_18 = var7_7.getProperty("encoding");
        if ("base64".equalsIgnoreCase(var18_18)) {
            var18_18 = "http://www.w3.org/2000/09/xmldsig#base64";
        }
        var19_19 = null;
        try {
            var19_19 = AOUtil.createURI(var7_7.getProperty("uri"));
        }
        catch (Exception var20_20) {
            // empty catch block
        }
        var20_21 = var7_7.getProperty("precalculatedHashAlgorithm");
        Utils.checkIllegalParams(var8_8, var9_9, var19_19, var20_21, false);
        if (!(var1_1 != null && var1_1.length != 0 || var8_8.equals("XMLDSig Externally Detached") && var19_19 != null)) {
            throw new AOException("No se han podido leer los datos a firmar");
        }
        var21_22 = new Hashtable<String, String>();
        var22_23 = DocumentBuilderFactory.newInstance();
        var22_23.setNamespaceAware(true);
        var24_24 = "CONTENT-" + UUID.randomUUID().toString() + "-" + "CONTENT";
        var25_25 = "STYLE-" + UUID.randomUUID().toString() + "-" + "STYLE";
        var26_26 = false;
        var27_27 = false;
        var28_28 = new XmlStyle();
        if (var9_9.equals("implicit")) {
            try {
                var29_29 = var22_23.newDocumentBuilder().parse(new ByteArrayInputStream(var1_1));
                if (!var12_12) {
                    try {
                        var28_28 = new XmlStyle(var1_1, var14_14);
                    }
                    catch (IsInnerlException var30_31) {
                        AOXMLDSigSigner.LOGGER.info("La hoja de estilo esta referenciada internamente, por lo que no se necesita dereferenciar: " + var30_31);
                    }
                    catch (ReferenceIsNotXmlException var30_32) {
                        AOXMLDSigSigner.LOGGER.warning("La hoja de estilo referenciada no es XML o no se ha dereferenciado apropiadamente: " + var30_32);
                    }
                    catch (CannotDereferenceException var30_33) {
                        AOXMLDSigSigner.LOGGER.warning("La hoja de estilo no ha podido dereferenciar, probablemente sea un enlace relativo local: " + var30_33);
                    }
                    catch (Exception var30_34) {
                        AOXMLDSigSigner.LOGGER.severe("Error intentando dereferenciar la hoja de estilo: " + var30_34);
                    }
                }
                if (var17_17 == null || "application/octet-stream".equals(var17_17)) {
                    var17_17 = "text/xml";
                }
                if (var18_18 == null) {
                    var18_18 = var29_29.getXmlEncoding();
                }
                if (var18_18 != null && !"http://www.w3.org/2000/09/xmldsig#base64".equals(var18_18)) {
                    var21_22.put("encoding", var18_18);
                }
                if ((var30_35 = (Object)var29_29.getXmlVersion()) != null) {
                    var21_22.put("version", (String)var30_35);
                }
                if ((var31_38 = var29_29.getDoctype()) != null && (var30_35 = var31_38.getSystemId()) != null) {
                    var21_22.put("doctype-system", (String)var30_35);
                }
                if (var8_8.equals("XMLDSig Detached")) {
                    var23_42 = var29_29.createElement("CONTENT");
                    var23_42.setAttributeNS(null, "Id", var24_24);
                    var23_42.setAttributeNS(null, "MimeType", (String)var17_17);
                    var23_42.setAttributeNS(null, "Encoding", var18_18);
                    var23_42.appendChild(var29_29.getDocumentElement());
                    if (var28_28.getStyleElement() == null) ** GOTO lbl167
                    try {
                        var32_43 = var29_29.createElement("STYLE");
                        var32_43.setAttributeNS(null, "Id", var25_25);
                        if (var28_28.getStyleType() != null) {
                            var32_43.setAttributeNS(null, "MimeType", var28_28.getStyleType());
                        }
                        var32_43.setAttributeNS(null, "Encoding", var28_28.getStyleEncoding());
                        var32_43.appendChild(var29_29.adoptNode(var28_28.getStyleElement().cloneNode(true)));
                        var28_28.setStyleElement((Element)var32_43);
                    }
                    catch (Exception var32_44) {
                        AOXMLDSigSigner.LOGGER.warning("No ha sido posible crear el elemento DOM para incluir la hoja de estilo del XML como Internally Detached: " + var32_44);
                        var28_28.setStyleElement(null);
                    }
                }
                var23_42 = var29_29.getDocumentElement();
            }
            catch (Exception var29_30) {
                if (var8_8.equals("XMLDSig Enveloped")) {
                    throw new InvalidXMLException(var29_30);
                }
                try {
                    AOXMLDSigSigner.LOGGER.info("El documento no es un XML valido. Se convertira a Base64: " + var29_30);
                    var30_35 = var22_23.newDocumentBuilder().newDocument();
                    var23_42 = var30_35.createElement("CONTENT");
                    var19_19 = null;
                    var18_18 = "http://www.w3.org/2000/09/xmldsig#base64";
                    if (var17_17 == null) {
                        var17_17 = "application/octet-stream";
                    }
                    var23_42.setAttributeNS(null, "Id", var24_24);
                    if (Base64.isBase64(var1_1) && ("http://www.w3.org/2000/09/xmldsig#base64".equals(var18_18) || (var18_18 != null ? var18_18 : "").toLowerCase().equals("base64"))) {
                        AOXMLDSigSigner.LOGGER.info("El documento se ha indicado como Base64, se insertara como tal en el XML");
                        var31_38 = Base64.decode(new String(var1_1));
                        var32_43 = new MimeHelper((byte[])var31_38);
                        var33_46 = var32_43.getMimeType();
                        var17_17 = var33_46 != null ? var33_46 : "application/octet-stream";
                        var23_42.setAttributeNS(null, "MimeType", (String)var17_17);
                        var23_42.setTextContent(new String(var1_1));
                    } else {
                        if ("http://www.w3.org/2000/09/xmldsig#base64".equals(var18_18)) {
                            AOXMLDSigSigner.LOGGER.info("El documento se ha indicado como Base64, pero no es un Base64 valido. Se convertira a Base64 antes de insertarlo en el XML y se declarara la transformacion");
                        } else {
                            AOXMLDSigSigner.LOGGER.info("El documento se considera binario, se convertira a Base64 antes de insertarlo en el XML y se declarara la transformacion");
                        }
                        if ("application/octet-stream".equals(var17_17)) {
                            var31_38 = new MimeHelper(var1_1);
                            var32_43 = var31_38.getMimeType();
                            var17_17 = var32_43 != null ? var32_43 : "application/octet-stream";
                        }
                        var23_42.setAttributeNS(null, "MimeType", (String)var17_17);
                        var23_42.setTextContent(Base64.encode(var1_1));
                        var27_27 = true;
                    }
                    var26_26 = true;
                    var18_18 = "http://www.w3.org/2000/09/xmldsig#base64";
                    var23_42.setAttributeNS(null, "Encoding", var18_18);
                }
                catch (Exception var30_36) {
                    throw new AOException("Error al convertir los datos a base64", var30_36);
                }
            }
        } else {
            var29_29 = null;
            if (var19_19 != null) {
                var30_35 = null;
                try {
                    var30_35 = AOUtil.getDataFromInputStream(AOUtil.loadFile(var19_19));
                }
                catch (Exception var31_39) {
                    throw new AOException("No se han podido obtener los datos de la URI externa", var31_39);
                }
                if (var30_35 != null && ((byte[])var30_35).length > 0) {
                    try {
                        var29_29 = MessageDigest.getInstance("SHA1").digest((byte[])var30_35);
                    }
                    catch (Exception var31_40) {
                        throw new AOException("No se ha podido obtener el SHA1 de los datos de la URI externa", var31_40);
                    }
                }
            } else if (var20_21 != null) {
                var29_29 = var1_1;
            } else {
                try {
                    var29_29 = MessageDigest.getInstance("SHA1").digest(var1_1);
                }
                catch (Exception var30_37) {
                    throw new AOException("No se ha podido obtener el SHA1 de los datos proporcionados: " + var30_37, var30_37);
                }
            }
            if (var29_29 == null || ((byte[])var29_29).length < 1) {
                throw new AOException("Error al obtener la huella SHA1 de los datos");
            }
            try {
                var30_35 = var22_23.newDocumentBuilder().newDocument();
            }
            catch (Exception var31_41) {
                throw new AOException("No se ha podido crear el documento XML contenedor: " + var31_41, var31_41);
            }
            var23_42 = var30_35.createElement("CONTENT");
            var18_18 = "http://www.w3.org/2000/09/xmldsig#base64";
            var17_17 = var20_21 != null ? "hash/" + var20_21.toLowerCase() : "hash/sha1";
            var23_42.setAttributeNS(null, "Id", var24_24);
            var23_42.setAttributeNS(null, "MimeType", (String)var17_17);
            var23_42.setAttributeNS(null, "Encoding", var18_18);
            var23_42.setTextContent(Base64.encode((byte[])var29_29));
            var26_26 = true;
        }
lbl167:
        // 6 sources

        var29_29 = "#" + var24_24;
        var30_35 = "#" + var25_25;
        var31_38 = null;
        try {
            var31_38 = var22_23.newDocumentBuilder().newDocument();
            if (var8_8.equals("XMLDSig Enveloped")) {
                var31_38.appendChild(var31_38.adoptNode(var23_42));
            } else {
                var31_38.appendChild(var31_38.createElement("AFIRMA"));
            }
        }
        catch (Exception var32_45) {
            throw new AOException("Error al crear la firma en formato " + var8_8 + ", modo " + var9_9, var32_45);
        }
        var32_43 = new ArrayList<Reference>();
        var33_46 = Utils.getDOMFactory();
        try {
            var34_47 = var33_46.newDigestMethod(var10_10, null);
        }
        catch (Exception var35_48) {
            throw new AOException("No se ha podido obtener un generador de huellas digitales para el algoritmo '" + var10_10 + "'", var35_48);
        }
        var35_49 = "Reference-" + UUID.randomUUID().toString();
        var36_50 = "StyleReference-" + UUID.randomUUID().toString();
        var37_51 = new ArrayList<Transform>();
        Utils.addCustomTransforms(var37_51, var7_7, var16_16);
        if ("none".equalsIgnoreCase(var11_11)) {
            var38_52 = null;
        } else {
            try {
                var38_52 = var33_46.newTransform(var11_11, (TransformParameterSpec)null);
            }
            catch (Exception var39_53) {
                throw new AOException("No se ha podido crear la transformacion de canonicalizacion para el algoritmo '" + var11_11 + "': " + var39_53);
            }
        }
        if (!var26_26) {
            if (var38_52 != null) {
                try {
                    var37_51.add(var38_52);
                }
                catch (Exception var39_54) {
                    AOXMLDSigSigner.LOGGER.severe("No se puede encontrar el algoritmo de canonicalizacion, la referencia no se canonicalizara: " + var39_54);
                }
            }
        } else if (var27_27 && !var13_13) {
            try {
                var37_51.add(var33_46.newTransform("http://www.w3.org/2000/09/xmldsig#base64", (TransformParameterSpec)null));
            }
            catch (Exception var39_55) {
                AOXMLDSigSigner.LOGGER.severe("No se puede encontrar el algoritmo transformacion Base64, esta no se declarara: " + var39_55);
            }
        }
        var39_56 = null;
        var40_57 = null;
        if (var8_8.equals("XMLDSig Enveloping")) {
            try {
                var41_58 = new ArrayList<DOMStructure>(1);
                if (var26_26) {
                    var41_58.add(new DOMStructure(var23_42.getFirstChild()));
                } else {
                    var41_58.add(new DOMStructure(var23_42));
                }
                var42_65 = "Object-" + UUID.randomUUID().toString();
                var39_56 = var33_46.newXMLObject((List<? extends XMLStructure>)var41_58, (String)var42_65, (String)var17_17, var18_18);
                var32_43.add(var33_46.newReference("#" + (String)var42_65, var34_47, var37_51, "http://www.w3.org/2000/09/xmldsig#Object", var35_49));
                if (var28_28.getStyleElement() != null) {
                    var43_69 = "StyleObject-" + UUID.randomUUID().toString();
                    var40_57 = var33_46.newXMLObject(Collections.singletonList(new DOMStructure(var28_28.getStyleElement())), (String)var43_69, var28_28.getStyleType(), var28_28.getStyleEncoding());
                    var32_43.add(var33_46.newReference("#" + (String)var43_69, var34_47, var38_52 != null ? Collections.singletonList(var38_52) : null, "http://www.w3.org/2000/09/xmldsig#Object", var36_50));
                }
            }
            catch (Exception var41_59) {
                throw new AOException("Error al generar la firma en formato enveloping", var41_59);
            }
            if (var28_28.getStyleHref() != null && var28_28.getStyleElement() == null && (var28_28.getStyleHref().startsWith("http://") || var28_28.getStyleHref().startsWith("https://"))) {
                try {
                    var32_43.add(var33_46.newReference(var28_28.getStyleHref(), var34_47, var38_52 != null ? Collections.singletonList(var38_52) : null, "http://www.w3.org/2000/09/xmldsig#Object", var36_50));
                }
                catch (Exception var41_60) {
                    AOXMLDSigSigner.LOGGER.severe("No ha sido posible anadir la referencia a la hoja de estilo del XML en la firma Externally Detached, esta no se firmara: " + var41_60);
                }
            }
        } else if (var8_8.equals("XMLDSig Detached")) {
            try {
                if (var23_42 != null) {
                    var31_38.getDocumentElement().appendChild(var31_38.adoptNode(var23_42));
                    var32_43.add(var33_46.newReference((String)var29_29, var34_47, var37_51, "http://www.w3.org/2000/09/xmldsig#Object", var35_49));
                }
                if (var28_28.getStyleElement() != null) {
                    var31_38.getDocumentElement().appendChild(var31_38.adoptNode(var28_28.getStyleElement()));
                    var32_43.add(var33_46.newReference((String)var30_35, var34_47, var38_52 != null ? Collections.singletonList(var38_52) : null, "http://www.w3.org/2000/09/xmldsig#Object", var36_50));
                }
            }
            catch (Exception var41_61) {
                throw new AOException("Error al generar la firma en formato detached implicito", var41_61);
            }
            if (var28_28.getStyleHref() != null && var28_28.getStyleElement() == null && (var28_28.getStyleHref().startsWith("http://") || var28_28.getStyleHref().startsWith("https://"))) {
                try {
                    var32_43.add(var33_46.newReference(var28_28.getStyleHref(), var34_47, Collections.singletonList(var33_46.newTransform(var11_11, (TransformParameterSpec)null)), "http://www.w3.org/2000/09/xmldsig#Object", var36_50));
                }
                catch (Exception var41_62) {
                    AOXMLDSigSigner.LOGGER.severe("No ha sido posible anadir la referencia a la hoja de estilo del XML en la firma Detached Implicita, esta no se firmara: " + var41_62);
                }
            }
        } else if (var8_8.equals("XMLDSig Externally Detached")) {
            var41_58 = null;
            if (var20_21 != null && (var19_19 == null || var19_19.getScheme().equals("") || var19_19.getScheme().equals("file"))) {
                var42_65 = null;
                try {
                    if (AOSignConstants.getDigestAlgorithmName(var20_21).equalsIgnoreCase("SHA1")) {
                        var42_65 = var33_46.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
                    } else if (AOSignConstants.getDigestAlgorithmName(var20_21).equalsIgnoreCase("SHA-256")) {
                        var42_65 = var33_46.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null);
                    } else if (AOSignConstants.getDigestAlgorithmName(var20_21).equalsIgnoreCase("SHA-512")) {
                        var42_65 = var33_46.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha512", null);
                    } else if (AOSignConstants.getDigestAlgorithmName(var20_21).equalsIgnoreCase("RIPEMD160")) {
                        var42_65 = var33_46.newDigestMethod("http://www.w3.org/2001/04/xmlenc#ripemd160", null);
                    }
                }
                catch (Exception var43_70) {
                    throw new AOException("No se ha podido crear el metodo de huella digital para la referencia Externally Detached", var43_70);
                }
                if (var42_65 == null) {
                    throw new AOException("Metodo de Message Digest para la referencia Externally Detached no soportado: " + var20_21);
                }
                var41_58 = var33_46.newReference("", (DigestMethod)var42_65, null, "http://www.w3.org/2000/09/xmldsig#Object", var35_49, var1_1);
            } else {
                if (var19_19 != null && var19_19.getScheme().equals("file")) {
                    try {
                        var41_58 = var33_46.newReference("", var34_47, null, "http://www.w3.org/2000/09/xmldsig#Object", var35_49, MessageDigest.getInstance(AOSignConstants.getDigestAlgorithmName(var10_10)).digest(AOUtil.getDataFromInputStream(AOUtil.loadFile(var19_19))));
                    }
                    catch (Exception var42_66) {
                        throw new AOException("No se ha podido crear la referencia XML a partir de la URI local (" + var19_19.toASCIIString() + ")", var42_66);
                    }
                }
                if (var19_19 != null) {
                    try {
                        var41_58 = var33_46.newReference(var19_19.toASCIIString(), var34_47);
                    }
                    catch (Exception var42_67) {
                        throw new AOException("No se ha podido crear la referencia Externally Detached, probablemente por no obtenerse el metodo de digest", var42_67);
                    }
                }
            }
            if (var41_58 == null) {
                throw new AOException("Error al generar la firma Externally Detached, no se ha podido crear la referencia externa");
            }
            var32_43.add(var41_58);
            if (var28_28.getStyleHref() != null && var28_28.getStyleElement() == null) {
                if (var28_28.getStyleHref().startsWith("http://") || var28_28.getStyleHref().startsWith("https://")) {
                    try {
                        var32_43.add(var33_46.newReference(var28_28.getStyleHref(), var34_47, var38_52 != null ? Collections.singletonList(var38_52) : null, "http://www.w3.org/2000/09/xmldsig#Object", var36_50));
                    }
                    catch (Exception var42_68) {
                        AOXMLDSigSigner.LOGGER.severe("No ha sido posible anadir la referencia a la hoja de estilo remota del XML en la firma Externally Detached, esta no se firmara: " + var42_68);
                    }
                } else {
                    AOXMLDSigSigner.LOGGER.warning("Se necesita una referencia externa HTTP o HTTPS a la hoja de estilo para referenciarla en firmas XML Externally Detached");
                }
            }
        } else if (var8_8.equals("XMLDSig Enveloped")) {
            try {
                var37_51.add(var33_46.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
                if (!var15_15) {
                    var37_51.add(var33_46.newTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", new XPathFilterParameterSpec("not(ancestor-or-self::" + var16_16 + ":Signature)", Collections.singletonMap(var16_16, "http://www.w3.org/2000/09/xmldsig#"))));
                }
                var32_43.add(var33_46.newReference("", var34_47, var37_51, "http://www.w3.org/2000/09/xmldsig#Object", var35_49));
            }
            catch (Exception var41_63) {
                throw new AOException("Error al generar la firma en formato enveloped", var41_63);
            }
            if (var28_28.getStyleHref() != null && var28_28.getStyleElement() == null && (var28_28.getStyleHref().startsWith("http://") || var28_28.getStyleHref().startsWith("https://"))) {
                try {
                    var32_43.add(var33_46.newReference(var28_28.getStyleHref(), var34_47, var38_52 != null ? Collections.singletonList(var38_52) : null, "http://www.w3.org/2000/09/xmldsig#Object", var36_50));
                }
                catch (Exception var41_64) {
                    AOXMLDSigSigner.LOGGER.severe("No ha sido posible anadir la referencia a la hoja de estilo remota del XML en la firma Enveloped, esta no se firmara: " + var41_64);
                }
            }
        }
        var41_58 = UUID.randomUUID().toString();
        var42_65 = "KeyInfo-" + (String)var41_58;
        try {
            var32_43.add(var33_46.newReference("#" + (String)var42_65, var34_47, var37_51, null, null));
            var43_69 = var33_46.getKeyInfoFactory();
            var44_73 = new ArrayList<XMLStructure>();
            var45_75 = (X509Certificate)var4_4[0];
            var44_73.add(var43_69.newKeyValue(var45_75.getPublicKey()));
            var46_76 = null;
            var47_77 = Boolean.parseBoolean(var7_7.getProperty("includeOnlySignningCertificate", Boolean.FALSE.toString()));
            if (!var47_77) {
                var46_76 = var4_4;
            }
            if (var46_76 == null) {
                var46_76 = new Certificate[]{var45_75};
            }
            var44_73.add(var43_69.newX509Data(Arrays.asList(var46_76)));
            var48_78 = new ArrayList<XMLObject>();
            if (var8_8.equals("XMLDSig Enveloping") && var39_56 != null) {
                var48_78.add(var39_56);
                if (var40_57 != null) {
                    var48_78.add(var40_57);
                }
            }
            if (var8_8.equals("XMLDSig Enveloped") && var28_28.getStyleElement() != null) {
                var48_78.add(var33_46.newXMLObject(Collections.singletonList(new DOMStructure(var28_28.getStyleElement())), var25_25, var28_28.getStyleType(), var28_28.getStyleEncoding()));
                try {
                    var32_43.add((Reference)var33_46.newReference((String)var30_35, var34_47, var38_52 != null ? Collections.singletonList(var38_52) : null, "http://www.w3.org/2000/09/xmldsig#Object", var36_50));
                }
                catch (Exception var49_79) {
                    AOXMLDSigSigner.LOGGER.severe("No se ha podido anadir una referencia a la hoja de estilo, esta se incluira dentro de la firma, pero no estara firmada: " + var49_79);
                }
            }
            var49_80 = var33_46.newXMLSignature(var33_46.newSignedInfo(var33_46.newCanonicalizationMethod(var38_52 != null ? var11_11 : "http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), var33_46.newSignatureMethod(var6_6, null), XmlDSigUtil.cleanReferencesList(var32_43)), var43_69.newKeyInfo((List<? extends XMLStructure>)var44_73, (String)var42_65), var48_78, "Signature-" + (String)var41_58, "SignatureValue-" + (String)var41_58);
            var50_81 = new DOMSignContext(var3_3, (Node)var31_38.getDocumentElement());
            var50_81.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", var16_16);
            try {
                var50_81.setURIDereferencer(new CustomUriDereferencer(CustomUriDereferencer.getDefaultDereferencer()));
            }
            catch (Exception var51_82) {
                AOXMLDSigSigner.LOGGER.warning("No se ha podido instalar un dereferenciador a medida, es posible que fallen las firmas de nodos concretos: " + var51_82);
            }
            var49_80.sign(var50_81);
        }
        catch (NoSuchAlgorithmException var43_71) {
            throw new UnsupportedOperationException("Hay al menos un algoritmo no soportado: " + var43_71, var43_71);
        }
        catch (Exception var43_72) {
            throw new AOException("Error al generar la firma XMLdSig: " + var43_72, var43_72);
        }
        var43_69 = (var16_16 == null || var16_16.isEmpty() != false ? "" : var16_16 + ":") + "Signature";
        if (var8_8.equals("XMLDSig Enveloping")) {
            try {
                if (var31_38.getElementsByTagName((String)var43_69).getLength() == 1) {
                    var44_73 = var22_23.newDocumentBuilder().newDocument();
                    var44_73.appendChild(var44_73.adoptNode(var31_38.getElementsByTagName((String)var43_69).item(0)));
                    var31_38 = var44_73;
                }
            }
            catch (Exception var44_74) {
                AOXMLDSigSigner.LOGGER.info("No se ha eliminado el nodo padre '<AFIRMA>': " + var44_74);
            }
        }
        return Utils.writeXML(var31_38.getDocumentElement(), var21_22, var8_8.equals("XMLDSig Enveloped") != false ? var28_28.getStyleHref() : null, var8_8.equals("XMLDSig Enveloped") != false ? var28_28.getStyleType() : null);
    }

    private static boolean isDetached(Element element) {
        if (element == null) {
            return false;
        }
        return element.getFirstChild().getLocalName() != null && element.getFirstChild().getLocalName().equals(DETACHED_CONTENT_ELEMENT_NAME);
    }

    private static boolean isEnveloped(Element element) {
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Transform");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!((Element)nodeList.item(i)).getAttribute("Algorithm").equals("http://www.w3.org/2000/09/xmldsig#enveloped-signature")) continue;
            return true;
        }
        return false;
    }

    private static boolean isEnveloping(Element element) {
        if (element == null) {
            return false;
        }
        return SIGNATURE_STR.equals(element.getLocalName()) || AFIRMA.equals(element.getNodeName()) && SIGNATURE_STR.equals(element.getFirstChild().getLocalName());
    }

    @Override
    public byte[] getData(byte[] byArray) throws AOInvalidFormatException {
        Object object;
        Element element;
        block9: {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            element = null;
            try {
                if (!this.isSign(byArray)) {
                    throw new AOInvalidFormatException("El documento no es un documento de firmas valido.");
                }
                Element element2 = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray)).getDocumentElement();
                if (AOXMLDSigSigner.isDetached(element2)) {
                    object = (Element)element2.getFirstChild();
                    if (object.getAttribute(MIMETYPE_STR).equals("text/xml")) {
                        element = (Element)object.getFirstChild();
                        break block9;
                    }
                    return Base64.decode(object.getTextContent());
                }
                if (AOXMLDSigSigner.isEnveloped(element2)) {
                    object = element2.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_STR);
                    int n = object.getLength();
                    for (int i = 0; i < n; ++i) {
                        element2.removeChild(object.item(0));
                    }
                    element = element2;
                    break block9;
                }
                if (!AOXMLDSigSigner.isEnveloping(element2)) break block9;
                object = (Element)element2.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Object").item(0);
                if (object.getAttribute(MIMETYPE_STR).equals("text/xml")) {
                    element = (Element)object.getFirstChild();
                    break block9;
                }
                return Base64.decode(object.getTextContent());
            }
            catch (Exception exception) {
                throw new AOInvalidFormatException("Error al leer el fichero de firmas", exception);
            }
        }
        if (element == null) {
            return null;
        }
        object = new ByteArrayOutputStream();
        AOXMLDSigSigner.writeXML(new BufferedWriter(new OutputStreamWriter((OutputStream)object)), element);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    @Override
    public byte[] cosign(byte[] byArray, byte[] byArray2, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        String string2;
        Object object7;
        Object object8;
        DigestMethod digestMethod;
        Element element;
        Document document;
        String string3 = XMLConstants.SIGN_ALGOS_URI.get(string);
        if (string3 == null) {
            throw new UnsupportedOperationException("La URI de definicion del algoritmo de firma no puede ser nula");
        }
        Properties properties2 = properties != null ? properties : new Properties();
        String string4 = properties2.getProperty("referencesDigestMethod", DIGEST_METHOD);
        String string5 = properties2.getProperty("canonicalizationAlgorithm", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        String string6 = properties2.getProperty("xmlSignaturePrefix", XML_SIGNATURE_PREFIX);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray2));
            element = document.getDocumentElement();
            if (element.getNodeName().equals((string6 == null || string6.isEmpty() ? "" : string6 + ":") + SIGNATURE_STR)) {
                document = AOXMLDSigSigner.insertarNodoAfirma(document);
                element = document.getDocumentElement();
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new AOException("Error en el amalizador XML: " + parserConfigurationException, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new AOException("Formato de documento de firmas (XML firmado de entrada) incorrecto: " + sAXException, sAXException);
        }
        catch (IOException iOException) {
            throw new AOException("Error al leer el documento de firmas", iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AOException("Parametro de entrada incorrecto", illegalArgumentException);
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido leer el documento XML de firmas", exception);
        }
        ArrayList<Reference> arrayList = new ArrayList<Reference>();
        XMLSignatureFactory xMLSignatureFactory = Utils.getDOMFactory();
        try {
            digestMethod = xMLSignatureFactory.newDigestMethod(string4, null);
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido obtener un generador de huellas digitales para el algoritmo '" + string4 + "'", exception);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        NodeList nodeList = ((Element)document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_STR).item(0)).getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", REFERENCE_STR);
        XMLObject xMLObject = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            object8 = node.getAttributes();
            if (i != 0 && (object8.getNamedItem(ID_IDENTIFIER) == null || !object8.getNamedItem(ID_IDENTIFIER).getNodeValue().startsWith(STYLE_REFERENCE_PREFIX))) continue;
            try {
                object7 = Utils.getObjectReferenceTransforms(node, string6);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Logger.getLogger("Se ha declarado una transformacion personalizada de un tipo no soportado: " + noSuchAlgorithmException);
                throw new AOException("Se ha declarado una transformacion personalizada de un tipo no soportado", noSuchAlgorithmException);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                Logger.getLogger("Se han especificado parametros erroneos para una transformacion personalizada: " + invalidAlgorithmParameterException);
                throw new AOException("Se han especificado parametros erroneos para una transformacion personalizada", invalidAlgorithmParameterException);
            }
            string2 = null;
            string2 = object8.getNamedItem(ID_IDENTIFIER) != null && object8.getNamedItem(ID_IDENTIFIER).getNodeValue().startsWith(STYLE_REFERENCE_PREFIX) ? STYLE_REFERENCE_PREFIX + UUID.randomUUID().toString() : "Reference-" + UUID.randomUUID().toString();
            arrayList2.add(string2);
            object6 = ((Element)node).getAttribute(URI_STR);
            if (AOXMLDSigSigner.isEnveloping(element) && object6 != null) {
                object5 = AOXMLDSigSigner.searchDataElement((String)object6, element);
                if (object5 == null) {
                    LOGGER.severe("No se ha identificado el nodo de datos a firmar");
                    throw new AOException("No se ha identificado el nodo de datos a firmar");
                }
                object4 = new ArrayList(1);
                object4.add(new DOMStructure(object5.getFirstChild().cloneNode(true)));
                object3 = ((Element)object5).getAttribute(MIMETYPE_STR);
                object2 = ((Element)object5).getAttribute(ENCODING_STR);
                object = "Object-" + UUID.randomUUID().toString();
                xMLObject = xMLSignatureFactory.newXMLObject((List<? extends XMLStructure>)object4, (String)object, (String)object3, (String)object2);
                arrayList.add(xMLSignatureFactory.newReference("#" + (String)object, digestMethod, (List<? extends Transform>)object7, "http://www.w3.org/2000/09/xmldsig#Object", string2));
                continue;
            }
            arrayList.add(xMLSignatureFactory.newReference(((Element)node).getAttribute(URI_STR), digestMethod, (List<? extends Transform>)object7, "http://www.w3.org/2000/09/xmldsig#Object", string2));
        }
        String string7 = UUID.randomUUID().toString();
        object8 = "Signature-" + string7;
        object7 = "SignatureValue-" + string7;
        string2 = "KeyInfo-" + string7;
        try {
            object6 = xMLSignatureFactory.newCanonicalizationMethod(string5, (C14NMethodParameterSpec)null);
            object5 = new ArrayList<Transform>();
            object4 = xMLSignatureFactory.newTransform(string5, (TransformParameterSpec)null);
            object5.add(object4);
            arrayList.add(xMLSignatureFactory.newReference("#" + string2, digestMethod, (List<? extends Transform>)object5, null, null));
            object3 = xMLSignatureFactory.newSignatureMethod(string3, null);
            object2 = xMLSignatureFactory.getKeyInfoFactory();
            object = (X509Certificate)certificateArray[0];
            ArrayList<XMLStructure> arrayList3 = new ArrayList<XMLStructure>();
            arrayList3.add(((KeyInfoFactory)object2).newKeyValue(((Certificate)object).getPublicKey()));
            Certificate[] certificateArray2 = null;
            boolean bl = Boolean.parseBoolean(properties2.getProperty("includeOnlySignningCertificate", Boolean.FALSE.toString()));
            if (!bl) {
                certificateArray2 = certificateArray;
            }
            if (certificateArray2 == null) {
                certificateArray2 = new Certificate[]{object};
            }
            arrayList3.add(((KeyInfoFactory)object2).newX509Data(Arrays.asList(certificateArray2)));
            DOMSignContext dOMSignContext = new DOMSignContext(privateKey, (Node)element);
            dOMSignContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", string6);
            try {
                dOMSignContext.setURIDereferencer(new CustomUriDereferencer(CustomUriDereferencer.getDefaultDereferencer()));
            }
            catch (Exception exception) {
                LOGGER.warning("No se ha podido instalar un dereferenciador a medida, es posible que fallen las firmas de nodos concretos: " + exception);
            }
            ArrayList<XMLObject> arrayList4 = new ArrayList<XMLObject>();
            if (AOXMLDSigSigner.isEnveloping(element) && xMLObject != null) {
                arrayList4.add(xMLObject);
            }
            xMLSignatureFactory.newXMLSignature(xMLSignatureFactory.newSignedInfo((CanonicalizationMethod)object6, (SignatureMethod)object3, arrayList), ((KeyInfoFactory)object2).newKeyInfo(arrayList3, string2), arrayList4, (String)object8, (String)object7).sign(dOMSignContext);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UnsupportedOperationException("Hay al menos un algoritmo no soportado: " + noSuchAlgorithmException, noSuchAlgorithmException);
        }
        catch (Exception exception) {
            throw new AOException("Error al generar la cofirma XMLdSig: " + exception, exception);
        }
        return Utils.writeXML(element, hashtable, null, null);
    }

    @Override
    public byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        Object object;
        Element element;
        Object object2;
        Element element2;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            element2 = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray)).getDocumentElement();
            object2 = documentBuilderFactory.newDocumentBuilder().newDocument();
            element = (Element)object2.adoptNode(element2.cloneNode(true));
            object = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_STR);
            while (object.getLength() > 0) {
                element.removeChild(object.item(0));
                object = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_STR);
            }
            object2.appendChild(element);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new AOException("Error en el analizador XML: " + parserConfigurationException, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new AOException("Formato de documento de firmas (XML firmado de entrada) incorrecto: " + sAXException, sAXException);
        }
        catch (IOException iOException) {
            throw new AOException("Error al leer el documento de firmas: " + iOException, iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AOException("Parametro de entrada incorrecto: " + illegalArgumentException, illegalArgumentException);
        }
        object2 = new ByteArrayOutputStream();
        AOXMLDSigSigner.writeXML(new BufferedWriter(new OutputStreamWriter((OutputStream)object2)), element2);
        object = new ByteArrayOutputStream();
        AOXMLDSigSigner.writeXML(new BufferedWriter(new OutputStreamWriter((OutputStream)object)), element);
        return this.cosign(((ByteArrayOutputStream)object).toByteArray(), ((ByteArrayOutputStream)object2).toByteArray(), string, privateKey, certificateArray, properties);
    }

    @Override
    public byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        String string2 = XMLConstants.SIGN_ALGOS_URI.get(string);
        if (string2 == null) {
            throw new UnsupportedOperationException("La URI de definicion del algoritmo de firma no puede ser nula");
        }
        Properties properties2 = properties != null ? properties : new Properties();
        String string3 = properties2.getProperty("referencesDigestMethod", DIGEST_METHOD);
        String string4 = properties2.getProperty("canonicalizationAlgorithm", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        String string5 = properties2.getProperty("encoding");
        if ("base64".equalsIgnoreCase(string5)) {
            string5 = "http://www.w3.org/2000/09/xmldsig#base64";
        }
        String string6 = properties2.getProperty("xmlSignaturePrefix", XML_SIGNATURE_PREFIX);
        boolean bl = Boolean.parseBoolean(properties2.getProperty("includeOnlySignningCertificate", Boolean.FALSE.toString()));
        this.algo = string;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            Element element;
            DocumentType documentType;
            String string7;
            this.doc = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
            if (string5 == null) {
                string5 = this.doc.getXmlEncoding();
            }
            if (string5 != null && !"http://www.w3.org/2000/09/xmldsig#base64".equalsIgnoreCase(string5)) {
                hashtable.put("encoding", string5);
            }
            if ((string7 = this.doc.getXmlVersion()) != null) {
                hashtable.put("version", string7);
            }
            if ((documentType = this.doc.getDoctype()) != null && (string7 = documentType.getSystemId()) != null) {
                hashtable.put("doctype-system", string7);
            }
            if ((element = this.doc.getDocumentElement()).getNodeName().equals((string6 == null || string6.isEmpty() ? "" : string6 + ":") + SIGNATURE_STR)) {
                this.doc = AOXMLDSigSigner.insertarNodoAfirma(this.doc);
                element = this.doc.getDocumentElement();
            }
            if (counterSignTarget == CounterSignTarget.TREE) {
                this.countersignTree(element, privateKey, certificateArray, bl, string3, string4, string6);
            } else if (counterSignTarget == CounterSignTarget.LEAFS) {
                this.countersignLeafs(element, privateKey, certificateArray, bl, string3, string4, string6);
            } else if (counterSignTarget == CounterSignTarget.NODES) {
                this.countersignNodes(element, objectArray, privateKey, certificateArray, bl, string3, string4, string6);
            } else if (counterSignTarget == CounterSignTarget.SIGNERS) {
                this.countersignSigners(element, objectArray, privateKey, certificateArray, bl, string3, string4, string6);
            }
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido realizar la contrafirma: " + exception, exception);
        }
        return Utils.writeXML(this.doc.getDocumentElement(), hashtable, null, null);
    }

    private void countersignTree(Element element, PrivateKey privateKey, Certificate[] certificateArray, boolean bl, String string, String string2, String string3) throws AOException {
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_STR);
        Element[] elementArray = new Element[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            elementArray[i] = (Element)nodeList.item(i);
        }
        for (Element element2 : elementArray) {
            try {
                this.cs(element2, privateKey, certificateArray, bl, string, string2, string3);
            }
            catch (Exception exception) {
                throw new AOException("No se ha podido realizar la contrafirma del nodo '" + (element2 != null ? element2.getNodeName() : "nulo") + "': " + exception, exception);
            }
        }
    }

    private void countersignLeafs(Element element, PrivateKey privateKey, Certificate[] certificateArray, boolean bl, String string, String string2, String string3) throws AOException {
        int n;
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_STR);
        NodeList nodeList2 = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", REFERENCE_STR);
        String[] stringArray = new String[nodeList.getLength()];
        for (n = 0; n < nodeList.getLength(); ++n) {
            stringArray[n] = ((Element)nodeList.item(n)).getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_VALUE).item(0).getAttributes().getNamedItem(ID_IDENTIFIER).getNodeValue();
        }
        try {
            for (n = 0; n < stringArray.length; ++n) {
                String string4 = "#" + stringArray[n];
                boolean bl2 = true;
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    if (!((Element)nodeList2.item(i)).getAttribute(URI_STR).equals(string4)) continue;
                    bl2 = false;
                }
                if (!bl2) continue;
                this.cs((Element)nodeList.item(n), privateKey, certificateArray, bl, string, string2, string3);
            }
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido realizar la contrafirma: " + exception, exception);
        }
    }

    private void countersignNodes(Element element, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, boolean bl, String string, String string2, String string3) throws AOException {
        int n;
        if (objectArray == null) {
            throw new IllegalArgumentException("La lista de nodos a contrafirmar no puede ser nula");
        }
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_STR);
        String[] stringArray = new String[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            stringArray[i] = ((Element)nodeList.item(i)).getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_VALUE).item(0).getAttributes().getNamedItem(ID_IDENTIFIER).getNodeValue();
        }
        ArrayList<Element> arrayList = new ArrayList<Element>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            n = 1;
            NodeList nodeList2 = ((Element)nodeList.item(i)).getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", REFERENCE_STR);
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                if (!CSURI.equals(((Element)nodeList2.item(j)).getAttribute("Type"))) continue;
                n = 0;
                break;
            }
            if (n == 0) continue;
            arrayList.add((Element)nodeList.item(i));
            this.addSubNodes(stringArray[i], nodeList, stringArray, arrayList);
        }
        List<Object> list = Arrays.asList(objectArray);
        for (n = 0; n < arrayList.size(); ++n) {
            if (!list.contains(n)) continue;
            this.cs((Element)arrayList.get(n), privateKey, certificateArray, bl, string, string2, string3);
        }
    }

    private void addSubNodes(String string, NodeList nodeList, String[] stringArray, List<Element> list) {
        block0: for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList nodeList2 = ((Element)nodeList.item(i)).getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", REFERENCE_STR);
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                if (!("#" + string).equals(((Element)nodeList2.item(j)).getAttribute(URI_STR))) continue;
                if (stringArray[i].equals(string)) continue block0;
                list.add((Element)nodeList.item(i));
                this.addSubNodes(stringArray[i], nodeList, stringArray, list);
                continue block0;
            }
        }
    }

    private void countersignSigners(Element element, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, boolean bl, String string, String string2, String string3) throws AOException {
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_STR);
        int n = nodeList.getLength();
        List<Object> list = Arrays.asList(objectArray);
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (!list.contains(AOUtil.getCN(Utils.getCertificate(element2.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509Certificate").item(0))))) continue;
            arrayList.add(element2);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.cs((Element)iterator.next(), privateKey, certificateArray, bl, string, string2, string3);
        }
    }

    private void cs(Element element, PrivateKey privateKey, Certificate[] certificateArray, boolean bl, String string, String string2, String string3) throws AOException {
        Object object;
        DigestMethod digestMethod;
        Element element2 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_VALUE).item(0);
        ArrayList<Reference> arrayList = new ArrayList<Reference>();
        XMLSignatureFactory xMLSignatureFactory = Utils.getDOMFactory();
        try {
            digestMethod = xMLSignatureFactory.newDigestMethod(string, null);
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido obtener un generador de huellas digitales para el algoritmo '" + string + "': " + exception, exception);
        }
        String string4 = "Reference-" + UUID.randomUUID().toString();
        try {
            object = new ArrayList<Transform>();
            object.add(xMLSignatureFactory.newTransform(string2, (TransformParameterSpec)null));
            arrayList.add(xMLSignatureFactory.newReference("#" + element2.getAttribute(ID_IDENTIFIER), digestMethod, (List<? extends Transform>)object, CSURI, string4));
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido anadir la transformacion de canonizacion en la contrafirma: " + exception, exception);
        }
        object = UUID.randomUUID().toString();
        String string5 = "Signature-" + (String)object;
        String string6 = "SignatureValue-" + (String)object;
        String string7 = "KeyInfo-" + (String)object;
        try {
            arrayList.add(xMLSignatureFactory.newReference("#" + string7, digestMethod));
            KeyInfoFactory keyInfoFactory = xMLSignatureFactory.getKeyInfoFactory();
            X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
            ArrayList<XMLStructure> arrayList2 = new ArrayList<XMLStructure>();
            arrayList2.add(keyInfoFactory.newKeyValue(x509Certificate.getPublicKey()));
            Certificate[] certificateArray2 = null;
            if (!bl) {
                certificateArray2 = certificateArray;
            }
            if (certificateArray2 == null) {
                certificateArray2 = new Certificate[]{x509Certificate};
            }
            arrayList2.add(keyInfoFactory.newX509Data(Arrays.asList(certificateArray2)));
            XMLSignature xMLSignature = xMLSignatureFactory.newXMLSignature(xMLSignatureFactory.newSignedInfo(xMLSignatureFactory.newCanonicalizationMethod(string2, (C14NMethodParameterSpec)null), xMLSignatureFactory.newSignatureMethod(XMLConstants.SIGN_ALGOS_URI.get(this.algo), null), arrayList), keyInfoFactory.newKeyInfo(arrayList2, string7), null, string5, string6);
            DOMSignContext dOMSignContext = new DOMSignContext(privateKey, (Node)element.getOwnerDocument().getDocumentElement());
            dOMSignContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", string3);
            try {
                dOMSignContext.setURIDereferencer(new CustomUriDereferencer(CustomUriDereferencer.getDefaultDereferencer()));
            }
            catch (Exception exception) {
                LOGGER.warning("No se ha podido instalar un dereferenciador a medida, es posible que fallen las firmas de nodos concretos: " + exception);
            }
            xMLSignature.sign(dOMSignContext);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UnsupportedOperationException("Hay al menos un algoritmo no soportado: " + noSuchAlgorithmException, noSuchAlgorithmException);
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido realizar la contrafirma: " + exception, exception);
        }
    }

    @Override
    public AOTreeModel getSignersStructure(byte[] byArray, boolean bl) {
        int n;
        String string;
        Object object;
        Element element;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            this.doc = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
            element = this.doc.getDocumentElement();
            object = XmlDSigUtil.guessXmlDSigNamespacePrefix(element);
            String string2 = string = "".equals(object) ? "" : (String)object + ":";
            if (element.getNodeName().equals(string + SIGNATURE_STR)) {
                this.doc = AOXMLDSigSigner.insertarNodoAfirma(this.doc);
                element = this.doc.getDocumentElement();
            }
        }
        catch (Exception exception) {
            LOGGER.warning("Se ha producido un error al obtener la estructura de firmas: " + exception);
            return null;
        }
        object = new AOTreeNode("Datos");
        NodeList nodeList = element.getElementsByTagName(string + SIGNATURE_STR);
        NodeList nodeList2 = element.getElementsByTagName(string + SIGNATURE_VALUE);
        int n2 = nodeList.getLength();
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        AOTreeNode[] aOTreeNodeArray = new AOTreeNode[n2];
        for (n = 0; n < n2; ++n) {
            Element element2 = (Element)nodeList.item(n);
            stringArray[n] = element2.getAttribute(ID_IDENTIFIER);
            aOTreeNodeArray[n] = new AOTreeNode(bl ? Utils.getSimpleSignInfoNode(XADESNS, element2) : Utils.getStringInfoNode(element2));
            String string3 = ((Element)element2.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", REFERENCE_STR).item(0)).getAttribute("Type");
            stringArray2[n] = string3.equals(CSURI) ? Utils.getCounterSignerReferenceId(element2, nodeList2) : "";
        }
        for (n = 0; n < n2; ++n) {
            if (!"".equals(stringArray2[n])) continue;
            ((AOTreeNode)object).add(this.generaArbol(n, n2 - 1, aOTreeNodeArray, stringArray, stringArray2)[n]);
        }
        return new AOTreeModel((AOTreeNode)object);
    }

    private AOTreeNode[] generaArbol(int n, int n2, AOTreeNode[] aOTreeNodeArray, String[] stringArray, String[] stringArray2) {
        int n3 = stringArray.length;
        if (n < n3 && n2 > 0) {
            if (stringArray[n].equals(stringArray2[n2])) {
                this.generaArbol(n + 1, n2 - 1, aOTreeNodeArray, stringArray, stringArray2);
            }
            if (n < n2) {
                this.generaArbol(n, n2 - 1, aOTreeNodeArray, stringArray, stringArray2);
            }
            if (!stringArray[n].equals(stringArray2[n2])) {
                return aOTreeNodeArray;
            }
            this.generaArbol(n2, n3 - 1, aOTreeNodeArray, stringArray, stringArray2);
            aOTreeNodeArray[n].add(aOTreeNodeArray[n2]);
        }
        return aOTreeNodeArray;
    }

    @Override
    public boolean isSign(byte[] byArray) {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            Document document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
            Element element = document.getDocumentElement();
            ArrayList<Node> arrayList = new ArrayList<Node>();
            if (element.getNodeName().equals("ds:Signature")) {
                arrayList.add(element);
            }
            NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_STR);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                arrayList.add(nodeList.item(i));
            }
            if (arrayList.size() == 0) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidDataFile(byte[] byArray) {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        return true;
    }

    @Override
    public String getSignedName(String string, String string2) {
        return string + (string2 != null ? string2 : "") + ".xsig";
    }

    private static Document insertarNodoAfirma(Document document) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document2 = documentBuilderFactory.newDocumentBuilder().newDocument();
        Element element = document2.createElement(AFIRMA);
        element.appendChild(document2.adoptNode(document.getDocumentElement()));
        document2.appendChild(element);
        return document2;
    }

    @Override
    public AOSignInfo getSignInfo(byte[] byArray) throws AOException {
        if (byArray == null) {
            throw new IllegalArgumentException("No se han introducido datos para analizar");
        }
        if (!this.isSign(byArray)) {
            throw new AOInvalidFormatException("Los datos introducidos no se corresponden con un objeto de firma");
        }
        AOSignInfo aOSignInfo = new AOSignInfo("XMLDSig");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Element element = null;
        try {
            element = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray)).getDocumentElement();
        }
        catch (Exception exception) {
            LOGGER.warning("Error al analizar la firma: " + exception);
            element = null;
        }
        if (element != null) {
            if (AOXMLDSigSigner.isDetached(element)) {
                aOSignInfo.setVariant("XMLDSig Detached");
            } else if (AOXMLDSigSigner.isEnveloped(element)) {
                aOSignInfo.setVariant("XMLDSig Enveloped");
            } else if (AOXMLDSigSigner.isEnveloping(element)) {
                aOSignInfo.setVariant("XMLDSig Enveloping");
            }
        }
        return aOSignInfo;
    }

    private static void writeXML(Writer writer, Node node) {
        Document document = node.getOwnerDocument();
        DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)((Object)document.getImplementation());
        LSSerializer lSSerializer = dOMImplementationLS.createLSSerializer();
        lSSerializer.getDomConfig().setParameter("namespaces", Boolean.FALSE);
        DOMOutputImpl dOMOutputImpl = new DOMOutputImpl();
        dOMOutputImpl.setCharacterStream(writer);
        lSSerializer.write(node, dOMOutputImpl);
    }

    private static Element searchDataElement(String string, Element element) {
        Node node;
        String string2 = string.substring(string.startsWith("#") ? 1 : 0);
        Element element2 = null;
        Node node2 = node = element.getAttributes() != null ? element.getAttributes().getNamedItem(ID_IDENTIFIER) : null;
        if (node != null && string2.equals(node.getNodeValue())) {
            element2 = element;
        } else {
            NodeList nodeList = element.getChildNodes();
            for (int i = nodeList.getLength() - 1; i >= 0; --i) {
                Node node3 = node = nodeList.item(i).getAttributes() != null ? nodeList.item(i).getAttributes().getNamedItem(ID_IDENTIFIER) : null;
                if (node != null && string2.equals(node.getNodeValue())) {
                    element2 = (Element)nodeList.item(i);
                    break;
                }
                if (!SIGNATURE_STR.equals(nodeList.item(i).getLocalName())) continue;
                NodeList nodeList2 = nodeList.item(i).getChildNodes();
                for (int j = nodeList2.getLength() - 1; j >= 0; --j) {
                    Node node4 = node = nodeList2.item(j).getAttributes() != null ? nodeList2.item(j).getAttributes().getNamedItem(ID_IDENTIFIER) : null;
                    if (node == null || !string2.equals(node.getNodeValue())) continue;
                    element2 = (Element)nodeList2.item(j);
                    break;
                }
                if (element2 != null) break;
            }
        }
        return element2;
    }

    static {
        Utils.installXmlDSigProvider(true);
    }
}

