/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xadestri.client.asic;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.core.signers.asic.ASiCUtil;
import es.gob.afirma.signers.xadestri.client.AOXAdESTriPhaseSigner;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Properties;

public final class AOXAdESASiCSTriPhaseSigner
extends AOXAdESTriPhaseSigner {
    private static final String CRYPTO_OPERATION_SIGN = "sign";

    @Override
    public byte[] sign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        return AOXAdESASiCSTriPhaseSigner.triPhaseOperation("XAdES-ASiC-S", CRYPTO_OPERATION_SIGN, byArray, string, privateKey, certificateArray, properties);
    }

    @Override
    public byte[] cosign(byte[] byArray, byte[] byArray2, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) {
        throw new UnsupportedOperationException("No se soportan cofirmas trifasicas XAdES-ASiC-S");
    }

    @Override
    public byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) {
        throw new UnsupportedOperationException("No se soportan cofirmas trifasicas XAdES-ASiC-S");
    }

    @Override
    public byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) {
        throw new UnsupportedOperationException("No se soportan contrafirmas trifasicas XAdES-ASiC-S");
    }

    @Override
    public boolean isSign(byte[] byArray) {
        byte[] byArray2;
        try {
            byArray2 = ASiCUtil.getASiCSXMLSignature(byArray);
        }
        catch (Exception exception) {
            LOGGER.info("La firma proporcionada no es XAdES ASiC-S: " + exception);
            return false;
        }
        try {
            return super.isSign(ASiCUtil.getASiCSXMLSignature(byArray2));
        }
        catch (Exception exception) {
            LOGGER.warning("Error extrayendo la firma del contenedor ASiC: " + exception);
            return false;
        }
    }

    @Override
    public String getSignedName(String string, String string2) {
        return string + (string2 != null ? string2 : "") + ".asics";
    }
}

