/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xadestri.client;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.misc.http.UrlHttpManager;
import es.gob.afirma.core.misc.http.UrlHttpManagerFactory;
import es.gob.afirma.core.misc.http.UrlHttpMethod;
import es.gob.afirma.core.signers.AOPkcs1Signer;
import es.gob.afirma.core.signers.AOSignInfo;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.core.signers.TriphaseData;
import es.gob.afirma.core.signers.TriphaseDataSigner;
import es.gob.afirma.core.signers.TriphaseUtil;
import es.gob.afirma.core.util.tree.AOTreeModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AOXAdESTriPhaseSigner
implements AOSigner {
    protected static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    public static final String DSIGNNS = "http://www.w3.org/2000/09/xmldsig#";
    protected static final String XML_SIGNATURE_PREFIX = "ds";
    public static final String SIGNATURE_TAG = "Signature";
    protected static final String SIGNATURE_NODE_NAME = "ds:Signature";
    private static final String PROPERTY_NAME_SIGN_SERVER_URL = "serverUrl";
    private static final String OPERATION_PRESIGN = "pre";
    private static final String OPERATION_POSTSIGN = "post";
    private static final String CRYPTO_OPERATION_SIGN = "sign";
    private static final String CRYPTO_OPERATION_COSIGN = "cosign";
    private static final String CRYPTO_OPERATION_COUNTERSIGN = "countersign";
    private static final String PARAMETER_NAME_OPERATION = "op";
    private static final String PARAMETER_NAME_CRYPTO_OPERATION = "cop";
    private static final String HTTP_CGI = "?";
    private static final String HTTP_EQUALS = "=";
    private static final String HTTP_AND = "&";
    private static final String PARAMETER_NAME_DOCID = "doc";
    private static final String PARAMETER_NAME_ALGORITHM = "algo";
    private static final String PARAMETER_NAME_FORMAT = "format";
    private static final String PARAMETER_NAME_CERT = "cert";
    private static final String PARAMETER_NAME_EXTRA_PARAM = "params";
    private static final String PARAMETER_NAME_SESSION_DATA = "session";
    private static final String SUCCESS = "OK";
    private static final String COUNTERSIGN_TARGET_KEY = "target";
    public static final String COUNTERSIGN_TARGET_LEAFS = "leafs";
    public static final String COUNTERSIGN_TARGET_TREE = "tree";
    private final String signFormat;

    protected AOXAdESTriPhaseSigner(String string) {
        this.signFormat = string;
    }

    public AOXAdESTriPhaseSigner() {
        this("XAdES");
    }

    @Override
    public byte[] sign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        return AOXAdESTriPhaseSigner.triPhaseOperation(this.signFormat, CRYPTO_OPERATION_SIGN, byArray, string, privateKey, certificateArray, properties);
    }

    @Override
    public final byte[] getData(byte[] byArray) {
        throw new UnsupportedOperationException("No se soporta en firma trifasica");
    }

    @Override
    public byte[] cosign(byte[] byArray, byte[] byArray2, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        return AOXAdESTriPhaseSigner.triPhaseOperation(this.signFormat, CRYPTO_OPERATION_COSIGN, byArray2, string, privateKey, certificateArray, properties);
    }

    @Override
    public byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        return this.cosign(null, byArray, string, privateKey, certificateArray, properties);
    }

    @Override
    public byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        if (counterSignTarget == null) {
            throw new IllegalArgumentException("No se han indicado los nodos objetivo de la contrafirma");
        }
        if (counterSignTarget != CounterSignTarget.TREE && counterSignTarget != CounterSignTarget.LEAFS) {
            throw new UnsupportedOperationException("El objetivo indicado para la contrafirma no esta soportado: " + (Object)((Object)counterSignTarget));
        }
        Properties properties2 = properties != null ? properties : new Properties();
        properties2.setProperty(COUNTERSIGN_TARGET_KEY, counterSignTarget.toString());
        return AOXAdESTriPhaseSigner.triPhaseOperation(this.signFormat, CRYPTO_OPERATION_COUNTERSIGN, byArray, string, privateKey, certificateArray, properties2);
    }

    @Override
    public final AOTreeModel getSignersStructure(byte[] byArray, boolean bl) {
        throw new UnsupportedOperationException("No se soporta en firma trifasica");
    }

    @Override
    public boolean isSign(byte[] byArray) {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            Element element = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray)).getDocumentElement();
            ArrayList<Node> arrayList = new ArrayList<Node>();
            if (element.getNodeName().equals(SIGNATURE_NODE_NAME)) {
                arrayList.add(element);
            }
            NodeList nodeList = element.getElementsByTagNameNS(DSIGNNS, SIGNATURE_TAG);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                arrayList.add(nodeList.item(i));
            }
            if (arrayList.size() == 0) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidDataFile(byte[] byArray) {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        return true;
    }

    @Override
    public String getSignedName(String string, String string2) {
        return string + (string2 != null ? string2 : "") + ".xsig";
    }

    @Override
    public AOSignInfo getSignInfo(byte[] byArray) {
        throw new UnsupportedOperationException("No se soporta en firma trifasica");
    }

    protected static byte[] triPhaseOperation(String string, String string2, byte[] byArray, String string3, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        byte[] byArray2;
        CharSequence charSequence;
        byte[] byArray3;
        String string4;
        Object object;
        String string5;
        URL uRL;
        if (properties == null) {
            throw new IllegalArgumentException("Se necesitan parametros adicionales");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("Es necesario proporcionar la clave privada de firma");
        }
        if (certificateArray == null || certificateArray.length == 0) {
            throw new IllegalArgumentException("Es necesario proporcionar el certificado de firma");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("No se ha proporcionado el identificador de documento a firmar");
        }
        try {
            uRL = new URL(properties.getProperty(PROPERTY_NAME_SIGN_SERVER_URL));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("No se ha proporcionado una URL valida para el servidor de firma: " + properties.getProperty(PROPERTY_NAME_SIGN_SERVER_URL), exception);
        }
        Properties properties2 = (Properties)properties.clone();
        properties2.remove(PROPERTY_NAME_SIGN_SERVER_URL);
        String string6 = Base64.encode(byArray, true);
        UrlHttpManager urlHttpManager = UrlHttpManagerFactory.getInstalledManager();
        try {
            string5 = TriphaseUtil.prepareCertChainParam(certificateArray, properties2);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new AOException("Error decodificando la cadena de certificados: " + certificateEncodingException, certificateEncodingException);
        }
        try {
            object = new StringBuffer();
            ((StringBuffer)object).append(uRL).append(HTTP_CGI).append(PARAMETER_NAME_OPERATION).append(HTTP_EQUALS).append(OPERATION_PRESIGN).append(HTTP_AND).append(PARAMETER_NAME_CRYPTO_OPERATION).append(HTTP_EQUALS).append(string2).append(HTTP_AND).append(PARAMETER_NAME_FORMAT).append(HTTP_EQUALS).append(string).append(HTTP_AND).append(PARAMETER_NAME_ALGORITHM).append(HTTP_EQUALS).append(string3).append(HTTP_AND).append(PARAMETER_NAME_CERT).append(HTTP_EQUALS).append(string5).append(HTTP_AND).append(PARAMETER_NAME_DOCID).append(HTTP_EQUALS).append(string6);
            if (properties2.size() > 0) {
                ((StringBuffer)object).append(HTTP_AND).append(PARAMETER_NAME_EXTRA_PARAM).append(HTTP_EQUALS).append(AOUtil.properties2Base64(properties2));
            }
            string4 = ((StringBuffer)object).toString();
            LOGGER.info("Se llamara por POST a la siguiente URL:\n" + string4);
            byArray3 = urlHttpManager.readUrl(string4, UrlHttpMethod.POST);
            ((StringBuffer)object).setLength(0);
        }
        catch (IOException iOException) {
            throw new AOException("Error en la llamada de prefirma al servidor: " + iOException, iOException);
        }
        LOGGER.info("Tamano de la prefirma XAdES: " + byArray3.length + " octetos.");
        try {
            object = TriphaseData.parser(Base64.decode(byArray3, 0, byArray3.length, true));
        }
        catch (Exception exception) {
            LOGGER.severe("Error al analizar la prefirma enviada por el servidor: " + exception);
            throw new AOException("Error al analizar la prefirma enviada por el servidor: " + exception, exception);
        }
        string4 = Base64.encode(TriphaseDataSigner.doSign(new AOPkcs1Signer(), string3, privateKey, certificateArray, (TriphaseData)object).toString().getBytes(), true);
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(uRL).append(HTTP_CGI).append(PARAMETER_NAME_OPERATION).append(HTTP_EQUALS).append(OPERATION_POSTSIGN).append(HTTP_AND).append(PARAMETER_NAME_CRYPTO_OPERATION).append(HTTP_EQUALS).append(string2).append(HTTP_AND).append(PARAMETER_NAME_FORMAT).append(HTTP_EQUALS).append(string).append(HTTP_AND).append(PARAMETER_NAME_ALGORITHM).append(HTTP_EQUALS).append(string3).append(HTTP_AND).append(PARAMETER_NAME_CERT).append(HTTP_EQUALS).append(string5).append(HTTP_AND).append(PARAMETER_NAME_DOCID).append(HTTP_EQUALS).append(string6).append(HTTP_AND).append(PARAMETER_NAME_SESSION_DATA).append(HTTP_EQUALS).append(string4);
            if (properties2.size() > 0) {
                ((StringBuffer)charSequence).append(HTTP_AND).append(PARAMETER_NAME_EXTRA_PARAM).append(HTTP_EQUALS).append(AOUtil.properties2Base64(properties2));
            }
            byArray2 = urlHttpManager.readUrl(((StringBuffer)charSequence).toString(), UrlHttpMethod.POST);
        }
        catch (IOException iOException) {
            throw new AOException("Error en la llamada de postfirma al servidor: " + iOException, iOException);
        }
        charSequence = new String(byArray2).trim();
        if (!((String)charSequence).startsWith(SUCCESS)) {
            throw new AOException("La firma trifasica no ha finalizado correctamente: " + new String(byArray2));
        }
        try {
            return Base64.decode(((String)charSequence).substring("OK NEWID=".length()), true);
        }
        catch (IOException iOException) {
            LOGGER.warning("El resultado de NEWID del servidor no estaba en Base64: " + iOException);
            throw new AOException("El resultado devuelto por el servidor no es correcto: " + iOException, iOException);
        }
    }
}

