/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xades.asic;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOInvalidFormatException;
import es.gob.afirma.core.signers.AOSignInfo;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.core.signers.asic.ASiCUtil;
import es.gob.afirma.core.util.tree.AOTreeModel;
import es.gob.afirma.signers.xades.AOXAdESSigner;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Properties;
import java.util.logging.Logger;

public final class AOXAdESASiCSSigner
implements AOSigner {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    @Override
    public byte[] sign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        Properties properties2 = AOXAdESASiCSSigner.setASiCProperties(properties, byArray);
        properties2.put("keepKeyInfoUnsigned", Boolean.TRUE.toString());
        byte[] byArray2 = new AOXAdESSigner().sign(byArray, string, privateKey, certificateArray, properties2);
        return ASiCUtil.createSContainer(byArray2, byArray, "META-INF/signatures.xml", properties2.getProperty("asicsFilename"));
    }

    @Override
    public byte[] cosign(byte[] byArray, byte[] byArray2, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        return this.cosign(byArray2, string, privateKey, certificateArray, properties);
    }

    @Override
    public byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        byte[] byArray2 = ASiCUtil.getASiCSData(byArray);
        byte[] byArray3 = ASiCUtil.getASiCSXMLSignature(byArray);
        Properties properties2 = AOXAdESASiCSSigner.setASiCProperties(properties, byArray2);
        properties2.put("keepKeyInfoUnsigned", Boolean.TRUE.toString());
        byte[] byArray4 = new AOXAdESSigner().cosign(byArray2, byArray3, string, privateKey, certificateArray, properties2);
        return ASiCUtil.createSContainer(byArray4, byArray2, "META-INF/signatures.xml", ASiCUtil.getASiCSDataFilename(byArray));
    }

    @Override
    public byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        byte[] byArray2 = ASiCUtil.getASiCSData(byArray);
        byte[] byArray3 = ASiCUtil.getASiCSXMLSignature(byArray);
        Properties properties2 = AOXAdESASiCSSigner.setASiCProperties(properties, byArray2);
        properties2.put("keepKeyInfoUnsigned", Boolean.TRUE.toString());
        byte[] byArray4 = new AOXAdESSigner().countersign(byArray3, string, counterSignTarget, objectArray, privateKey, certificateArray, properties2);
        return ASiCUtil.createSContainer(byArray4, byArray2, "META-INF/signatures.xml", ASiCUtil.getASiCSDataFilename(byArray));
    }

    @Override
    public AOTreeModel getSignersStructure(byte[] byArray, boolean bl) throws AOInvalidFormatException, IOException {
        return new AOXAdESSigner().getSignersStructure(ASiCUtil.getASiCSXMLSignature(byArray), bl);
    }

    @Override
    public boolean isSign(byte[] byArray) throws IOException {
        byte[] byArray2;
        try {
            byArray2 = ASiCUtil.getASiCSXMLSignature(byArray);
        }
        catch (Exception exception) {
            return false;
        }
        return new AOXAdESSigner().isSign(ASiCUtil.getASiCSXMLSignature(byArray2));
    }

    @Override
    public boolean isValidDataFile(byte[] byArray) {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        return true;
    }

    @Override
    public String getSignedName(String string, String string2) {
        return string + (string2 != null ? string2 : "") + ".asics";
    }

    @Override
    public byte[] getData(byte[] byArray) throws IOException {
        return ASiCUtil.getASiCSData(byArray);
    }

    @Override
    public AOSignInfo getSignInfo(byte[] byArray) throws AOException, IOException {
        return new AOXAdESASiCSSigner().getSignInfo(ASiCUtil.getASiCSXMLSignature(byArray));
    }

    public static Properties setASiCProperties(Properties properties, byte[] byArray) {
        Properties properties2 = properties != null ? properties : new Properties();
        String string = properties2.getProperty("asicsFilename") != null ? properties2.getProperty("asicsFilename") : ASiCUtil.getASiCSDefaultDataFilename(byArray);
        properties2.put("useManifest", Boolean.TRUE.toString());
        properties2.put("addKeyInfoKeyName", Boolean.TRUE.toString());
        properties2.put("uri", string);
        properties2.put("format", "XAdES Externally Detached");
        properties2.put("RootXmlNodeName", "asic:XAdESSignatures");
        properties2.put("RootXmlNodeNamespace", "http://uri.etsi.org/02918/v1.2.1#");
        properties2.put("RootXmlNodeNamespacePrefix", "xmlns:asic");
        return properties2;
    }
}

