/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.signers.tsp.pkcs7.CMSTimestamper;
import es.gob.afirma.signers.tsp.pkcs7.TsaParams;
import es.gob.afirma.signers.xml.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nu.xom.canonical.Canonicalizer;
import nu.xom.converters.DOMConverter;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

final class XAdESTspUtil {
    private static final String DEFAULT_CANONICAL_ALGO = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static DocumentBuilderFactory D_FACTORY = DocumentBuilderFactory.newInstance();

    private XAdESTspUtil() {
    }

    static byte[] timestampXAdES(byte[] byArray, Properties properties) throws AOException {
        Element element;
        String string;
        Document document;
        TsaParams tsaParams;
        if (properties == null) {
            return byArray;
        }
        try {
            tsaParams = new TsaParams(properties);
        }
        catch (Exception exception) {
            tsaParams = null;
        }
        if (tsaParams == null) {
            return byArray;
        }
        try {
            document = D_FACTORY.newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            throw new AOException("No se puede analizar la firma para agregar el sello de tiempo: " + exception, exception);
        }
        NodeList nodeList = document.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "QualifyingProperties");
        if (nodeList.getLength() < 1) {
            throw new AOException("La firma no tiene 'QualifyingProperties', no se puede aplicar el sello de tiempo");
        }
        if (nodeList.getLength() > 1) {
            LOGGER.warning("El XML tiene mas de una firma, solo se sellara la primera");
        }
        Node node = nodeList.item(0);
        try {
            string = XAdESTspUtil.getBase64XAdESTimestampToken(XAdESTspUtil.getSigningTime(node), document, tsaParams);
        }
        catch (IOException | NoSuchAlgorithmException exception) {
            throw new AOException("Error obteniendo el sello de la TSA: " + exception, exception);
        }
        try {
            element = D_FACTORY.newDocumentBuilder().parse(new ByteArrayInputStream(("<xades:UnsignedProperties xmlns:xades=\"http://uri.etsi.org/01903/v1.3.2#\">\n <xades:UnsignedSignatureProperties>\n  <xades:SignatureTimeStamp>\n   <ds:CanonicalizationMethod xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" Algorithm=\"http://www.w3.org/TR/2001/REC-xml-c14n-20010315\"/>\n   <xades:EncapsulatedTimeStamp>\n" + string + "</xades:EncapsulatedTimeStamp>\n  </xades:SignatureTimeStamp>\n </xades:UnsignedSignatureProperties>\n</xades:UnsignedProperties>\n").getBytes(StandardCharsets.UTF_8))).getDocumentElement();
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            throw new AOException("Error creando el nodo XML de sello de tiempo: " + exception, exception);
        }
        Node node2 = document.importNode(element, true);
        node.appendChild(node2);
        return Utils.writeXML(document.getDocumentElement(), XAdESTspUtil.getOriginalXMLProperties(document, null), null, null);
    }

    static String getBase64XAdESTimestampToken(Calendar calendar, Document document, TsaParams tsaParams) throws NoSuchAlgorithmException, IOException, AOException {
        return Base64.encode(new CMSTimestamper(tsaParams).getTimeStampToken(XAdESTspUtil.getSignatureNodeDigest(document, tsaParams.getTsaHashAlgorithm()), tsaParams.getTsaHashAlgorithm(), calendar));
    }

    private static Calendar getSigningTime(Node node) {
        if (!(node instanceof Element)) {
            return new GregorianCalendar();
        }
        Element element = (Element)node;
        NodeList nodeList = element.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "SigningTime");
        if (nodeList.getLength() > 1) {
            return new GregorianCalendar();
        }
        Node node2 = nodeList.item(0);
        return DatatypeConverter.parseDateTime(node2.getTextContent());
    }

    private static final byte[] getSignatureNodeDigest(Document document, String string) throws NoSuchAlgorithmException, IOException {
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureValue");
        if (nodeList.getLength() < 1) {
            throw new IOException("El XML no tiene nodo de firma");
        }
        if (nodeList.getLength() > 1) {
            LOGGER.warning("El XML tiene mas de un nodo de firma, se tratara solo el primero");
        }
        return MessageDigest.getInstance(string).digest(XAdESTspUtil.canonicalizeXml((Element)nodeList.item(0), DEFAULT_CANONICAL_ALGO));
    }

    private static byte[] canonicalizeXml(Element element, String string) throws IOException {
        nu.xom.Element element2 = DOMConverter.convert(element);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Canonicalizer canonicalizer = new Canonicalizer((OutputStream)byteArrayOutputStream, string);
        canonicalizer.write(element2);
        return byteArrayOutputStream.toByteArray();
    }

    private static Map<String, String> getOriginalXMLProperties(Document document, String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (document != null) {
            DocumentType documentType;
            if (string != null) {
                hashtable.put("encoding", string);
            } else if (document.getXmlEncoding() != null) {
                hashtable.put("encoding", document.getXmlEncoding());
            }
            String string2 = document.getXmlVersion();
            if (string2 != null) {
                hashtable.put("version", string2);
            }
            if ((documentType = document.getDoctype()) != null && (string2 = documentType.getSystemId()) != null) {
                hashtable.put("doctype-system", string2);
            }
        }
        return hashtable;
    }

    static {
        try {
            D_FACTORY.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.warning("No se ha podido habilitar el proceso seguro en la factoria DOM: " + parserConfigurationException);
        }
        D_FACTORY.setValidating(false);
        D_FACTORY.setNamespaceAware(true);
    }
}

