/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xades;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOUnsupportedSignFormatException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.misc.MimeHelper;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.signers.xades.AOXMLAdvancedSignature;
import es.gob.afirma.signers.xades.XAdESCommonMetadataUtil;
import es.gob.afirma.signers.xades.XAdESUtil;
import es.gob.afirma.signers.xml.InvalidXMLException;
import es.gob.afirma.signers.xml.Utils;
import es.gob.afirma.signers.xml.XMLConstants;
import es.gob.afirma.signers.xml.dereference.CustomUriDereferencer;
import es.gob.afirma.signers.xml.style.CannotDereferenceException;
import es.gob.afirma.signers.xml.style.IsInnerlException;
import es.gob.afirma.signers.xml.style.ReferenceIsNotXmlException;
import es.gob.afirma.signers.xml.style.XmlStyle;
import es.uji.crypto.xades.jxades.security.xml.XAdES.CommitmentTypeIndication;
import es.uji.crypto.xades.jxades.security.xml.XAdES.DataObjectFormat;
import es.uji.crypto.xades.jxades.security.xml.XAdES.DataObjectFormatImpl;
import es.uji.crypto.xades.jxades.security.xml.XAdES.ObjectIdentifier;
import es.uji.crypto.xades.jxades.security.xml.XAdES.ObjectIdentifierImpl;
import es.uji.crypto.xades.jxades.security.xml.XAdES.XAdES;
import es.uji.crypto.xades.jxades.security.xml.XAdES.XAdES_EPES;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Logger;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class XAdESSigner {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String HTTP_PROTOCOL_PREFIX = "http://";
    private static final String HTTPS_PROTOCOL_PREFIX = "https://";
    static final String ID_IDENTIFIER = "Id";

    private XAdESSigner() {
    }

    public static byte[] sign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        Object object;
        Object object2;
        Object object3;
        Transform transform;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Element element;
        Object object8;
        String string2 = XMLConstants.SIGN_ALGOS_URI.get(string);
        if (string2 == null) {
            throw new UnsupportedOperationException("Los formatos de firma XML no soportan el algoritmo de firma '" + string + "'");
        }
        Properties properties2 = properties != null ? properties : new Properties();
        boolean bl = Boolean.parseBoolean(properties2.getProperty("avoidXpathExtraTransformsOnEnveloped", Boolean.FALSE.toString()));
        boolean bl2 = Boolean.parseBoolean(properties2.getProperty("includeOnlySignningCertificate", Boolean.FALSE.toString()));
        boolean bl3 = Boolean.parseBoolean(properties2.getProperty("useManifest", Boolean.FALSE.toString()));
        String string3 = properties2.getProperty("insertEnvelopedSignatureOnNodeByXPath");
        Object object9 = properties2.getProperty("nodeToSign");
        String string4 = properties2.getProperty("format", "XAdES Enveloping");
        String string5 = properties2.getProperty("referencesDigestMethod", "http://www.w3.org/2001/04/xmlenc#sha512");
        String string6 = properties2.getProperty("canonicalizationAlgorithm", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        if ("none".equalsIgnoreCase(string6)) {
            string6 = null;
        }
        String string7 = properties2.getProperty("xadesNamespace", "http://uri.etsi.org/01903/v1.3.2#");
        String string8 = properties2.getProperty("signedPropertiesTypeUrl", "http://uri.etsi.org/01903#SignedProperties");
        boolean bl4 = Boolean.parseBoolean(properties2.getProperty("ignoreStyleSheets", Boolean.FALSE.toString()));
        boolean bl5 = Boolean.parseBoolean(properties2.getProperty("avoidBase64Transforms", Boolean.FALSE.toString()));
        boolean bl6 = Boolean.parseBoolean(properties2.getProperty("headless", Boolean.TRUE.toString()));
        boolean bl7 = Boolean.parseBoolean(properties2.getProperty("addKeyInfoKeyValue", Boolean.TRUE.toString()));
        boolean bl8 = Boolean.parseBoolean(properties2.getProperty("addKeyInfoKeyName", Boolean.FALSE.toString()));
        boolean bl9 = Boolean.parseBoolean(properties2.getProperty("addKeyInfoX509IssuerSerial", Boolean.FALSE.toString()));
        String string9 = properties2.getProperty("precalculatedHashAlgorithm");
        boolean bl10 = Boolean.parseBoolean(properties2.getProperty("facturaeSign", Boolean.FALSE.toString()));
        String string10 = properties2.getProperty("outputXmlEncoding");
        Object object10 = properties2.getProperty("mimeType");
        String string11 = properties2.getProperty("encoding");
        if ("base64".equalsIgnoreCase(string11)) {
            string11 = "http://www.w3.org/2000/09/xmldsig#base64";
        }
        if (string11 != null && !string11.isEmpty()) {
            try {
                new URI(string11);
            }
            catch (Exception exception) {
                throw new AOException("La codificacion indicada en 'encoding' debe ser una URI: " + exception, exception);
            }
        }
        boolean bl11 = Boolean.parseBoolean(properties2.getProperty("keepKeyInfoUnsigned", Boolean.FALSE.toString()));
        if (string4.equals("XAdES Enveloped") && bl3) {
            throw new AOUnsupportedSignFormatException("El formato Enveloped es incompatible con el uso de estructuras Manifest");
        }
        URI uRI = null;
        try {
            uRI = properties2.getProperty("uri") != null ? AOUtil.createURI(properties2.getProperty("uri")) : null;
        }
        catch (Exception exception) {
            LOGGER.warning("Se ha pasado una URI invalida como referencia a los datos a firmar: " + exception);
        }
        Utils.checkIllegalParams(string4, properties2.getProperty("mode", "implicit"), uRI, string9, true);
        if (!(byArray != null && byArray.length != 0 || string4.equals("XAdES Externally Detached") && uRI != null)) {
            throw new AOException("No se han podido leer los datos a firmar");
        }
        Hashtable<String, String> hashtable = new Hashtable();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Object object11 = null;
        String string12 = "CONTENT-" + UUID.randomUUID().toString();
        String string13 = "STYLE-" + UUID.randomUUID().toString();
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = false;
        XmlStyle xmlStyle = new XmlStyle();
        Element element2 = null;
        try {
            object8 = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
            if (!bl4) {
                try {
                    xmlStyle = new XmlStyle(byArray, bl6);
                }
                catch (IsInnerlException isInnerlException) {
                    LOGGER.info("La hoja de estilo esta referenciada internamente, por lo que no se necesita dereferenciar: " + isInnerlException);
                }
                catch (ReferenceIsNotXmlException referenceIsNotXmlException) {
                    LOGGER.warning("La hoja de estilo referenciada no es XML o no se ha dereferenciado apropiadamente: " + referenceIsNotXmlException);
                }
                catch (CannotDereferenceException cannotDereferenceException) {
                    LOGGER.warning("La hoja de estilo no ha podido dereferenciar, probablemente sea un enlace relativo local: " + cannotDereferenceException);
                }
                catch (Exception exception) {
                    LOGGER.severe("Error intentando dereferenciar la hoja de estilo: " + exception);
                }
            }
            if (object10 == null || "application/octet-stream".equals(object10)) {
                object10 = "text/xml";
            }
            hashtable = XAdESUtil.getOriginalXMLProperties((Document)object8, string10);
            if (string4.equals("XAdES Detached")) {
                if (object9 != null) {
                    element = CustomUriDereferencer.getElementById((Document)object8, (String)object9);
                    if (!CustomUriDereferencer.getElementById((Document)object8, (String)object9).isSameNode(object8.getDocumentElement())) {
                        object11 = object8;
                        bl14 = true;
                        element2 = (Element)element.getParentNode();
                    }
                } else {
                    element = object8.createElement("CONTENT");
                    element.setAttributeNS(null, ID_IDENTIFIER, string12);
                    element.setAttributeNS(null, "MimeType", (String)object10);
                    if (string11 != null && !"".equals(string11)) {
                        element.setAttributeNS(null, "Encoding", string11);
                    }
                    element.appendChild(object8.getDocumentElement());
                }
                if (xmlStyle.getStyleElement() != null) {
                    try {
                        object7 = object8.createElement("STYLE");
                        object7.setAttributeNS(null, ID_IDENTIFIER, string13);
                        if (xmlStyle.getStyleType() != null) {
                            object7.setAttributeNS(null, "MimeType", xmlStyle.getStyleType());
                        }
                        object7.setAttributeNS(null, "Encoding", xmlStyle.getStyleEncoding());
                        object7.appendChild(object8.adoptNode(xmlStyle.getStyleElement().cloneNode(true)));
                        xmlStyle.setStyleElement((Element)object7);
                    }
                    catch (Exception exception) {
                        LOGGER.warning("No ha sido posible crear el elemento DOM para incluir la hoja de estilo del XML como Internally Detached: " + exception);
                        xmlStyle.setStyleElement(null);
                    }
                }
            } else {
                element = object8.getDocumentElement();
            }
        }
        catch (Exception exception) {
            if ("XAdES Enveloped".equals(string4) || object9 != null) {
                throw new InvalidXMLException("Las firmas XAdES Enveloped solo pueden realizarse sobre datos XML", exception);
            }
            if ("XAdES Detached".equals(string4) || "XAdES Enveloping".equals(string4)) {
                LOGGER.info("El documento no es un XML valido. Se convertira a Base64: " + exception);
                try {
                    object7 = documentBuilderFactory.newDocumentBuilder().newDocument();
                    element = object7.createElement("CONTENT");
                    uRI = null;
                    element.setAttributeNS(null, ID_IDENTIFIER, string12);
                    if (Base64.isBase64(byArray) && "http://www.w3.org/2000/09/xmldsig#base64".equals(string11)) {
                        LOGGER.info("El documento se ha indicado como Base64, se insertara como tal en el XML");
                        object6 = Base64.decode(new String(byArray));
                        if (object10 == null && (object5 = ((MimeHelper)(object4 = new MimeHelper((byte[])object6))).getMimeType()) != null) {
                            object10 = object5;
                        }
                        element.setAttributeNS(null, "MimeType", (String)(object10 != null ? object10 : "application/octet-stream"));
                        element.setTextContent(Base64.encode((byte[])object6));
                    } else {
                        if ("http://www.w3.org/2000/09/xmldsig#base64".equals(string11)) {
                            LOGGER.info("El documento se ha indicado como Base64, pero no es un Base64 valido. Se convertira a Base64 antes de insertarlo en el XML y se declarara la transformacion");
                        } else {
                            LOGGER.info("El documento se considera binario, se convertira a Base64 antes de insertarlo en el XML y se declarara la transformacion");
                        }
                        if (object10 == null && (object4 = ((MimeHelper)(object6 = new MimeHelper(byArray))).getMimeType()) != null) {
                            object10 = object4;
                        }
                        element.setAttributeNS(null, "MimeType", (String)(object10 != null ? object10 : "application/octet-stream"));
                        element.setTextContent(Base64.encode(byArray));
                        bl13 = true;
                    }
                    bl12 = true;
                    string11 = "http://www.w3.org/2000/09/xmldsig#base64";
                    element.setAttributeNS(null, "Encoding", string11);
                }
                catch (Exception exception2) {
                    throw new AOException("Error al convertir los datos a Base64", exception2);
                }
            }
            element = null;
        }
        object8 = "#" + (String)(object9 != null ? object9 : string12);
        object7 = "#" + string13;
        if (object11 == null) {
            try {
                object11 = documentBuilderFactory.newDocumentBuilder().newDocument();
                if (string4.equals("XAdES Enveloped")) {
                    object11.appendChild(object11.adoptNode(element));
                } else {
                    object6 = XAdESUtil.getRootElement((Document)object11, properties2);
                    object11.appendChild((Node)object6);
                }
            }
            catch (Exception exception) {
                throw new AOException("Error al crear la firma en formato " + string4 + ": " + exception, exception);
            }
        }
        object6 = new ArrayList();
        object4 = Utils.getDOMFactory();
        try {
            object5 = ((XMLSignatureFactory)object4).newDigestMethod(string5, null);
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido obtener un generador de huellas digitales para el algoritmo '" + string5 + "'", exception);
        }
        String string14 = "Reference-" + UUID.randomUUID().toString();
        String string15 = "StyleReference-" + UUID.randomUUID().toString();
        ArrayList<Transform> arrayList = new ArrayList<Transform>();
        Utils.addCustomTransforms(arrayList, properties2, "ds");
        if (string6 != null) {
            try {
                transform = ((XMLSignatureFactory)object4).newTransform(string6, (TransformParameterSpec)null);
            }
            catch (Exception exception) {
                throw new AOException("No se ha posido crear el canonizador para el algoritmo indicado (" + string6 + "): " + exception, exception);
            }
        } else {
            transform = null;
        }
        if (!bl12) {
            if (!bl10 && transform != null) {
                try {
                    arrayList.add(transform);
                }
                catch (Exception exception) {
                    throw new AOException("No se puede encontrar el algoritmo de canonicalizacion: " + exception, exception);
                }
            }
        } else if (bl13 && !bl5) {
            try {
                arrayList.add(((XMLSignatureFactory)object4).newTransform("http://www.w3.org/2000/09/xmldsig#base64", (TransformParameterSpec)null));
            }
            catch (Exception exception) {
                throw new AOException("No se puede encontrar el algoritmo transformacion Base64: " + exception, exception);
            }
        }
        XMLObject xMLObject = null;
        XMLObject xMLObject2 = null;
        if (string4.equals("XAdES Enveloping")) {
            try {
                object3 = new ArrayList<DOMStructure>(1);
                if (element == null) {
                    throw new IllegalStateException("El elemento (nodo) de datos no puede ser nulo en este punto");
                }
                object3.add(new DOMStructure(bl12 ? element.getFirstChild() : element));
                object2 = "Object-" + UUID.randomUUID().toString();
                xMLObject = ((XMLSignatureFactory)object4).newXMLObject((List<? extends XMLStructure>)object3, (String)object2, (String)(object10 != null ? object10 : "application/octet-stream"), string11);
                object6.add(((XMLSignatureFactory)object4).newReference("#" + (String)(object9 != null ? object9 : object2), (DigestMethod)object5, arrayList, "http://www.w3.org/2000/09/xmldsig#Object", string14));
                if (xmlStyle.getStyleElement() != null) {
                    object = "StyleObject-" + UUID.randomUUID().toString();
                    xMLObject2 = ((XMLSignatureFactory)object4).newXMLObject(Collections.singletonList(new DOMStructure(xmlStyle.getStyleElement())), (String)object, xmlStyle.getStyleType(), xmlStyle.getStyleEncoding());
                    object6.add(((XMLSignatureFactory)object4).newReference("#" + (String)object, (DigestMethod)object5, Collections.singletonList(transform), "http://www.w3.org/2000/09/xmldsig#Object", string15));
                }
            }
            catch (Exception exception) {
                throw new AOException("Error al generar la firma en formato enveloping", exception);
            }
            if (xmlStyle.getStyleHref() != null && xmlStyle.getStyleElement() == null && (xmlStyle.getStyleHref().startsWith(HTTP_PROTOCOL_PREFIX) || xmlStyle.getStyleHref().startsWith(HTTPS_PROTOCOL_PREFIX))) {
                try {
                    object6.add(((XMLSignatureFactory)object4).newReference(xmlStyle.getStyleHref(), (DigestMethod)object5, transform != null ? Collections.singletonList(transform) : new ArrayList(0), "http://www.w3.org/2000/09/xmldsig#Object", string15));
                }
                catch (Exception exception) {
                    LOGGER.severe("No ha sido posible anadir la referencia a la hoja de estilo del XML para Enveloping en modo Externally Detached, esta no se firmara: " + exception);
                }
            }
        } else if (string4.equals("XAdES Detached")) {
            try {
                if (element != null) {
                    if (!bl14) {
                        object11.getDocumentElement().appendChild(object11.adoptNode(element));
                    }
                    object6.add(((XMLSignatureFactory)object4).newReference((String)object8, (DigestMethod)object5, arrayList, "http://www.w3.org/2000/09/xmldsig#Object", string14));
                }
                if (xmlStyle.getStyleElement() != null) {
                    object11.getDocumentElement().appendChild(object11.adoptNode(xmlStyle.getStyleElement()));
                    object6.add(((XMLSignatureFactory)object4).newReference((String)object7, (DigestMethod)object5, Collections.singletonList(transform), "http://www.w3.org/2000/09/xmldsig#Object", string15));
                }
            }
            catch (Exception exception) {
                throw new AOException("Error al generar la firma en formato detached: " + exception, exception);
            }
            if (xmlStyle.getStyleHref() != null && xmlStyle.getStyleElement() == null && (xmlStyle.getStyleHref().startsWith(HTTP_PROTOCOL_PREFIX) || xmlStyle.getStyleHref().startsWith(HTTPS_PROTOCOL_PREFIX))) {
                try {
                    object6.add(((XMLSignatureFactory)object4).newReference(xmlStyle.getStyleHref(), (DigestMethod)object5, transform != null ? Collections.singletonList(transform) : new ArrayList(0), "http://www.w3.org/2000/09/xmldsig#Object", string15));
                }
                catch (Exception exception) {
                    LOGGER.severe("No ha sido posible anadir la referencia a la hoja remota de estilo del XML para firma Detached, esta no se firmara: " + exception);
                }
            }
        } else if (string4.equals("XAdES Externally Detached")) {
            object3 = null;
            if (string9 != null) {
                try {
                    object2 = ((XMLSignatureFactory)object4).newDigestMethod(XAdESUtil.getDigestMethodByCommonName(string9), null);
                }
                catch (Exception exception) {
                    throw new AOException("No se ha podido crear el metodo de huella digital para la referencia Externally Detached: " + exception, exception);
                }
                object3 = ((XMLSignatureFactory)object4).newReference(uRI != null ? uRI.toString() : "", (DigestMethod)object2, null, "http://www.w3.org/2000/09/xmldsig#Object", string14, byArray);
            } else {
                if (uRI != null && uRI.getScheme().equals("file")) {
                    try {
                        object3 = ((XMLSignatureFactory)object4).newReference(properties2.getProperty("uri"), (DigestMethod)object5, null, "http://www.w3.org/2000/09/xmldsig#Object", string14, MessageDigest.getInstance(AOSignConstants.getDigestAlgorithmName(string5)).digest(byArray != null ? byArray : AOUtil.getDataFromInputStream(AOUtil.loadFile(uRI))));
                    }
                    catch (Exception exception) {
                        throw new AOException("No se ha podido crear la referencia XML a partir de la URI local (" + uRI.toASCIIString() + "): " + exception, exception);
                    }
                }
                if (uRI != null) {
                    try {
                        object3 = ((XMLSignatureFactory)object4).newReference(uRI.toASCIIString(), (DigestMethod)object5);
                    }
                    catch (Exception exception) {
                        throw new AOException("No se ha podido crear la referencia Externally Detached, probablemente por no obtenerse el metodo de digest: " + exception, exception);
                    }
                }
            }
            if (object3 == null) {
                throw new AOException("Error al generar la firma Externally Detached, no se ha podido crear la referencia externa");
            }
            object6.add(object3);
            if (xmlStyle.getStyleHref() != null && xmlStyle.getStyleElement() == null) {
                if (xmlStyle.getStyleHref().startsWith(HTTP_PROTOCOL_PREFIX) || xmlStyle.getStyleHref().startsWith(HTTPS_PROTOCOL_PREFIX)) {
                    try {
                        object6.add(((XMLSignatureFactory)object4).newReference(xmlStyle.getStyleHref(), (DigestMethod)object5, transform != null ? Collections.singletonList(transform) : new ArrayList(0), "http://www.w3.org/2000/09/xmldsig#Object", string15));
                    }
                    catch (Exception exception) {
                        LOGGER.severe("No ha sido posible anadir la referencia a la hoja de estilo remota del XML para firma Externally Detached, esta no se firmara: " + exception);
                    }
                } else {
                    LOGGER.warning("Se necesita una referencia externa HTTP o HTTPS a la hoja de estilo para referenciarla en firmas XML Externally Detached");
                }
            }
        } else if (string4.equals("XAdES Enveloped")) {
            try {
                arrayList.add(((XMLSignatureFactory)object4).newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
                if (object9 == null && (object3 = object11.getDocumentElement().getAttribute(ID_IDENTIFIER)) != null && !((String)object3).isEmpty()) {
                    object9 = object3;
                }
                if (!bl10 && !bl) {
                    arrayList.add(((XMLSignatureFactory)object4).newTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", new XPathFilterParameterSpec("not(ancestor-or-self::ds:Signature)", Collections.singletonMap("ds", "http://www.w3.org/2000/09/xmldsig#"))));
                }
                object6.add(((XMLSignatureFactory)object4).newReference(object9 != null ? "#" + (String)object9 : "", (DigestMethod)object5, arrayList, "http://www.w3.org/2000/09/xmldsig#Object", string14));
            }
            catch (Exception exception) {
                throw new AOException("Error al generar la firma en formato enveloped: " + exception, exception);
            }
            if (xmlStyle.getStyleHref() != null && xmlStyle.getStyleElement() == null && (xmlStyle.getStyleHref().startsWith(HTTP_PROTOCOL_PREFIX) || xmlStyle.getStyleHref().startsWith(HTTPS_PROTOCOL_PREFIX))) {
                try {
                    object6.add(((XMLSignatureFactory)object4).newReference(xmlStyle.getStyleHref(), (DigestMethod)object5, transform != null ? Collections.singletonList(transform) : new ArrayList(0), "http://www.w3.org/2000/09/xmldsig#Object", string15));
                }
                catch (Exception exception) {
                    LOGGER.severe("No ha sido posible anadir la referencia a la hoja de estilo remota del XML para firma Enveloped, esta no se firmara: " + exception);
                }
            }
        }
        if ("XAdES Enveloped".equals(string4)) {
            if (string3 != null) {
                element2 = XAdESUtil.getFirstElmentFromXPath(string3, object11.getDocumentElement());
            } else if (object9 != null) {
                element2 = CustomUriDereferencer.getElementById((Document)object11, (String)object9);
            }
        }
        object3 = (XAdES_EPES)XAdES.newInstance(XAdES.EPES, string7, "xades", "ds", string5, (Document)object11, element2 != null ? element2 : object11.getDocumentElement());
        object3.setSigningCertificate((X509Certificate)certificateArray[0]);
        XAdESCommonMetadataUtil.addCommonMetadata((XAdES_EPES)object3, properties2);
        object2 = properties2.getProperty("contentTypeOid");
        if (object2 == null && object10 != null) {
            try {
                object2 = MimeHelper.transformMimeTypeToOid((String)object10);
            }
            catch (Exception exception) {
                LOGGER.warning("Error en la obtencion del OID del tipo de datos a partir del MimeType: " + exception);
            }
            if (!"application/octet-stream".equals(object10) && "1.2.840.113549.1.7.1".equals(object2)) {
                object2 = null;
            }
        }
        object = object2 != null ? new ObjectIdentifierImpl("OIDAsURN", (((String)object2).startsWith("urn:oid:") ? "" : "urn:oid:") + (String)object2, null, new ArrayList<String>(0)) : null;
        ArrayList<DataObjectFormat> arrayList2 = new ArrayList<DataObjectFormat>();
        DataObjectFormatImpl dataObjectFormatImpl = new DataObjectFormatImpl(null, (ObjectIdentifier)object, (String)(object10 != null ? object10 : "application/octet-stream"), string11, "#" + string14);
        arrayList2.add(dataObjectFormatImpl);
        object3.setDataObjectFormats(arrayList2);
        List<CommitmentTypeIndication> list = XAdESUtil.parseCommitmentTypeIndications(properties2, string14);
        if (list != null && list.size() > 0) {
            object3.setCommitmentTypeIndications(list);
        }
        AOXMLAdvancedSignature aOXMLAdvancedSignature = XAdESUtil.getXmlAdvancedSignature((XAdES_EPES)object3, string8, string5, string6 != null ? string6 : "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        if (string4.equals("XAdES Enveloping")) {
            aOXMLAdvancedSignature.addXMLObject(xMLObject);
            if (xMLObject2 != null) {
                aOXMLAdvancedSignature.addXMLObject(xMLObject2);
            }
        }
        if (string4.equals("XAdES Enveloped") && xmlStyle.getStyleElement() != null) {
            aOXMLAdvancedSignature.addStyleSheetEnvelopingOntoSignature(xmlStyle, string13);
            try {
                object6.add(((XMLSignatureFactory)object4).newReference((String)object7, (DigestMethod)object5, transform != null ? Collections.singletonList(transform) : new ArrayList(0), "http://www.w3.org/2000/09/xmldsig#Object", string15));
            }
            catch (Exception exception) {
                LOGGER.severe("No se ha podido anadir una referencia a la hoja de estilo, esta se incluira dentro de la firma, pero no estara firmada: " + exception);
            }
        }
        if (bl3) {
            XAdESUtil.createManifest((List<Reference>)object6, (XMLSignatureFactory)object4, aOXMLAdvancedSignature, (DigestMethod)object5, transform, string14);
        }
        try {
            aOXMLAdvancedSignature.sign(bl2 ? Arrays.asList(certificateArray[0]) : Arrays.asList(certificateArray), privateKey, string2, (List<?>)object6, "Signature-" + UUID.randomUUID().toString(), bl7, bl8, bl9, bl11);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UnsupportedOperationException("Los formatos de firma XML no soportan el algoritmo de firma '" + string + "':" + noSuchAlgorithmException, noSuchAlgorithmException);
        }
        catch (Exception exception) {
            if ("es.gob.jmulticard.CancelledOperationException".equals(exception.getClass().getName())) {
                throw new AOCancelledOperationException();
            }
            throw new AOException("Error al generar la firma XAdES: " + exception, exception);
        }
        if (string4.equals("XAdES Enveloping")) {
            try {
                if (object11.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").getLength() == 1) {
                    Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
                    document.appendChild(document.adoptNode(object11.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0)));
                    object11 = document;
                }
            }
            catch (Exception exception) {
                LOGGER.info("No se ha eliminado el nodo padre '<AFIRMA>': " + exception);
            }
        }
        return Utils.writeXML(object11.getDocumentElement(), hashtable, string4.equals("XAdES Enveloped") ? xmlStyle.getStyleHref() : null, string4.equals("XAdES Enveloped") ? xmlStyle.getStyleType() : null);
    }
}

