/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOUnsupportedSignFormatException;
import es.gob.afirma.core.misc.MimeHelper;
import es.gob.afirma.signers.xades.AOXAdESSigner;
import es.gob.afirma.signers.xades.AOXMLAdvancedSignature;
import es.gob.afirma.signers.xades.XAdESCommonMetadataUtil;
import es.gob.afirma.signers.xades.XAdESUtil;
import es.gob.afirma.signers.xml.Utils;
import es.gob.afirma.signers.xml.XMLConstants;
import es.uji.crypto.xades.jxades.security.xml.XAdES.DataObjectFormat;
import es.uji.crypto.xades.jxades.security.xml.XAdES.DataObjectFormatImpl;
import es.uji.crypto.xades.jxades.security.xml.XAdES.ObjectIdentifierImpl;
import es.uji.crypto.xades.jxades.security.xml.XAdES.XAdES;
import es.uji.crypto.xades.jxades.security.xml.XAdES.XAdES_EPES;
import es.uji.crypto.xades.jxades.security.xml.XAdES.XMLAdvancedSignature;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XAdESCoSigner {
    private static final String ID_IDENTIFIER = "Id";

    private XAdESCoSigner() {
    }

    public static byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        Object object;
        Object object2;
        Object object3;
        DigestMethod digestMethod;
        Element element;
        Document document;
        String string2 = XMLConstants.SIGN_ALGOS_URI.get(string);
        if (string2 == null) {
            throw new UnsupportedOperationException("Los formatos de firma XML no soportan el algoritmo de firma '" + string + "'");
        }
        Properties properties2 = properties != null ? properties : new Properties();
        String string3 = properties2.getProperty("referencesDigestMethod", "http://www.w3.org/2001/04/xmlenc#sha512");
        String string4 = properties2.getProperty("canonicalizationAlgorithm", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        String string5 = properties2.getProperty("xadesNamespace", "http://uri.etsi.org/01903/v1.3.2#");
        String string6 = properties2.getProperty("signedPropertiesTypeUrl", "http://uri.etsi.org/01903#SignedProperties");
        boolean bl = Boolean.parseBoolean(properties2.getProperty("addKeyInfoKeyValue", Boolean.TRUE.toString()));
        boolean bl2 = Boolean.parseBoolean(properties2.getProperty("addKeyInfoKeyName", Boolean.FALSE.toString()));
        boolean bl3 = Boolean.parseBoolean(properties2.getProperty("addKeyInfoX509IssuerSerial", Boolean.FALSE.toString()));
        boolean bl4 = Boolean.parseBoolean(properties2.getProperty("useManifest", Boolean.FALSE.toString()));
        boolean bl5 = Boolean.parseBoolean(properties2.getProperty("keepKeyInfoUnsigned", Boolean.FALSE.toString()));
        String string7 = properties2.getProperty("outputXmlEncoding");
        String string8 = properties2.getProperty("mimeType");
        String string9 = properties2.getProperty("encoding");
        if ("base64".equalsIgnoreCase(string9)) {
            string9 = "http://www.w3.org/2000/09/xmldsig#base64";
        }
        if (string9 != null && !string9.isEmpty()) {
            try {
                new URI(string9);
            }
            catch (Exception exception) {
                throw new AOException("La codificacion indicada en 'encoding' debe ser una URI: " + exception, exception);
            }
        }
        String string10 = properties2.getProperty("contentTypeOid");
        ObjectIdentifierImpl objectIdentifierImpl = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
            element = document.getDocumentElement();
            if (element.getNodeName().equals("ds:Signature")) {
                document = AOXAdESSigner.insertarNodoAfirma(document);
                element = document.getDocumentElement();
            }
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido leer el documento XML de firmas", exception);
        }
        Map<String, String> map = XAdESUtil.getOriginalXMLProperties(document, string7);
        XMLSignatureFactory xMLSignatureFactory = Utils.getDOMFactory();
        try {
            digestMethod = xMLSignatureFactory.newDigestMethod(string3, null);
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido obtener un generador de huellas digitales para el algoritmo '" + string3 + "'", exception);
        }
        XMLObject xMLObject = null;
        boolean bl6 = false;
        ArrayList<Reference> arrayList = new ArrayList<Reference>();
        NodeList nodeList = ((Element)document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0)).getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Reference");
        String string11 = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            object3 = node.getAttributes();
            if (i != 0 && (object3.getNamedItem(ID_IDENTIFIER) == null || !object3.getNamedItem(ID_IDENTIFIER).getNodeValue().startsWith("StyleReference-"))) continue;
            try {
                object2 = Utils.getObjectReferenceTransforms(node, "ds");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new AOException("Se ha declarado una transformacion personalizada de un tipo no soportado", noSuchAlgorithmException);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new AOException("Se han especificado parametros erroneos para una transformacion personalizada", invalidAlgorithmParameterException);
            }
            string11 = object3.getNamedItem(ID_IDENTIFIER) != null && object3.getNamedItem(ID_IDENTIFIER).getNodeValue().startsWith("StyleReference-") ? "StyleReference-" + UUID.randomUUID().toString() : "Reference-" + UUID.randomUUID().toString();
            object = ((Element)node).getAttribute("URI");
            if ("".equals(object)) {
                if (bl4) {
                    throw new AOUnsupportedSignFormatException("El formato Enveloped es incompatible con el uso de estructuras Manifest");
                }
                if (string8 == null) {
                    string8 = "text/xml";
                }
                arrayList.add(xMLSignatureFactory.newReference((String)object, digestMethod, (List<? extends Transform>)object2, "http://www.w3.org/2000/09/xmldsig#Object", string11));
            } else {
                Object object4;
                int n;
                NodeList nodeList2;
                Node node2;
                String string12 = ((String)object).substring(((String)object).startsWith("#") ? 1 : 0);
                Element element2 = null;
                Element element3 = document.getDocumentElement();
                Node node3 = node2 = element3.getAttributes() != null ? element3.getAttributes().getNamedItem(ID_IDENTIFIER) : null;
                if (node2 != null && string12.equals(node2.getNodeValue())) {
                    element2 = element3;
                } else {
                    nodeList2 = element3.getChildNodes();
                    for (n = nodeList2.getLength() - 1; n >= 0; --n) {
                        Node node4 = node2 = nodeList2.item(n).getAttributes() != null ? nodeList2.item(n).getAttributes().getNamedItem(ID_IDENTIFIER) : null;
                        if (node2 != null && string12.equals(node2.getNodeValue())) {
                            element2 = (Element)nodeList2.item(n);
                            break;
                        }
                        if (!"Signature".equals(nodeList2.item(n).getLocalName())) continue;
                        object4 = nodeList2.item(n).getChildNodes();
                        for (int j = object4.getLength() - 1; j >= 0; --j) {
                            Node node5 = node2 = object4.item(j).getAttributes() != null ? object4.item(j).getAttributes().getNamedItem(ID_IDENTIFIER) : null;
                            if (node2 == null || !string12.equals(node2.getNodeValue())) continue;
                            element2 = (Element)object4.item(j);
                            break;
                        }
                        if (element2 != null) break;
                    }
                }
                if (element2 != null) {
                    if (string8 == null) {
                        string8 = element2.getAttribute("MimeType");
                    }
                    if (string9 == null) {
                        string9 = element2.getAttribute("Encoding");
                    }
                }
                nodeList2 = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0).getChildNodes();
                for (n = 0; n < nodeList2.getLength(); ++n) {
                    Node node6;
                    object4 = nodeList2.item(n);
                    NamedNodeMap namedNodeMap = object4.getAttributes();
                    if (namedNodeMap == null || (node6 = namedNodeMap.getNamedItem(ID_IDENTIFIER)) == null || !string12.equals(node6.getNodeValue())) continue;
                    bl6 = true;
                }
                if (bl6 && element2 != null) {
                    ArrayList<DOMStructure> arrayList2 = new ArrayList<DOMStructure>(1);
                    arrayList2.add(new DOMStructure(element2.getFirstChild().cloneNode(true)));
                    object4 = "Object-" + UUID.randomUUID().toString();
                    xMLObject = xMLSignatureFactory.newXMLObject(arrayList2, (String)object4, string8, string9);
                    arrayList.add(xMLSignatureFactory.newReference("#" + (String)object4, digestMethod, (List<? extends Transform>)object2, "http://www.w3.org/2000/09/xmldsig#Object", string11));
                } else {
                    arrayList.add(xMLSignatureFactory.newReference(((Element)node).getAttribute("URI"), digestMethod, (List<? extends Transform>)object2, "http://www.w3.org/2000/09/xmldsig#Object", string11));
                }
            }
            if (string10 == null && string8 != null) {
                try {
                    string10 = MimeHelper.transformMimeTypeToOid(string8);
                }
                catch (IOException iOException) {
                    AOXAdESSigner.LOGGER.warning("Error en la obtencion del OID del tipo de datos a partir del MimeType: " + iOException);
                }
            }
            if (string10 == null) continue;
            objectIdentifierImpl = new ObjectIdentifierImpl("OIDAsURN", (string10.startsWith("urn:oid:") ? "" : "urn:oid:") + string10, null, new ArrayList<String>(0));
        }
        XAdES_EPES xAdES_EPES = (XAdES_EPES)XAdES.newInstance(XAdES.EPES, string5, "xades", "ds", string3, element.getOwnerDocument(), element);
        object3 = (X509Certificate)certificateArray[0];
        xAdES_EPES.setSigningCertificate((X509Certificate)object3);
        XAdESCommonMetadataUtil.addCommonMetadata(xAdES_EPES, properties2);
        if (objectIdentifierImpl != null || string8 != null || string9 != null) {
            object2 = new ArrayList<Transform>();
            object = new DataObjectFormatImpl(null, objectIdentifierImpl, string8, string9, "#" + string11);
            ((ArrayList)object2).add(object);
            xAdES_EPES.setDataObjectFormats((List<DataObjectFormat>)object2);
        }
        object2 = XAdESUtil.getXmlAdvancedSignature(xAdES_EPES, string6, string3, string4);
        if (bl6) {
            ((XMLAdvancedSignature)object2).addXMLObject(xMLObject);
        }
        if (bl4) {
            try {
                XAdESUtil.createManifest(arrayList, xMLSignatureFactory, (AOXMLAdvancedSignature)object2, digestMethod, xMLSignatureFactory.newTransform(string4, (TransformParameterSpec)null), string11);
            }
            catch (Exception exception) {
                throw new AOException("Error creando el algoritmo de canonicalizacion para el MANIFEST: " + exception, exception);
            }
        }
        try {
            boolean bl7 = Boolean.parseBoolean(properties2.getProperty("includeOnlySignningCertificate", Boolean.FALSE.toString()));
            if (bl7) {
                ((XMLAdvancedSignature)object2).sign((X509Certificate)certificateArray[0], privateKey, string2, arrayList, "Signature-" + UUID.randomUUID().toString());
            } else {
                ((AOXMLAdvancedSignature)object2).sign(Arrays.asList(certificateArray), privateKey, string2, arrayList, "Signature-" + UUID.randomUUID().toString(), bl, bl2, bl3, bl5);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UnsupportedOperationException("No se soporta el algoritmo de firma '" + string + "': " + noSuchAlgorithmException, noSuchAlgorithmException);
        }
        catch (Exception exception) {
            throw new AOException("Error al generar la cofirma", exception);
        }
        return Utils.writeXML(element, map, null, null);
    }
}

