/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xades;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;

final class EscapeHelper {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    private EscapeHelper() {
    }

    static List<Certificate> getEscapedCertificates(List<Certificate> list) {
        if (list == null) {
            return new ArrayList<Certificate>(0);
        }
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(i, new EscapedCertificate((X509Certificate)list.get(i)));
        }
        return arrayList;
    }

    static String escapeLdapName(String string) {
        LdapName ldapName;
        try {
            ldapName = new LdapName(string);
        }
        catch (InvalidNameException invalidNameException) {
            LOGGER.warning("No ha sido posible 'escapar' el nombre X.500 " + string + ": " + invalidNameException);
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Rdn rdn : ldapName.getRdns()) {
            stringBuilder.append(rdn.getType());
            stringBuilder.append('=');
            stringBuilder.append(EscapeHelper.escapeCharacters(Rdn.escapeValue(rdn.getValue())));
            stringBuilder.append(",");
        }
        stringBuilder.append("<EOF>");
        return stringBuilder.toString().replace(",<EOF>", "");
    }

    private static String escapeCharacters(String string) {
        return string.replace("\u00e1", "\\C3\\A1").replace("\u00e9", "\\C3\\A9").replace("\u00ed", "\\C3\\AD").replace("\u00f3", "\\C3\\B3").replace("\u00fa", "\\C3\\BA").replace("\u00c1", "\\C3\\81").replace("\u00c9", "\\C3\\89").replace("\u00cd", "\\C3\\8D").replace("\u00d3", "\\C3\\93").replace("\u00da", "\\C3\\9A").replace("\u00f1", "\\C3\\B1").replace("\u00d1", "\\C3\\91").replace("\u00e7", "\\C3\\A7").replace("\u00c7", "\\C3\\87").replace("\u00e0", "\\C3\\A0").replace("\u00e8", "\\C3\\A8").replace("\u00ec", "\\C3\\AC").replace("\u00f2", "\\C3\\B2").replace("\u00f9", "\\C3\\B9").replace("\u00c0", "\\C3\\80").replace("\u00c8", "\\C3\\88").replace("\u00cc", "\\C3\\8C").replace("\u00d2", "\\C3\\92").replace("\u00d9", "\\C3\\99").replace("\u00fc", "\\C3\\BC").replace("\u00dc", "\\C3\\9C").replace("\u00bf", "\\C2\\BF").replace("\u00a1", "\\C2\\A1").replace("\u00b5", "\\C2\\B5").replace("\u00ba", "\\C2\\BA").replace("\u00aa", "\\C2\\AA");
    }

    private static class EscapedCertificate
    extends X509Certificate {
        private final X509Certificate cert;

        private static X500Principal escapePrincipal(Principal principal) {
            return new X500Principal(EscapeHelper.escapeLdapName(principal.toString()));
        }

        EscapedCertificate(X509Certificate x509Certificate) {
            if (x509Certificate == null) {
                throw new IllegalArgumentException("El certificado original no puede ser nulo");
            }
            this.cert = x509Certificate;
        }

        @Override
        public Principal getSubjectDN() {
            return EscapedCertificate.escapePrincipal(this.cert.getSubjectDN());
        }

        @Override
        public X500Principal getSubjectX500Principal() {
            return EscapedCertificate.escapePrincipal(this.cert.getSubjectX500Principal());
        }

        @Override
        public Principal getIssuerDN() {
            return EscapedCertificate.escapePrincipal(this.cert.getIssuerDN());
        }

        @Override
        public X500Principal getIssuerX500Principal() {
            return EscapedCertificate.escapePrincipal(this.cert.getIssuerX500Principal());
        }

        @Override
        public Set<String> getCriticalExtensionOIDs() {
            return this.cert.getCriticalExtensionOIDs();
        }

        @Override
        public byte[] getExtensionValue(String string) {
            return this.cert.getExtensionValue(string);
        }

        @Override
        public Set<String> getNonCriticalExtensionOIDs() {
            return this.cert.getNonCriticalExtensionOIDs();
        }

        @Override
        public boolean hasUnsupportedCriticalExtension() {
            return this.cert.hasUnsupportedCriticalExtension();
        }

        @Override
        public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
            this.cert.checkValidity();
        }

        @Override
        public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
            this.cert.checkValidity(date);
        }

        @Override
        public int getBasicConstraints() {
            return this.cert.getBasicConstraints();
        }

        @Override
        public boolean[] getIssuerUniqueID() {
            return this.cert.getIssuerUniqueID();
        }

        @Override
        public boolean[] getKeyUsage() {
            return this.cert.getKeyUsage();
        }

        @Override
        public Date getNotAfter() {
            return this.cert.getNotAfter();
        }

        @Override
        public Date getNotBefore() {
            return this.cert.getNotBefore();
        }

        @Override
        public BigInteger getSerialNumber() {
            return this.cert.getSerialNumber();
        }

        @Override
        public String getSigAlgName() {
            return this.cert.getSigAlgName();
        }

        @Override
        public String getSigAlgOID() {
            return this.cert.getSigAlgOID();
        }

        @Override
        public byte[] getSigAlgParams() {
            return this.cert.getSigAlgParams();
        }

        @Override
        public byte[] getSignature() {
            return this.cert.getSignature();
        }

        @Override
        public boolean[] getSubjectUniqueID() {
            return this.cert.getSubjectUniqueID();
        }

        @Override
        public byte[] getTBSCertificate() throws CertificateEncodingException {
            return this.cert.getTBSCertificate();
        }

        @Override
        public int getVersion() {
            return this.cert.getVersion();
        }

        @Override
        public byte[] getEncoded() throws CertificateEncodingException {
            return this.cert.getEncoded();
        }

        @Override
        public PublicKey getPublicKey() {
            return this.cert.getPublicKey();
        }

        @Override
        public String toString() {
            return this.cert.toString();
        }

        @Override
        public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            this.cert.verify(publicKey);
        }

        @Override
        public void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            this.cert.verify(publicKey, string);
        }
    }
}

