/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOInvalidFormatException;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.signers.AOSignInfo;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.core.util.tree.AOTreeModel;
import es.gob.afirma.core.util.tree.AOTreeNode;
import es.gob.afirma.signers.xades.XAdESCoSigner;
import es.gob.afirma.signers.xades.XAdESCounterSigner;
import es.gob.afirma.signers.xades.XAdESSigner;
import es.gob.afirma.signers.xades.XAdESTspUtil;
import es.gob.afirma.signers.xades.XAdESUtil;
import es.gob.afirma.signers.xml.Utils;
import es.uji.crypto.xades.jxades.util.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class AOXAdESSigner
implements AOSigner {
    static final Logger LOGGER = Logger.getLogger("es.agob.afirma");
    private static final String ID_IDENTIFIER = "Id";
    public static final String SIGNATURE_TAG = "Signature";
    static final String XADESNS = "http://uri.etsi.org/01903/v1.3.2#";
    static final String XADES_SIGNED_PROPERTIES_TYPE = "http://uri.etsi.org/01903#SignedProperties";
    static final String MANIFESTURI = "http://www.w3.org/2000/09/xmldsig#Manifest";
    static final String AFIRMA = "AFIRMA";
    static final String XML_SIGNATURE_PREFIX = "ds";
    static final String XADES_SIGNATURE_PREFIX = "xades";
    static final String SIGNATURE_NODE_NAME = "ds:Signature";
    static final String DETACHED_CONTENT_ELEMENT_NAME = "CONTENT";
    static final String DETACHED_STYLE_ELEMENT_NAME = "STYLE";
    static final String DIGEST_METHOD = "http://www.w3.org/2001/04/xmlenc#sha512";
    static final String STYLE_REFERENCE_PREFIX = "StyleReference-";
    static final String XMLDSIG_ATTR_MIMETYPE_STR = "MimeType";
    static final String XMLDSIG_ATTR_ENCODING_STR = "Encoding";

    @Override
    public byte[] sign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        return XAdESTspUtil.timestampXAdES(XAdESSigner.sign(byArray, string, privateKey, certificateArray, properties), properties);
    }

    public static boolean isDetached(Element element) {
        if (element == null) {
            return false;
        }
        try {
            String string = null;
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getNodeName().equals(SIGNATURE_TAG)) continue;
                string = ((Element)nodeList.item(i)).getAttribute(ID_IDENTIFIER);
                break;
            }
            if (string == null || string.length() == 0) {
                return false;
            }
            NodeList nodeList2 = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Reference");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                if (!((Element)nodeList2.item(i)).getAttribute("URI").equals('#' + string)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public static boolean isEnveloped(Element element) {
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Transform");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!((Element)nodeList.item(i)).getAttribute("Algorithm").equals("http://www.w3.org/2000/09/xmldsig#enveloped-signature")) continue;
            return true;
        }
        return false;
    }

    public static boolean isEnveloping(Element element) {
        return element.getLocalName().equals(SIGNATURE_TAG) || element.getLocalName().equals(AFIRMA) && element.getFirstChild().getLocalName().equals(SIGNATURE_TAG);
    }

    @Override
    public byte[] getData(byte[] byArray) throws AOInvalidFormatException {
        Object object;
        Element element;
        block8: {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            element = null;
            try {
                if (!this.isSign(byArray)) {
                    throw new AOInvalidFormatException("El documento no es un documento de firmas valido.");
                }
                Element element2 = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray)).getDocumentElement();
                if (AOXAdESSigner.isDetached(element2)) {
                    object = (Element)element2.getFirstChild();
                    if (object.getFirstChild().getNodeType() == 3) {
                        return AOXAdESSigner.isBase64TransformationDeclared(element2, object.getAttribute(ID_IDENTIFIER)) ? Base64.decode(object.getTextContent()) : object.getTextContent().getBytes();
                    }
                    element = (Element)object.getFirstChild();
                    break block8;
                }
                if (AOXAdESSigner.isEnveloped(element2)) {
                    this.removeEnvelopedSignatures(element2);
                    element = element2;
                    break block8;
                }
                if (!AOXAdESSigner.isEnveloping(element2)) break block8;
                object = (Element)element2.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Object").item(0);
                if (object.getAttribute(XMLDSIG_ATTR_MIMETYPE_STR).equals("text/xml")) {
                    element = (Element)object.getFirstChild();
                    break block8;
                }
                return AOXAdESSigner.isBase64TransformationDeclared(element2, object.getAttribute(ID_IDENTIFIER)) ? Base64.decode(object.getTextContent()) : object.getTextContent().getBytes();
            }
            catch (Exception exception) {
                throw new AOInvalidFormatException("Error al leer el fichero de firmas: " + exception, exception);
            }
        }
        if (element == null) {
            return null;
        }
        object = new ByteArrayOutputStream();
        XMLUtils.writeXML((OutputStream)object, (Node)element, false);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    private void removeEnvelopedSignatures(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1 || !nodeList.item(i).getNodeName().endsWith(":Signature")) continue;
            element.removeChild(nodeList.item(i));
            this.removeEnvelopedSignatures(element);
            return;
        }
    }

    private static boolean isBase64TransformationDeclared(Element element, String string) {
        if (string == null || string.trim().equals("")) {
            return false;
        }
        Element element2 = null;
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Reference");
        for (int i = 0; !(i >= nodeList.getLength() || (element2 = (Element)nodeList.item(i)).hasAttribute("URI") && ("#" + string).equals(element2.getAttribute("URI"))); ++i) {
            element2 = null;
        }
        if (element2 != null) {
            NodeList nodeList2 = element2.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Transform");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                if (!((Element)nodeList2.item(i)).hasAttribute("Algorithm") || !"http://www.w3.org/2000/09/xmldsig#base64".equals(((Element)nodeList2.item(i)).getAttribute("Algorithm"))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public byte[] cosign(byte[] byArray, byte[] byArray2, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        return XAdESCoSigner.cosign(byArray2, string, privateKey, certificateArray, properties);
    }

    @Override
    public byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        if (!this.isSign(byArray)) {
            throw new AOInvalidFormatException("No se ha indicado una firma XAdES para cofirmar");
        }
        return XAdESCoSigner.cosign(byArray, string, privateKey, certificateArray, properties);
    }

    @Override
    public byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        if (!this.isSign(byArray)) {
            throw new AOInvalidFormatException("No se ha indicado una firma XAdES para contrafirmar");
        }
        return XAdESCounterSigner.countersign(byArray, string, counterSignTarget, objectArray, privateKey, certificateArray, properties);
    }

    @Override
    public AOTreeModel getSignersStructure(byte[] byArray, boolean bl) throws AOInvalidFormatException {
        Document document;
        if (!this.isSign(byArray)) {
            throw new AOInvalidFormatException("Los datos indicados no son una firma XAdES compatible");
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
        }
        catch (Exception exception) {
            LOGGER.warning("Se ha producido un error al obtener la estructura de firmas: " + exception);
            return null;
        }
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_TAG);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<AOTreeNode> arrayList3 = new ArrayList<AOTreeNode>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            arrayList.add(element.getAttribute(ID_IDENTIFIER));
            arrayList3.add(new AOTreeNode(bl ? Utils.getSimpleSignInfoNode(XAdESUtil.guessXAdESNamespaceURL(document.getDocumentElement()), element) : Utils.getStringInfoNode(element)));
            if (element.getParentNode().getNodeName().equals("xades:CounterSignature")) {
                arrayList2.add(Utils.getCounterSignerReferenceId(element, document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureValue")));
                continue;
            }
            arrayList2.add("");
        }
        AOTreeNode aOTreeNode = new AOTreeNode("Datos");
        for (int i = 0; i < arrayList2.size(); ++i) {
            if (!((String)arrayList2.get(i)).equals("")) continue;
            aOTreeNode.add(this.generateSignsTree(i, nodeList.getLength() - 1, arrayList3, arrayList, arrayList2)[i]);
        }
        return new AOTreeModel(aOTreeNode);
    }

    private AOTreeNode[] generateSignsTree(int n, int n2, List<AOTreeNode> list, List<String> list2, List<String> list3) {
        int n3 = list2.size();
        if (n < n3 && n2 > 0) {
            if (list2.get(n).equals(list3.get(n2))) {
                this.generateSignsTree(n + 1, n2 - 1, list, list2, list3);
            }
            if (n < n2) {
                this.generateSignsTree(n, n2 - 1, list, list2, list3);
            }
            if (!list2.get(n).equals(list3.get(n2))) {
                return list.toArray(new AOTreeNode[0]);
            }
            this.generateSignsTree(n2, n3 - 1, list, list2, list3);
            list.get(n).add(list.get(n2));
        }
        return list.toArray(new AOTreeNode[0]);
    }

    @Override
    public boolean isSign(byte[] byArray) {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            Element element = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray)).getDocumentElement();
            ArrayList<Node> arrayList = new ArrayList<Node>();
            if (element.getNodeName().equals(SIGNATURE_NODE_NAME)) {
                arrayList.add(element);
            }
            NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_TAG);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                arrayList.add(nodeList.item(i));
            }
            if (arrayList.size() == 0 || !XAdESUtil.checkSignNodes(arrayList)) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidDataFile(byte[] byArray) {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        return true;
    }

    @Override
    public String getSignedName(String string, String string2) {
        return string + (string2 != null ? string2 : "") + ".xsig";
    }

    static Document insertarNodoAfirma(Document document) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document2 = documentBuilderFactory.newDocumentBuilder().newDocument();
        Element element = document2.createElement(AFIRMA);
        element.setAttributeNS(null, ID_IDENTIFIER, "AfirmaRoot-" + UUID.randomUUID().toString());
        element.appendChild(document2.adoptNode(document.getDocumentElement()));
        document2.appendChild(element);
        return document2;
    }

    @Override
    public AOSignInfo getSignInfo(byte[] byArray) throws AOException {
        if (byArray == null) {
            throw new IllegalArgumentException("No se han introducido datos para analizar");
        }
        if (!this.isSign(byArray)) {
            throw new AOInvalidFormatException("Los datos introducidos no se corresponden con un objeto de firma");
        }
        AOSignInfo aOSignInfo = new AOSignInfo("XAdES");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Element element = null;
        try {
            element = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray)).getDocumentElement();
        }
        catch (Exception exception) {
            LOGGER.warning("Error al analizar la firma: " + exception);
            element = null;
        }
        if (element != null) {
            if (AOXAdESSigner.isDetached(element)) {
                aOSignInfo.setVariant("XAdES Detached");
            } else if (AOXAdESSigner.isEnveloped(element)) {
                aOSignInfo.setVariant("XAdES Enveloped");
            } else if (AOXAdESSigner.isEnveloping(element)) {
                aOSignInfo.setVariant("XAdES Enveloping");
            }
        }
        return aOSignInfo;
    }

    static {
        Utils.installXmlDSigProvider(true);
    }
}

