/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.tsp.pkcs7;

import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.signers.tsp.pkcs7.TsaRequestExtension;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import java.util.logging.Logger;

public final class TsaParams {
    private static final String DEFAULT_DIGEST_ALGO = "SHA-512";
    private static final String DEFAULT_POLICY = "0.4.0.2023.1.1";
    public static final String TS_SIGN = "1";
    public static final String TS_DOC = "2";
    public static final String TS_SIGN_DOC = "3";
    private final boolean tsaRequireCert;
    private final String tsaPolicy;
    private final URI tsaURL;
    private final String tsaUsr;
    private final String tsaPwd;
    private final TsaRequestExtension[] extensions;
    private final String tsaHashAlgorithm;
    private final byte[] sslKeyStore;
    private final String sslKeyStorePassword;
    private final String sslKeyStoreType;
    private final byte[] sslTrustStore;
    private final String sslTrustStorePassword;
    private final String sslTrustStoreType;
    private final boolean verifyHostname;
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    public TsaParams(boolean bl, String string, URI uRI, String string2, String string3, TsaRequestExtension[] tsaRequestExtensionArray, String string4, byte[] byArray, String string5, String string6, byte[] byArray2, String string7, String string8, boolean bl2) {
        if (uRI == null) {
            throw new IllegalArgumentException("La URL del servidor de sello de tiempo no puede ser nula");
        }
        this.tsaURL = uRI;
        this.tsaPolicy = string != null ? string : DEFAULT_POLICY;
        this.tsaUsr = string2;
        this.tsaPwd = string3;
        this.extensions = tsaRequestExtensionArray != null ? (TsaRequestExtension[])tsaRequestExtensionArray.clone() : null;
        this.tsaHashAlgorithm = string4 != null ? string4 : DEFAULT_DIGEST_ALGO;
        this.sslKeyStore = byArray != null ? (byte[])byArray.clone() : null;
        this.sslKeyStorePassword = string5;
        this.sslKeyStoreType = string6;
        this.sslTrustStore = byArray2 != null ? (byte[])byArray2.clone() : null;
        this.sslTrustStorePassword = string7;
        this.sslTrustStoreType = string8;
        this.tsaRequireCert = bl;
        this.verifyHostname = bl2;
    }

    public TsaParams(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("La propiedades de configuracion de la TSA no pueden ser nulas");
        }
        String string = properties.getProperty("tsaURL");
        if (string == null) {
            throw new IllegalArgumentException("La URL del servidor de sello de tiempo no puede ser nula");
        }
        try {
            this.tsaURL = new URI(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Se ha indicado una URL de TSA invalida (" + string + "): " + exception, exception);
        }
        this.tsaPolicy = properties.containsKey("tsaPolicy") ? properties.getProperty("tsaPolicy") : DEFAULT_POLICY;
        this.tsaHashAlgorithm = properties.containsKey("tsaHashAlgorithm") ? AOSignConstants.getDigestAlgorithmName(properties.getProperty("tsaHashAlgorithm")) : DEFAULT_DIGEST_ALGO;
        this.tsaRequireCert = !Boolean.FALSE.toString().equalsIgnoreCase(properties.getProperty("tsaRequireCert"));
        this.tsaUsr = properties.getProperty("tsaUsr");
        this.tsaPwd = properties.getProperty("tsaPwd");
        String string2 = properties.getProperty("tsaSslKeyStore");
        if (string2 != null) {
            try {
                this.sslKeyStore = Base64.decode(string2);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("No se ha proporcionado en el parametro 'tsaSslKeyStore' el almacen de claves del SSL de la TSA en base 64: " + exception, exception);
            }
        } else {
            this.sslKeyStore = null;
        }
        this.sslKeyStorePassword = properties.getProperty("tsaSslKeyStorePassword", "");
        this.sslKeyStoreType = properties.getProperty("tsaSslKeyStoreType", "PKCS12");
        String string3 = properties.getProperty("tsaSslTrustStore");
        if (string3 != null) {
            try {
                this.sslTrustStore = Base64.decode(string3);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("No se ha proporcionado en el parametro 'tsaSslTrustStore' el almacen de confianza del SSL de la TSA en base 64: " + exception, exception);
            }
        } else {
            this.sslTrustStore = null;
        }
        this.sslTrustStorePassword = properties.getProperty("tsaSslTrustStorePassword", "");
        this.sslTrustStoreType = properties.getProperty("tsaSslTrustStoreType", "PKCS12");
        try {
            this.extensions = TsaParams.getExtensions(properties);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Las extensiones del sello de tiempo no estan adecuadamente codificadas: " + iOException, iOException);
        }
        this.verifyHostname = Boolean.parseBoolean(properties.getProperty("verifyHostname", Boolean.TRUE.toString()));
    }

    boolean doTsaRequireCert() {
        return this.tsaRequireCert;
    }

    String getTsaPolicy() {
        return this.tsaPolicy;
    }

    public URI getTsaUrl() {
        return this.tsaURL;
    }

    String getTsaUsr() {
        return this.tsaUsr;
    }

    String getTsaPwd() {
        return this.tsaPwd;
    }

    TsaRequestExtension[] getExtensions() {
        return this.extensions;
    }

    private static TsaRequestExtension[] getExtensions(Properties properties) throws IOException {
        String string = properties.getProperty("tsaExtensionOid");
        String string2 = properties.getProperty("tsaExtensionValueBase64");
        boolean bl = Boolean.parseBoolean(properties.getProperty("tsaExtensionCritical", Boolean.FALSE.toString()));
        if (string == null && string2 == null) {
            return null;
        }
        if (string != null && string2 == null) {
            LOGGER.warning("Se ignorara el parametro 'tsaExtensionOid' ya que no se configuro el parametro 'tsaExtensionValueBase64'");
            return null;
        }
        if (string == null && string2 != null) {
            LOGGER.warning("Se ignorara el parametro 'tsaExtensionValueBase64' ya que no se configuro el parametro 'tsaExtensionOid'");
            return null;
        }
        return new TsaRequestExtension[]{new TsaRequestExtension(string, bl, Base64.decode(string2))};
    }

    public String getTsaHashAlgorithm() {
        return this.tsaHashAlgorithm;
    }

    public byte[] getSslKeyStore() {
        return this.sslKeyStore;
    }

    public String getSslKeyStorePassword() {
        return this.sslKeyStorePassword;
    }

    public String getSslKeyStoreType() {
        return this.sslKeyStoreType;
    }

    public byte[] getSslTrustStore() {
        return this.sslTrustStore;
    }

    public String getSslTrustStorePassword() {
        return this.sslTrustStorePassword;
    }

    public String getSslTrustStoreType() {
        return this.sslTrustStoreType;
    }

    public boolean isVerifyHostname() {
        return this.verifyHostname;
    }

    public Properties getExtraParams() {
        Properties properties = new Properties();
        if (this.getTsaUrl() != null) {
            properties.put("tsaURL", this.getTsaUrl().toString());
        }
        if (this.getTsaUsr() != null && !this.getTsaUsr().isEmpty()) {
            properties.put("tsaUsr", this.getTsaUsr().toString());
        }
        if (this.getTsaPwd() != null && !this.getTsaPwd().isEmpty()) {
            properties.put("tsaPwd", this.getTsaPwd().toString());
        }
        if (this.getTsaPolicy() != null && !this.getTsaPolicy().isEmpty()) {
            properties.put("tsaPwd", this.getTsaPolicy().toString());
        }
        if (this.getExtensions() != null && this.getExtensions().length > 0) {
            properties.put("tsaExtensionOid", this.getExtensions()[0].getOid());
            properties.put("tsaExtensionValueBase64", Base64.encode(this.getExtensions()[0].getValue()));
            properties.put("tsaExtensionCritical", Boolean.toString(this.getExtensions()[0].isCritical()));
        }
        if (this.getTsaHashAlgorithm() != null && !this.getTsaHashAlgorithm().isEmpty()) {
            properties.put("tsaHashAlgorithm", this.getTsaHashAlgorithm());
        }
        if (this.getSslKeyStore() != null && this.getSslKeyStore().length > 0) {
            properties.put("tsaSslKeyStore", Base64.encode(this.getSslKeyStore()));
            properties.put("tsaSslKeyStorePassword", this.getSslKeyStorePassword());
            properties.put("tsaSslKeyStoreType", this.getSslKeyStoreType());
        }
        if (this.getSslTrustStore() != null && this.getSslTrustStore().length > 0) {
            properties.put("tsaSslTrustStore", Base64.encode(this.getSslTrustStore()));
            properties.put("tsaSslTrustStorePassword", this.getSslTrustStorePassword());
            properties.put("tsaSslTrustStoreType", this.getSslTrustStoreType());
        }
        properties.put("verifyHostname", Boolean.toString(this.isVerifyHostname()));
        return properties;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        if (this.extensions != null) {
            for (TsaRequestExtension tsaRequestExtension : this.extensions) {
                stringBuilder.append(tsaRequestExtension);
                stringBuilder.append("; ");
            }
        }
        stringBuilder.append("]");
        String string = "Parametros TSA [URL=" + this.getTsaUrl() + "; User=" + this.getTsaUsr() + ": Policy=" + this.getTsaPolicy() + "; Extensions" + stringBuilder.toString() + "; Digest=" + this.getTsaHashAlgorithm() + "; SSLKeyStore=" + (this.getSslKeyStore() != null ? "Yes" : "No") + "; SSLKeyStorePwd=" + this.getSslKeyStorePassword() + "SSLKeyStoreType=" + this.getSslKeyStoreType() + "SSLTrustStore=" + (this.getSslTrustStore() != null ? "Yes" : "No") + "; SSLTrustStorePwd=" + this.getSslTrustStorePassword() + "SSLTrustStoreType=" + this.getSslTrustStoreType() + "VerifyHostname=" + this.isVerifyHostname() + "]";
        return string.replace("]; ]", "]]");
    }
}

