/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.tsp.pkcs7;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.tsp.pkcs7.TsaParams;
import es.gob.afirma.signers.tsp.pkcs7.TsaRequestExtension;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.Socket;
import java.net.URI;
import java.net.URLConnection;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.spongycastle.asn1.ASN1InputStream;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1Set;
import org.spongycastle.asn1.DERSet;
import org.spongycastle.asn1.cmp.PKIFailureInfo;
import org.spongycastle.asn1.cms.Attribute;
import org.spongycastle.asn1.cms.AttributeTable;
import org.spongycastle.asn1.x509.X509ObjectIdentifiers;
import org.spongycastle.cms.CMSSignedData;
import org.spongycastle.cms.SignerInformation;
import org.spongycastle.cms.SignerInformationStore;
import org.spongycastle.tsp.TimeStampRequest;
import org.spongycastle.tsp.TimeStampRequestGenerator;
import org.spongycastle.tsp.TimeStampResponse;
import org.spongycastle.tsp.TimeStampToken;

public final class CMSTimestamper {
    private static final String SIGNATURE_TIMESTAMP_TOKEN_OID = "1.2.840.113549.1.9.16.2.14";
    private static final int SOCKET_TIMEOUT = 500000;
    private static final String STORE_TYPE_PKCS12 = "PKCS12";
    static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private final TimeStampRequestGenerator tsqGenerator = new TimeStampRequestGenerator();
    private final URI tsaURL;
    private final String tsaUsername;
    private final String tsaPassword;
    private byte[] sslKeyStoreFile = null;
    private String sslKeyStorePassword = null;
    private String sslKeyStoreType = null;
    private byte[] sslTrustStoreFile = null;
    private String sslTrustStorePassword = null;
    private String sslTrustStoreType = null;
    private boolean verifyHostname = true;

    public CMSTimestamper(boolean bl, String string, URI uRI, String string2, String string3, TsaRequestExtension[] tsaRequestExtensionArray, byte[] byArray, String string4) {
        this(bl, string, uRI, string2, string3, tsaRequestExtensionArray, byArray, string4, STORE_TYPE_PKCS12, null, null, null, false);
    }

    public CMSTimestamper(boolean bl, String string, URI uRI, String string2, String string3, TsaRequestExtension[] tsaRequestExtensionArray, byte[] byArray, String string4, String string5, byte[] byArray2, String string6, String string7, boolean bl2) {
        if (tsaRequestExtensionArray != null) {
            for (TsaRequestExtension tsaRequestExtension : tsaRequestExtensionArray) {
                this.tsqGenerator.addExtension(new ASN1ObjectIdentifier(tsaRequestExtension.getOid()), tsaRequestExtension.isCritical(), tsaRequestExtension.getValue());
                LOGGER.info("Anadida extension a la solicitud de sello de tiempo: " + tsaRequestExtension);
            }
        }
        this.tsqGenerator.setCertReq(bl);
        this.tsqGenerator.setReqPolicy(new ASN1ObjectIdentifier(string));
        this.tsaURL = uRI;
        this.tsaPassword = string3;
        this.tsaUsername = string2;
        this.sslKeyStoreFile = byArray != null ? (byte[])byArray.clone() : null;
        this.sslKeyStorePassword = string4;
        this.sslKeyStoreType = string5;
        this.sslTrustStoreFile = byArray2 != null ? (byte[])byArray2.clone() : null;
        this.sslTrustStorePassword = string6;
        this.sslTrustStoreType = string7;
        this.verifyHostname = bl2;
    }

    public CMSTimestamper(TsaParams tsaParams) {
        this(tsaParams.doTsaRequireCert(), tsaParams.getTsaPolicy(), tsaParams.getTsaUrl(), tsaParams.getTsaUsr(), tsaParams.getTsaPwd(), tsaParams.getExtensions(), tsaParams.getSslKeyStore(), tsaParams.getSslKeyStorePassword(), tsaParams.getSslKeyStoreType(), tsaParams.getSslTrustStore(), tsaParams.getSslTrustStorePassword(), tsaParams.getSslTrustStoreType(), tsaParams.isVerifyHostname());
    }

    public byte[] addTimestamp(byte[] byArray, String string, Calendar calendar) throws NoSuchAlgorithmException, AOException, IOException {
        CMSSignedData cMSSignedData;
        String string2 = AOSignConstants.getDigestAlgorithmName(string);
        try {
            cMSSignedData = new CMSSignedData(byArray);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Los datos de entrada no son un SignedData de CMS: " + exception);
        }
        SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
        ArrayList<SignerInformation> arrayList = new ArrayList<SignerInformation>();
        Collection<SignerInformation> collection = signerInformationStore.getSigners();
        Iterator<SignerInformation> iterator = collection.iterator();
        while (iterator.hasNext()) {
            ASN1Primitive aSN1Primitive;
            SignerInformation signerInformation;
            SignerInformation signerInformation2 = signerInformation = iterator.next();
            byte[] byArray2 = this.getTimeStampToken(MessageDigest.getInstance(string2).digest(signerInformation2.getSignature()), string2, calendar);
            Object object = new ASN1InputStream(new ByteArrayInputStream(byArray2));
            Object object2 = null;
            try {
                aSN1Primitive = ((ASN1InputStream)object).readObject();
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (object != null) {
                    if (object2 != null) {
                        try {
                            ((FilterInputStream)object).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ((FilterInputStream)object).close();
                    }
                }
            }
            object = new DERSet(aSN1Primitive);
            object2 = new Attribute(new ASN1ObjectIdentifier(SIGNATURE_TIMESTAMP_TOKEN_OID), (ASN1Set)object);
            Hashtable<ASN1ObjectIdentifier, Object> hashtable = new Hashtable<ASN1ObjectIdentifier, Object>();
            hashtable.put(new ASN1ObjectIdentifier(SIGNATURE_TIMESTAMP_TOKEN_OID), object2);
            AttributeTable attributeTable = new AttributeTable(hashtable);
            arrayList.add(SignerInformation.replaceUnsignedAttributes(signerInformation2, attributeTable));
        }
        return CMSSignedData.replaceSigners(cMSSignedData, new SignerInformationStore(arrayList)).getEncoded();
    }

    private byte[] getTSAResponse(byte[] byArray) throws IOException {
        if (this.tsaURL.getScheme().equals("socket")) {
            return this.getTSAResponseSocket(byArray);
        }
        if (this.tsaURL.getScheme().equals("http")) {
            return this.getTSAResponseHttp(byArray);
        }
        if (this.tsaURL.getScheme().equals("https")) {
            return this.getTSAResponseHttps(byArray);
        }
        throw new UnsupportedOperationException("Protocolo de conexion con TSA no soportado: " + this.tsaURL.getScheme());
    }

    private byte[] getTSAResponseSocket(byte[] byArray) throws IOException {
        try (Socket socket = new Socket(this.tsaURL.getHost(), this.tsaURL.getPort());){
            socket.setSoTimeout(500000);
            byte[] byArray2 = CMSTimestamper.getTSAResponseExternalSocket(byArray, socket);
            return byArray2;
        }
    }

    private static byte[] getTSAResponseExternalSocket(byte[] byArray, Socket socket) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
        dataOutputStream.writeInt(byArray.length + 1);
        dataOutputStream.writeByte(0);
        dataOutputStream.write(byArray);
        dataOutputStream.flush();
        socket.getOutputStream().flush();
        DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
        int n = dataInputStream.readInt();
        byte by = dataInputStream.readByte();
        byte[] byArray2 = new byte[n - 1];
        dataInputStream.readFully(byArray2);
        if (by != 5 && by != 6) {
            throw new IOException("Obtenida resuesta incorrecta del servidor TSA: " + new String(byArray2));
        }
        socket.close();
        return byArray2;
    }

    private byte[] getTSAResponseHttp(byte[] byArray) throws IOException {
        return CMSTimestamper.getTSAResponseHttp(byArray, this.prepareConnection(false));
    }

    private byte[] getTSAResponseHttps(byte[] byArray) throws IOException {
        return CMSTimestamper.getTSAResponseHttp(byArray, this.prepareConnection(true));
    }

    private static byte[] getTSAResponseHttp(byte[] byArray, URLConnection uRLConnection) throws IOException {
        Object object = uRLConnection.getOutputStream();
        Object object2 = null;
        try {
            ((OutputStream)object).write(byArray);
            ((OutputStream)object).flush();
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        ((OutputStream)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    ((OutputStream)object).close();
                }
            }
        }
        object = AOUtil.getDataFromInputStream(uRLConnection.getInputStream());
        object2 = uRLConnection.getContentEncoding();
        if (object2 != null && ((String)object2).equalsIgnoreCase("base64")) {
            return Base64.decode(new String((byte[])object));
        }
        return object;
    }

    private URLConnection prepareConnection(boolean bl) throws IOException {
        URLConnection uRLConnection = this.tsaURL.toURL().openConnection();
        uRLConnection.setDoInput(true);
        uRLConnection.setDoOutput(true);
        uRLConnection.setUseCaches(false);
        uRLConnection.setRequestProperty("Content-Type", "application/timestamp-query");
        uRLConnection.setRequestProperty("Content-Transfer-Encoding", "binary");
        if (bl) {
            this.configureHttpsConnection(uRLConnection);
        }
        if (this.tsaUsername != null && !this.tsaUsername.isEmpty()) {
            String string = this.tsaUsername + ":" + this.tsaPassword;
            uRLConnection.setRequestProperty("Authorization", "Basic " + new String(Base64.encode(string.getBytes())));
        }
        return uRLConnection;
    }

    private void configureHttpsConnection(URLConnection uRLConnection) throws IOException {
        Object object;
        TrustManager[] trustManagerArray;
        SSLContext sSLContext;
        if (uRLConnection == null) {
            throw new IllegalArgumentException("La conexion no puede ser nula");
        }
        if (!this.verifyHostname) {
            LOGGER.warning("No se comprobaran los nombres de host en la conexion SSL del sello de tiempo");
            if (uRLConnection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)uRLConnection).setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String string, SSLSession sSLSession) {
                        return true;
                    }
                });
            } else {
                LOGGER.warning("No se ha podido deshabilitar la comprobacion de nombre de host, tipo desconocido de conexion: " + uRLConnection.getClass().getName());
            }
        }
        try {
            sSLContext = SSLContext.getInstance("TLS");
        }
        catch (Exception exception) {
            throw new IOException("No se ha podido obtener el contexto de seguridad SSL: " + exception, exception);
        }
        KeyManager[] keyManagerArray = null;
        if (this.sslKeyStoreFile != null && this.sslKeyStorePassword != null) {
            try {
                trustManagerArray = KeyStore.getInstance(this.sslKeyStoreType == null ? "JKS" : this.sslKeyStoreType);
                trustManagerArray.load(new ByteArrayInputStream(this.sslKeyStoreFile), this.sslKeyStorePassword.toCharArray());
                object = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                ((KeyManagerFactory)object).init((KeyStore)trustManagerArray, this.sslKeyStorePassword.toCharArray());
                keyManagerArray = ((KeyManagerFactory)object).getKeyManagers();
            }
            catch (Exception exception) {
                throw new IOException("Error obteniendo el almacen de certificados cliente para el SSL: " + exception, exception);
            }
        }
        trustManagerArray = null;
        if (this.sslTrustStoreFile != null && this.sslTrustStorePassword != null) {
            try {
                object = KeyStore.getInstance(this.sslTrustStoreType == null ? "JKS" : this.sslTrustStoreType);
                ((KeyStore)object).load(new ByteArrayInputStream(this.sslTrustStoreFile), this.sslTrustStorePassword.toCharArray());
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init((KeyStore)object);
                trustManagerArray = trustManagerFactory.getTrustManagers();
            }
            catch (Exception exception) {
                throw new IOException("Error obteniendo el almacen de confianza con los certificados de CA con los que se configuro la SSL: " + exception, exception);
            }
        } else {
            trustManagerArray = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
        }
        try {
            sSLContext.init(keyManagerArray, trustManagerArray, null);
        }
        catch (Exception exception) {
            throw new IOException("Error creando el gestor de seguridad SSL: " + exception, exception);
        }
        try {
            object = uRLConnection.getClass().getMethod("setSSLSocketFactory", SSLSocketFactory.class);
            ((Method)object).invoke((Object)uRLConnection, sSLContext.getSocketFactory());
        }
        catch (Exception exception) {
            LOGGER.severe("Error en la configuracion del acceso a la URL sobre SSL");
            throw new IOException("Error en la configuracion del acceso a la URL sobre SSL", exception);
        }
    }

    public byte[] getTimeStampToken(byte[] byArray, String string, Calendar calendar) throws AOException, IOException {
        int n;
        TimeStampResponse timeStampResponse;
        TimeStampRequest timeStampRequest = this.tsqGenerator.generate(new ASN1ObjectIdentifier(string != null ? AOAlgorithmID.getOID(string) : X509ObjectIdentifiers.id_SHA1.getId()), byArray, BigInteger.valueOf(calendar != null ? calendar.getTimeInMillis() : System.currentTimeMillis()));
        byte[] byArray2 = timeStampRequest.getEncoded();
        byte[] byArray3 = this.getTSAResponse(byArray2);
        try {
            timeStampResponse = new TimeStampResponse(byArray3);
        }
        catch (Exception exception) {
            LOGGER.severe("Respuesta de la TSA: " + new String(byArray3));
            throw new AOException("Error obteniendo la respuesta de la TSA: " + exception, exception);
        }
        try {
            timeStampResponse.validate(timeStampRequest);
        }
        catch (Exception exception) {
            throw new AOException("Error validando la respuesta de la TSA: " + exception, exception);
        }
        PKIFailureInfo pKIFailureInfo = timeStampResponse.getFailInfo();
        int n2 = n = pKIFailureInfo == null ? 0 : pKIFailureInfo.intValue();
        if (n != 0) {
            throw new AOException("Respuesta invalida de la TSA ('" + this.tsaURL + "') con el codigo " + n);
        }
        TimeStampToken timeStampToken = timeStampResponse.getTimeStampToken();
        if (timeStampToken == null) {
            throw new AOException("La respuesta de la TSA ('" + this.tsaURL + "') no es un sello de tiempo valido: " + new String(byArray3));
        }
        return timeStampToken.getEncoded();
    }
}

